/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.ExpressionUtil;
import org.bbop.expression.JexlContext;
import org.bbop.expression.context.HashMapContext;
import org.bbop.swing.ComponentNameResolver;
import org.bbop.swing.SpringUtilities;
import org.bbop.swing.XMLLayoutComponent;
import org.bbop.swing.XMLLayoutPanel;
import org.bbop.swing.XMLLayoutRoot;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLLayout {
    protected static final Logger logger = Logger.getLogger(XMLLayout.class);
    protected static final Map<String, Color> namedColors = new HashMap<String, Color>();
    protected boolean cached = false;
    protected LayoutItem root;
    protected Collection windows = new LinkedList();
    protected ComponentNameResolver resolver;
    protected JexlContext context;
    protected Color defaultTabColor;
    protected Color defaultBGColor;
    protected Font defaultFont;
    protected boolean suppressExpressionExceptions = false;
    protected String xml = "";
    protected XMLLayoutRoot layoutRoot = null;

    public void setSuppressExpressionExceptions(boolean suppressExpressionExceptions) {
        this.suppressExpressionExceptions = suppressExpressionExceptions;
    }

    public Color getDefaultTabColor() {
        return this.defaultTabColor;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setLayout(String xml) {
        if (!xml.trim().startsWith("<xmllayout>")) {
            xml = "<xmllayout>" + xml + "</xmllayout>";
        }
        this.xml = xml;
    }

    public Collection getWindows() throws SAXException, IOException {
        if (!this.cached) {
            this.cacheLayout();
            this.cached = true;
        }
        return this.windows;
    }

    public LayoutItem getRoot() throws SAXException, IOException {
        if (!this.cached) {
            this.cacheLayout();
            this.cached = true;
        }
        return this.root;
    }

    public void validateLayout() throws SAXException, ExpressionException, IOException {
        this.createLayoutBuilder(false);
        this.cacheLayout();
        for (Object o : this.root.getComponents()) {
            if (!(o instanceof XMLLayoutComponent)) continue;
            ((XMLLayoutComponent)o).guiupdate();
        }
    }

    public LayoutBuilder createLayoutBuilder(boolean suppressExpressionExceptions) throws SAXException, IOException {
        XMLReader parser = null;
        try {
            parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException ex) {
            parser = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
        }
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        layoutBuilder.setSuppressExpressionExceptions(suppressExpressionExceptions);
        layoutBuilder.setComponentNameResolver(this.resolver);
        layoutBuilder.setContext(this.context);
        layoutBuilder.setDefaultTabColor(this.defaultTabColor);
        layoutBuilder.setDefaultBGColor(this.defaultBGColor);
        layoutBuilder.setDefaultFont(this.defaultFont);
        parser.setContentHandler(layoutBuilder);
        parser.parse(XMLLayout.getDocument(this.xml));
        return layoutBuilder;
    }

    protected void cacheLayout() throws SAXException, IOException {
        LayoutBuilder layoutBuilder = this.createLayoutBuilder(this.suppressExpressionExceptions);
        this.root = layoutBuilder.getRoot();
        this.root.setLayoutRoot(this.layoutRoot);
        this.windows = layoutBuilder.getWindows();
        for (LayoutItem item : this.windows) {
            item.setLayoutRoot(this.layoutRoot);
        }
    }

    public void setDefaultTabColor(Color defaultTabColor) {
        this.defaultTabColor = defaultTabColor;
        this.cached = false;
    }

    public void setDefaultBGColor(Color defaultBGColor) {
        this.defaultBGColor = defaultBGColor;
        this.cached = false;
    }

    public Color getDefaultBGColor() {
        return this.defaultBGColor;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
        this.cached = false;
    }

    public void setContext(JexlContext context) {
        if (context == null) {
            context = new HashMapContext();
        }
        this.context = context;
        this.cached = false;
    }

    public JexlContext getContext() {
        return this.context;
    }

    public void setComponentNameResolver(ComponentNameResolver resolver) {
        this.resolver = resolver;
        this.cached = false;
    }

    public ComponentNameResolver getComponentNameResolver() {
        return this.resolver;
    }

    protected static Color decodeColor(String colorStr) {
        Color color = namedColors.get(colorStr);
        if (color == null) {
            int i;
            StringTokenizer tokenizer = new StringTokenizer(colorStr, ",");
            int[] rgb = new int[3];
            boolean failed = false;
            for (i = 0; tokenizer.hasMoreElements() && i < rgb.length; ++i) {
                String token = tokenizer.nextToken().trim();
                try {
                    rgb[i] = Integer.parseInt(token);
                    continue;
                }
                catch (NumberFormatException ex) {
                    failed = true;
                    break;
                }
            }
            if (!failed && i == rgb.length && !tokenizer.hasMoreElements()) {
                color = new Color(rgb[0], rgb[1], rgb[2]);
            } else {
                try {
                    color = Color.decode(colorStr);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return color;
    }

    public static InputSource getDocument(String layout) {
        return new InputSource(new StringReader(layout));
    }

    public static InputSource getDocument(URL url) throws IOException {
        return XMLLayout.getDocument(url.openStream());
    }

    public static InputSource getDocument(File file) throws IOException {
        return XMLLayout.getDocument(new BufferedInputStream(new FileInputStream(file)));
    }

    public static InputSource getDocument(InputStream stream) {
        return new InputSource(stream);
    }

    public XMLLayoutRoot getLayoutRoot(XMLLayout layout) {
        this.resolver.startParseNotify();
        XMLLayoutRoot c = XMLLayout.getXMLLayoutRoot(layout);
        this.resolver.endParseNotify();
        return c;
    }

    protected void setLayoutRoot(XMLLayoutRoot layoutRoot) {
        this.layoutRoot = layoutRoot;
        layoutRoot.setIsLayoutRoot(true);
        if (this.root != null) {
            this.root.setLayoutRoot(layoutRoot);
        }
    }

    public static XMLLayoutRoot getXMLLayoutRoot(XMLLayout layout) {
        XMLLayoutPanel out = new XMLLayoutPanel();
        layout.setLayoutRoot(out);
        out.setXMLLayout(layout);
        return out;
    }

    static {
        namedColors.put("black", Color.decode("#000000"));
        namedColors.put("silver", Color.decode("#C0C0C0"));
        namedColors.put("gray", Color.decode("#808080"));
        namedColors.put("white", Color.decode("#FFFFFF"));
        namedColors.put("maroon", Color.decode("#800000"));
        namedColors.put("red", Color.decode("#FF0000"));
        namedColors.put("purple", Color.decode("#800080"));
        namedColors.put("fuchsia", Color.decode("#FF00FF"));
        namedColors.put("green", Color.decode("#008000"));
        namedColors.put("lime", Color.decode("#00FF00"));
        namedColors.put("olive", Color.decode("#808000"));
        namedColors.put("yellow", Color.decode("#FFFF00"));
        namedColors.put("navy", Color.decode("#000080"));
        namedColors.put("blue", Color.decode("#0000FF"));
        namedColors.put("teal", Color.decode("#008080"));
        namedColors.put("aqua", Color.decode("#00FFFF"));
    }

    protected static class LayoutBuilder
    extends DefaultHandler {
        private static String[] componentTags = new String[]{"scroller", "panel", "label", "spacer", "glue", "component", "grid", "compactgrid", "box", "divider", "tabs", "window"};
        private Vector stack;
        private LayoutItem root;
        protected ComponentNameResolver resolver;
        protected JexlContext context;
        protected Color defaultTabColor;
        protected Color defaultBGColor;
        protected Font defaultFont;
        protected int componentDepth = 0;
        protected Collection windows = new LinkedList();
        protected Locator locator;
        protected boolean suppressExpressionExceptions;

        protected LayoutBuilder() {
        }

        public void setSuppressExpressionExceptions(boolean suppressExpressionExceptions) {
            this.suppressExpressionExceptions = suppressExpressionExceptions;
        }

        public JexlContext getContext() {
            return this.context;
        }

        public void setContext(JexlContext context) {
            this.context = context;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void setDefaultTabColor(Color defaultTabColor) {
            this.defaultTabColor = defaultTabColor;
        }

        public void setDefaultBGColor(Color defaultBGColor) {
            this.defaultBGColor = defaultBGColor;
        }

        public void setDefaultFont(Font defaultFont) {
            this.defaultFont = defaultFont;
        }

        public void setComponentNameResolver(ComponentNameResolver resolver) {
            this.resolver = resolver;
        }

        public boolean isComponentTag(String tag) {
            for (int i = 0; i < componentTags.length; ++i) {
                if (!componentTags[i].equalsIgnoreCase(tag)) continue;
                return true;
            }
            return false;
        }

        protected String getValue(Attributes atts, String value) {
            return atts.getValue(value);
        }

        protected String getValue(Attributes atts, int val) {
            return atts.getValue(val);
        }

        public LayoutItem getRoot() {
            return this.root;
        }

        public Collection getWindows() {
            return this.windows;
        }

        @Override
        public void startDocument() throws SAXException {
            this.stack = new Vector();
            this.windows.clear();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (this.componentDepth > 0) {
                if (localName.equalsIgnoreCase("component")) {
                    ++this.componentDepth;
                }
                ComponentElement item = (ComponentElement)this.stack.elementAt(0);
                StringBuffer attString = new StringBuffer();
                for (int i = 0; i < atts.getLength(); ++i) {
                    String name = atts.getQName(i);
                    String value = this.getValue(atts, i);
                    attString.append(" " + name + "=\"" + value.replace('\"', '\'') + "\"");
                }
                item.appendXMLData("<" + localName + attString.toString() + ">\n");
                return;
            }
            LayoutItem item = null;
            localName = rawName;
            if (!localName.equalsIgnoreCase("xmllayout")) {
                if (localName.equalsIgnoreCase("component")) {
                    Properties props = new Properties();
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String name = atts.getQName(i);
                        String value = this.getValue(atts, i);
                        if (name.equals("id")) continue;
                        props.put(name, value);
                    }
                    String id = this.getValue(atts, "id");
                    item = new ComponentElement(id, this.resolver, props);
                    this.stack.insertElementAt(item, 0);
                    ++this.componentDepth;
                } else if (localName.equalsIgnoreCase("compactgrid")) {
                    String ypadStr;
                    String xpadStr;
                    String initialYStr;
                    String initialXStr;
                    String colStr;
                    int rows = -1;
                    int cols = -1;
                    int initialX = 0;
                    int initialY = 0;
                    int xpad = 0;
                    int ypad = 0;
                    String rowStr = this.getValue(atts, "rows");
                    if (rowStr != null) {
                        try {
                            rows = Integer.parseInt(rowStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    if ((colStr = this.getValue(atts, "cols")) != null) {
                        try {
                            cols = Integer.parseInt(colStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    if ((initialXStr = this.getValue(atts, "xinit")) != null) {
                        try {
                            initialX = Integer.parseInt(initialXStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    if ((initialYStr = this.getValue(atts, "yinit")) != null) {
                        try {
                            initialY = Integer.parseInt(initialYStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    if ((xpadStr = this.getValue(atts, "xpad")) != null) {
                        try {
                            xpad = Integer.parseInt(xpadStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    if ((ypadStr = this.getValue(atts, "ypad")) != null) {
                        try {
                            ypad = Integer.parseInt(ypadStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    item = new CompactGridElement(rows, cols, initialX, initialY, xpad, ypad);
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("grid")) {
                    String colStr;
                    int rows = 1;
                    int cols = 1;
                    String rowStr = this.getValue(atts, "rows");
                    if (rowStr != null) {
                        try {
                            rows = Integer.parseInt(rowStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    if ((colStr = this.getValue(atts, "cols")) != null) {
                        try {
                            cols = Integer.parseInt(colStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    item = new GridElement(rows, cols);
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("divider")) {
                    String widthStr = this.getValue(atts, "dividerSize");
                    int width = 5;
                    if (widthStr != null) {
                        try {
                            width = Integer.parseInt(widthStr);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    int orientation = 0;
                    if (this.getValue(atts, "orientation") != null && this.getValue(atts, "orientation").equalsIgnoreCase("horz")) {
                        orientation = 1;
                    }
                    int dividerLoc = -1;
                    int dividerPercentage = -1;
                    String dividerLocStr = this.getValue(atts, "dividerLoc");
                    if (dividerLocStr != null) {
                        if (dividerLocStr.endsWith("%")) {
                            dividerLocStr = dividerLocStr.substring(0, dividerLocStr.length() - 1);
                            dividerPercentage = Integer.parseInt(dividerLocStr);
                            dividerLoc = -1;
                        } else {
                            try {
                                dividerLoc = Integer.parseInt(dividerLocStr);
                                dividerPercentage = -1;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    item = new DividerElement(width, orientation, dividerLoc, dividerPercentage);
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("panel")) {
                    item = new PanelElement();
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equals("label")) {
                    String halignmentStr = this.getValue(atts, "halign");
                    String valignmentStr = this.getValue(atts, "valign");
                    int halign = 2;
                    int valign = 0;
                    if (halignmentStr != null) {
                        halign = halignmentStr.equalsIgnoreCase("CENTER") ? 0 : (halignmentStr.equalsIgnoreCase("RIGHT") ? 4 : 2);
                    }
                    if (valignmentStr != null) {
                        valign = valignmentStr.equalsIgnoreCase("TOP") ? 1 : (valignmentStr.equalsIgnoreCase("BOTTOM") ? 3 : 0);
                    }
                    item = new LabelElement(this.getValue(atts, "text"), this.getValue(atts, "icon"), halign, valign);
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equals("spacer")) {
                    int orientation = 2;
                    if (this.getValue(atts, "orientation") != null) {
                        if (this.getValue(atts, "orientation").equalsIgnoreCase("horz")) {
                            orientation = 1;
                        } else if (this.getValue(atts, "orientation").equalsIgnoreCase("vert")) {
                            orientation = 0;
                        }
                    }
                    int size = 10;
                    String sizeStr = this.getValue(atts, "size");
                    try {
                        size = Integer.parseInt(sizeStr);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    item = new SpacerElement(orientation, size);
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equals("glue")) {
                    int orientation = 2;
                    if (this.getValue(atts, "orientation") != null) {
                        if (this.getValue(atts, "orientation").equalsIgnoreCase("horz")) {
                            orientation = 1;
                        } else if (this.getValue(atts, "orientation").equalsIgnoreCase("vert")) {
                            orientation = 0;
                        }
                    }
                    item = new GlueElement(orientation);
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("tabs")) {
                    item = new TabElement();
                    ((TabElement)item).setDefaultTabColor(this.defaultTabColor);
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("if")) {
                    item = new IfElement(atts.getValue("eval"));
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("else")) {
                    item = new ElseElement();
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("tab")) {
                    TabElement pitem = (TabElement)this.stack.elementAt(0);
                    TabRecord record = new TabRecord();
                    String colorStr = this.getValue(atts, "color");
                    Color color = null;
                    if (colorStr != null && (color = Color.getColor(colorStr)) == null) {
                        try {
                            color = Color.decode(colorStr);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    record.setSelectedStr(this.getValue(atts, "selected"));
                    record.setColor(color);
                    record.setName(this.getValue(atts, "name"));
                    pitem.addItem(record);
                } else if (localName.equalsIgnoreCase("box")) {
                    int orientation = 0;
                    if (this.getValue(atts, "orientation") != null && this.getValue(atts, "orientation").equalsIgnoreCase("horz")) {
                        orientation = 1;
                    }
                    item = new BoxElement(orientation);
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("scroller")) {
                    item = new ScrollerElement(LayoutBuilder.convertScrollString(this.getValue(atts, "horz")), LayoutBuilder.convertScrollString(this.getValue(atts, "vert")));
                    this.stack.insertElementAt(item, 0);
                } else if (localName.equalsIgnoreCase("window")) {
                    int width = 300;
                    int height = 300;
                    boolean startMinimized = false;
                    String title = this.getValue(atts, "title");
                    String widthStr = this.getValue(atts, "width");
                    String heightStr = this.getValue(atts, "height");
                    String startMinimizedStr = this.getValue(atts, "startminimized");
                    if (widthStr != null) {
                        try {
                            width = Integer.parseInt(widthStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    if (heightStr != null) {
                        try {
                            height = Integer.parseInt(heightStr);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    if (startMinimizedStr != null) {
                        startMinimized = startMinimizedStr.equals("true");
                    }
                    item = new WindowElement(width, height, title, startMinimized);
                    this.stack.insertElementAt(item, 0);
                }
            }
            if (item != null) {
                item.setContext(this.context);
                item.setLineNumber(this.locator.getLineNumber());
                item.setSuppressExpressionExceptions(this.suppressExpressionExceptions);
            }
            if (this.isComponentTag(localName)) {
                this.configureComponent(item, atts);
            }
            if (this.root == null && item != null && !(item instanceof WindowElement) && this.stack.size() == 1) {
                this.root = item;
            }
        }

        private void configureComponent(LayoutItem item, Attributes atts) {
            String fontName = this.getValue(atts, "font");
            String foregroundStr = this.getValue(atts, "foreground");
            String backgroundStr = this.getValue(atts, "background");
            String name = this.getValue(atts, "name");
            int height = -1;
            int width = -1;
            int maxHeight = -1;
            int maxWidth = -1;
            int leftMargin = 0;
            int rightMargin = 0;
            int bottomMargin = 0;
            int topMargin = 0;
            String borderTitle = null;
            try {
                int margins = Integer.parseInt(this.getValue(atts, "margins"));
                if (margins < 0) {
                    margins = 0;
                }
                leftMargin = margins;
                rightMargin = margins;
                bottomMargin = margins;
                topMargin = margins;
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                leftMargin = Integer.parseInt(this.getValue(atts, "leftmargin"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                rightMargin = Integer.parseInt(this.getValue(atts, "rightmargin"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                topMargin = Integer.parseInt(this.getValue(atts, "topmargin"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                bottomMargin = Integer.parseInt(this.getValue(atts, "bottommargin"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            borderTitle = this.getValue(atts, "bordertitle");
            try {
                height = Integer.parseInt(this.getValue(atts, "height"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                width = Integer.parseInt(this.getValue(atts, "width"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                maxHeight = Integer.parseInt(this.getValue(atts, "maxHeight"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                maxWidth = Integer.parseInt(this.getValue(atts, "maxWidth"));
            }
            catch (Exception e) {
                // empty catch block
            }
            Font font = null;
            if (fontName != null && (font = Font.getFont(fontName)) == null) {
                font = Font.decode(fontName);
            }
            Color foreground = null;
            if (foregroundStr != null) {
                foreground = XMLLayout.decodeColor(foregroundStr);
            }
            Color background = null;
            if (backgroundStr != null) {
                background = XMLLayout.decodeColor(backgroundStr);
            }
            if (font == null) {
                font = this.defaultFont;
            }
            item.foreground = foreground;
            item.setBackground(background, this.defaultBGColor);
            item.font = font;
            item.width = width;
            item.height = height;
            item.name = name;
            item.leftMargin = leftMargin;
            item.rightMargin = rightMargin;
            item.bottomMargin = bottomMargin;
            item.topMargin = topMargin;
            item.borderTitle = borderTitle;
            item.maxHeight = maxHeight;
            item.maxWidth = maxWidth;
        }

        private static int convertScrollString(String in) {
            if (in == null) {
                return 1;
            }
            if (in.equalsIgnoreCase("ALWAYS")) {
                return 0;
            }
            if (in.equalsIgnoreCase("NEVER")) {
                return 2;
            }
            return 1;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.componentDepth > 0) {
                ComponentElement item = (ComponentElement)this.stack.elementAt(0);
                item.appendXMLData(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            localName = qName;
            if (localName.equals("component")) {
                --this.componentDepth;
            }
            if (this.componentDepth > 0) {
                ComponentElement item = (ComponentElement)this.stack.elementAt(0);
                item.appendXMLData("</" + localName + ">\n");
            } else if (localName.equalsIgnoreCase("window")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                this.stack.removeElementAt(0);
                if (this.stack.size() == 0) {
                    this.windows.add(item);
                }
            } else if (localName.equalsIgnoreCase("first")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                LayoutItem parent = (LayoutItem)this.stack.elementAt(1);
                ((DividerElement)parent).setFirst(item);
                this.stack.removeElementAt(0);
            } else if (localName.equalsIgnoreCase("second")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                LayoutItem parent = (LayoutItem)this.stack.elementAt(1);
                ((DividerElement)parent).setSecond(item);
                this.stack.removeElementAt(0);
            } else if (localName.equalsIgnoreCase("tab")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                LayoutItem parent = (LayoutItem)this.stack.elementAt(1);
                TabRecord record = (TabRecord)((TabElement)parent).getItems().get(((TabElement)parent).getItems().size() - 1);
                record.getItems().clear();
                record.addItem(item);
                this.stack.removeElementAt(0);
            } else if (localName.equalsIgnoreCase("north")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                LayoutItem parent = (LayoutItem)this.stack.elementAt(1);
                ((PanelElement)parent).setNorth(item);
                this.stack.removeElementAt(0);
            } else if (localName.equalsIgnoreCase("south")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                LayoutItem parent = (LayoutItem)this.stack.elementAt(1);
                ((PanelElement)parent).setSouth(item);
                this.stack.removeElementAt(0);
            } else if (localName.equalsIgnoreCase("east")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                LayoutItem parent = (LayoutItem)this.stack.elementAt(1);
                ((PanelElement)parent).setEast(item);
                this.stack.removeElementAt(0);
            } else if (localName.equalsIgnoreCase("west")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                LayoutItem parent = (LayoutItem)this.stack.elementAt(1);
                ((PanelElement)parent).setWest(item);
                this.stack.removeElementAt(0);
            } else if (localName.equalsIgnoreCase("center")) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                LayoutItem parent = (LayoutItem)this.stack.elementAt(1);
                ((PanelElement)parent).setCenter(item);
                this.stack.removeElementAt(0);
            } else if (this.stack.size() >= 2) {
                LayoutItem item = (LayoutItem)this.stack.elementAt(0);
                if (!(this.stack.get(1) instanceof LayoutContainerItem)) {
                    LayoutContainerItem container = null;
                    for (int i = 0; i < this.stack.size(); ++i) {
                        if (!(this.stack.get(i) instanceof LayoutContainerItem)) continue;
                        container = (LayoutContainerItem)this.stack.get(i);
                        break;
                    }
                    if (container == null) {
                        throw new RuntimeException("Error on line " + this.locator.getLineNumber() + ". maybe there are too many root tags?");
                    }
                    throw new RuntimeException("Error on line " + this.locator.getLineNumber() + ". More than one child tag was added to a container (a <" + container.getTagName() + "> or one of its subtags) that only allows a single child.");
                }
                LayoutContainerItem parent = (LayoutContainerItem)this.stack.elementAt(1);
                if (parent.canAddDirectly()) {
                    parent.addItem(item);
                    this.stack.removeElementAt(0);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }
    }

    public static class PanelElement
    extends LayoutContainerItem {
        public PanelElement() {
            for (int i = 0; i < 5; ++i) {
                this.addItem(null);
            }
        }

        @Override
        public int getMaxItems() {
            return 5;
        }

        @Override
        public String getTagName() {
            return "panel";
        }

        public void setEast(LayoutItem item) {
            if (this.getEast() != null) {
                throw new RuntimeException("Only one item is allowed in the <east> tag.");
            }
            this.items.set(0, item);
        }

        public void setWest(LayoutItem item) {
            if (this.getWest() != null) {
                throw new RuntimeException("Only one item is allowed in the <west> tag.");
            }
            this.items.set(1, item);
        }

        public void setCenter(LayoutItem item) {
            if (this.getCenter() != null) {
                throw new RuntimeException("Only one item is allowed in the <center> tag.");
            }
            this.items.set(2, item);
        }

        public void setNorth(LayoutItem item) {
            if (this.getNorth() != null) {
                throw new RuntimeException("Only one item is allowed in the <north> tag.");
            }
            this.items.set(3, item);
        }

        public void setSouth(LayoutItem item) {
            if (this.getSouth() != null) {
                throw new RuntimeException("Only one item is allowed in the <south> tag.");
            }
            this.items.set(4, item);
        }

        public LayoutItem getEast() {
            return (LayoutItem)this.items.get(0);
        }

        public LayoutItem getWest() {
            return (LayoutItem)this.items.get(1);
        }

        public LayoutItem getCenter() {
            return (LayoutItem)this.items.get(2);
        }

        public LayoutItem getNorth() {
            return (LayoutItem)this.items.get(3);
        }

        public LayoutItem getSouth() {
            return (LayoutItem)this.items.get(4);
        }

        @Override
        public boolean canAddDirectly() {
            return false;
        }

        @Override
        protected Component createComponent() {
            return new BorderPanel();
        }

        protected class BorderPanel
        extends JPanel
        implements XMLLayoutComponent {
            private static final long serialVersionUID = -3253170914570900063L;

            public BorderPanel() {
                this.setLayout(new BorderLayout());
            }

            @Override
            public void guiupdate() throws ExpressionException {
                this.removeAll();
                if (PanelElement.this.getNorth() != null && PanelElement.this.getNorth().getComponents().size() > 0) {
                    this.add((Component)PanelElement.this.getNorth().getComponents().get(0), "North");
                }
                if (PanelElement.this.getSouth() != null && PanelElement.this.getSouth().getComponents().size() > 0) {
                    this.add((Component)PanelElement.this.getSouth().getComponents().get(0), "South");
                }
                if (PanelElement.this.getEast() != null && PanelElement.this.getEast().getComponents().size() > 0) {
                    this.add((Component)PanelElement.this.getEast().getComponents().get(0), "East");
                }
                if (PanelElement.this.getWest() != null && PanelElement.this.getWest().getComponents().size() > 0) {
                    this.add((Component)PanelElement.this.getWest().getComponents().get(0), "West");
                }
                if (PanelElement.this.getCenter() != null && PanelElement.this.getCenter().getComponents().size() > 0) {
                    this.add((Component)PanelElement.this.getCenter().getComponents().get(0), "Center");
                }
            }
        }
    }

    public static class ComponentElement
    extends LayoutItem {
        protected String id;
        protected Properties props;
        protected ComponentNameResolver resolver;
        protected StringBuffer xml = null;

        public ComponentElement(String id, ComponentNameResolver resolver, Properties props) {
            this.id = id;
            this.props = props;
            this.resolver = resolver;
        }

        @Override
        public String getTagName() {
            return "component";
        }

        @Override
        public void setBackground(Color background, Color defaultBGColor) {
            if (background != null) {
                this.background = background;
            }
        }

        public void appendXMLData(String data) {
            if (this.xml == null) {
                this.xml = new StringBuffer();
            }
            this.xml.append(data);
        }

        public String getXML() {
            if (this.xml == null) {
                return null;
            }
            return this.xml.toString();
        }

        public String getID() {
            return this.id;
        }

        public Properties getProperties() {
            return this.props;
        }

        @Override
        protected Component createComponent() {
            Component out = this.resolver.resolveName(this.id, this.props, this.getXML());
            return out;
        }

        public String toString() {
            return "component id='" + this.id + "'";
        }
    }

    public static class DividerElement
    extends LayoutContainerItem {
        public static final int VERTICAL = 0;
        public static final int HORIZONTAL = 1;
        protected int dividerLoc = -1;
        protected int width = 3;
        protected int orientation;
        protected int dividerPercentage = -1;

        public DividerElement(int width, int orientation, int dividerLoc, int dividerPercentage) {
            this.dividerLoc = dividerLoc;
            this.width = width;
            this.orientation = orientation;
            this.dividerPercentage = dividerPercentage;
        }

        @Override
        public Component createComponent() {
            return new Divider(this.orientation);
        }

        @Override
        public boolean canAddDirectly() {
            return false;
        }

        public void setFirst(LayoutItem item) {
            if (this.getFirstItem() != null) {
                throw new RuntimeException("Only one item is allowed in the <first> tag.");
            }
            if (this.items.size() == 0) {
                this.items.add(item);
            } else {
                this.items.set(0, item);
            }
        }

        public void setSecond(LayoutItem item) {
            if (this.getSecond() != null) {
                throw new RuntimeException("Only one item is allowed in the <second> tag.");
            }
            if (this.items.size() == 1) {
                this.items.add(item);
            } else {
                this.items.set(1, item);
            }
        }

        @Override
        public String getTagName() {
            return "divider";
        }

        @Override
        public int getMaxItems() {
            return 2;
        }

        public LayoutItem getSecond() {
            if (this.items.size() < 2) {
                return null;
            }
            return (LayoutItem)this.items.get(1);
        }

        public int getOrientation() {
            return this.orientation;
        }

        public int getDividerLoc() {
            return this.dividerLoc;
        }

        public int getWidth() {
            return this.width;
        }

        protected class Divider
        extends JSplitPane
        implements XMLLayoutComponent {
            private static final long serialVersionUID = 9066556972754310524L;

            public Divider(int orientation) {
                super(orientation == 0 ? 0 : 1);
                if (DividerElement.this.width != -1) {
                    this.setDividerSize(DividerElement.this.width);
                }
                if (DividerElement.this.dividerLoc != -1) {
                    this.setDividerLocation(DividerElement.this.dividerLoc);
                }
                if (DividerElement.this.dividerPercentage != -1) {
                    this.setDividerLocation((double)DividerElement.this.dividerPercentage / 100.0);
                }
            }

            @Override
            public void guiupdate() throws ExpressionException {
                int dividerLoc = this.getDividerLocation();
                if (DividerElement.this.getFirstItem() != null && DividerElement.this.getSecond().getComponents().size() > 0) {
                    this.setLeftComponent((Component)DividerElement.this.getFirstItem().getComponents().get(0));
                }
                if (DividerElement.this.getSecond() != null && DividerElement.this.getSecond().getComponents().size() > 0) {
                    this.setRightComponent((Component)DividerElement.this.getSecond().getComponents().get(0));
                }
                this.setDividerLocation(dividerLoc);
                this.validate();
            }
        }
    }

    public static class ScrollerElement
    extends LayoutContainerItem {
        public static final int ALWAYS = 0;
        public static final int AS_NEEDED = 1;
        public static final int NEVER = 2;
        protected int horiz = 1;
        protected int vert = 2;

        public ScrollerElement(int horiz, int vert) {
            this.horiz = horiz;
            this.vert = vert;
        }

        @Override
        public String getTagName() {
            return "scroller";
        }

        @Override
        public int getMaxItems() {
            return 1;
        }

        @Override
        protected Component createComponent() throws ExpressionException {
            int h = 30;
            int v = 20;
            if (this.horiz == 0) {
                h = 32;
            } else if (this.horiz == 2) {
                h = 31;
            }
            if (this.vert == 0) {
                v = 22;
            } else if (this.vert == 2) {
                v = 21;
            }
            JScrollPane out = new JScrollPane(v, h);
            if (this.getFirstItem().getComponents().size() > 0) {
                out.setViewportView((Component)this.getFirstItem().getComponents().get(0));
            }
            return out;
        }
    }

    public static class TabRecord
    extends LayoutContainerItem {
        String name;
        LayoutItem item;
        Color bgColor;
        String selectedStr;

        public String getName() {
            return this.name;
        }

        @Override
        public String getTagName() {
            return "tab";
        }

        public String getSelectedStr() {
            return this.selectedStr;
        }

        public void setSelectedStr(String selectedStr) {
            this.selectedStr = selectedStr;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Color getColor() {
            return this.bgColor;
        }

        public void setColor(Color bgColor) {
            this.bgColor = bgColor;
        }

        @Override
        public List getComponents() throws ExpressionException {
            return this.getFirstItem().getComponents();
        }
    }

    public static class TabElement
    extends LayoutContainerItem {
        protected Color defaultTabColor;

        public void setDefaultTabColor(Color defaultTabColor) {
            this.defaultTabColor = defaultTabColor;
        }

        @Override
        public boolean canAddDirectly() {
            return false;
        }

        @Override
        public String getTagName() {
            return "tabs";
        }

        @Override
        public Class getSubItemType() {
            return TabRecord.class;
        }

        @Override
        protected Component createComponent() {
            return new Tabs();
        }

        protected class Tabs
        extends JTabbedPane
        implements XMLLayoutComponent {
            private static final long serialVersionUID = 2956611404579656343L;
            protected int id;

            @Override
            public void guiupdate() throws ExpressionException {
                Component selectedComp = this.getSelectedComponent();
                this.removeAll();
                Iterator it = TabElement.this.getItems().iterator();
                int i = 0;
                while (it.hasNext()) {
                    Object o = it.next();
                    TabRecord record = (TabRecord)o;
                    if (record != null && record.getComponents().size() >= 1) {
                        boolean selected;
                        if (record.getSelectedStr() != null && (selected = TabElement.this.parse(record.getSelectedStr()).equals("true")) && selectedComp == null) {
                            selectedComp = (Component)record.getComponents().get(0);
                        }
                        String str = TabElement.this.parse(record.getName());
                        this.add((Component)record.getComponents().get(0), str);
                        if (record.getColor() != null) {
                            this.setBackgroundAt(i, record.getColor());
                        } else if (TabElement.this.defaultTabColor != null) {
                            this.setBackgroundAt(i, TabElement.this.defaultTabColor);
                        }
                    }
                    ++i;
                }
                if (selectedComp != null) {
                    this.setSelectedComponent(selectedComp);
                }
            }
        }
    }

    public static class LabelElement
    extends LayoutItem {
        protected String label;
        protected String iconURL;
        protected Icon icon;
        protected int halign;
        protected int valign;

        public LabelElement(String label, String iconURL, int halign, int valign) {
            this.label = label;
            this.iconURL = iconURL;
            this.halign = halign;
            this.valign = valign;
        }

        @Override
        public String getTagName() {
            return "label";
        }

        @Override
        protected Component createComponent() {
            return new XMLLabel();
        }

        protected class XMLLabel
        extends JLabel
        implements XMLLayoutComponent {
            private static final long serialVersionUID = -1800321155756286936L;

            public XMLLabel() {
                this.setHorizontalAlignment(LabelElement.this.halign);
                this.setVerticalAlignment(LabelElement.this.valign);
            }

            @Override
            public void guiupdate() throws ExpressionException {
                String parsedLabel = LabelElement.this.parse(LabelElement.this.label);
                String parsedURL = LabelElement.this.parse(LabelElement.this.iconURL);
                if (LabelElement.this.iconURL != null) {
                    try {
                        URL url = new URL(parsedURL);
                        LabelElement.this.icon = new ImageIcon(url);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.setText(parsedLabel);
                this.setIcon(LabelElement.this.icon);
            }
        }
    }

    public static class ElseElement
    extends LayoutContainerItem {
        @Override
        public String getTagName() {
            return "else";
        }

        @Override
        public int getMaxItems() {
            return 1;
        }

        @Override
        protected Component createComponent() {
            return null;
        }
    }

    public static class IfElement
    extends LayoutContainerItem {
        protected String expression;
        protected Collection elseItems = new LinkedList();

        public IfElement(String expression) {
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        protected boolean shouldShow() {
            try {
                return ExpressionUtil.execBoolean(this.expression, this.getContext());
            }
            catch (Exception ex) {
                logger.info((Object)("trying to resolve expression '" + this.expression + "' with context: " + this.getContext()));
                logger.info(this.getContext().getVariableValue("TextEditor"));
                ex.printStackTrace();
                return false;
            }
        }

        @Override
        public List getComponents() throws ExpressionException {
            LinkedList out = new LinkedList();
            if (this.shouldShow()) {
                for (LayoutItem item : this.getItems()) {
                    if (item instanceof ElseElement) continue;
                    out.addAll(item.getComponents());
                }
            } else {
                for (LayoutItem item : this.getItems()) {
                    if (!(item instanceof ElseElement)) continue;
                    ElseElement elt = (ElseElement)item;
                    for (LayoutItem item2 : elt.getItems()) {
                        out.addAll(item2.getComponents());
                    }
                }
            }
            return out;
        }

        @Override
        public String getTagName() {
            return "if";
        }

        @Override
        protected Component createComponent() {
            return null;
        }
    }

    public static class BoxElement
    extends LayoutContainerItem {
        public static final int VERTICAL = 0;
        public static final int HORIZONTAL = 1;
        protected int orientation;

        public BoxElement(int orientation) {
            this.orientation = orientation;
        }

        @Override
        public String getTagName() {
            return "box";
        }

        @Override
        protected Component createComponent() {
            return new BoxPanel();
        }

        protected class BoxPanel
        extends XMLSubPanel {
            private static final long serialVersionUID = 1489573969867316524L;

            public BoxPanel() {
                this.setLayoutItem(BoxElement.this);
            }

            @Override
            public void guiupdate() throws ExpressionException {
                this.setLayout(new BoxLayout(this, BoxElement.this.orientation == 0 ? 1 : 0));
                super.guiupdate();
            }
        }
    }

    public static class CompactGridElement
    extends LayoutContainerItem {
        protected int rows = -1;
        protected int cols = -1;
        protected int initialX = 0;
        protected int initialY = 0;
        protected int xpad = 0;
        protected int ypad = 0;

        public CompactGridElement(int rows, int cols, int initialX, int initialY, int xpad, int ypad) {
            this.rows = rows;
            this.cols = cols;
            this.initialX = initialX;
            this.initialY = initialY;
            this.xpad = xpad;
            this.ypad = ypad;
        }

        @Override
        public String getTagName() {
            return "compactgrid";
        }

        @Override
        public Component createComponent() {
            return new CompactGrid();
        }

        protected class CompactGrid
        extends XMLSubPanel {
            private static final long serialVersionUID = 5842644183397051150L;

            public CompactGrid() {
                this.setLayoutItem(CompactGridElement.this);
                this.setLayout(new SpringLayout());
            }

            @Override
            public void guiupdate() throws ExpressionException {
                super.guiupdate();
                SpringUtilities.makeCompactGrid(this, CompactGridElement.this.rows, CompactGridElement.this.cols, CompactGridElement.this.initialX, CompactGridElement.this.initialY, CompactGridElement.this.xpad, CompactGridElement.this.ypad);
                this.validate();
            }
        }
    }

    public static class GridElement
    extends LayoutContainerItem {
        protected int rows = 1;
        protected int cols = 1;

        public GridElement(int rows, int cols) {
            this.rows = rows;
            this.cols = cols;
        }

        @Override
        public String getTagName() {
            return "grid";
        }

        @Override
        public Component createComponent() {
            return new Grid();
        }

        protected class Grid
        extends XMLSubPanel {
            private static final long serialVersionUID = -670246536920157248L;

            public Grid() {
                this.setLayoutItem(GridElement.this);
            }

            @Override
            public void guiupdate() throws ExpressionException {
                this.setLayout(new GridLayout(GridElement.this.rows, GridElement.this.cols));
                super.guiupdate();
            }
        }
    }

    public static class SpacerElement
    extends LayoutItem {
        public static final int VERTICAL = 0;
        public static final int HORIZONTAL = 1;
        public static final int BOTH = 2;
        public static final int GLUE = 3;
        protected int orientation;
        protected int size;

        public SpacerElement(int orientation, int size) {
            this.orientation = orientation;
            this.setSize(size);
        }

        @Override
        public String getTagName() {
            return "spacer";
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getOrientation() {
            return this.orientation;
        }

        @Override
        public Component createComponent() {
            return new Spacer();
        }

        protected class Spacer
        extends Box.Filler
        implements XMLLayoutComponent {
            private static final long serialVersionUID = 765797498221981065L;

            public Spacer() {
                super(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
            }

            @Override
            public void guiupdate() {
                if (SpacerElement.this.orientation == 0) {
                    this.changeShape(new Dimension(0, SpacerElement.this.size), new Dimension(0, SpacerElement.this.size), new Dimension(0, SpacerElement.this.size));
                } else if (SpacerElement.this.orientation == 1) {
                    this.changeShape(new Dimension(SpacerElement.this.size, 0), new Dimension(SpacerElement.this.size, 0), new Dimension(SpacerElement.this.size, 0));
                } else if (SpacerElement.this.orientation == 2) {
                    this.changeShape(new Dimension(SpacerElement.this.size, SpacerElement.this.size), new Dimension(SpacerElement.this.size, SpacerElement.this.size), new Dimension(SpacerElement.this.size, SpacerElement.this.size));
                } else if (SpacerElement.this.orientation == 3) {
                    this.changeShape(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
                }
            }
        }
    }

    public static class GlueElement
    extends LayoutItem {
        public static final int VERTICAL = 0;
        public static final int HORIZONTAL = 1;
        public static final int BOTH = 2;
        protected int orientation;

        @Override
        public String getTagName() {
            return "glue";
        }

        public GlueElement(int orientation) {
            this.orientation = orientation;
        }

        public int getOrientation() {
            return this.orientation;
        }

        @Override
        public Component createComponent() {
            return new Glue();
        }

        protected class Glue
        extends Box.Filler
        implements XMLLayoutComponent {
            private static final long serialVersionUID = -2857876679688442918L;

            public Glue() {
                super(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
            }

            @Override
            public void guiupdate() {
                if (GlueElement.this.orientation == 0) {
                    this.changeShape(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
                } else if (GlueElement.this.orientation == 1) {
                    this.changeShape(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
                } else {
                    this.changeShape(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
                }
            }
        }
    }

    public static class WindowElement
    extends LayoutContainerItem {
        protected int x = -1;
        protected int y = -1;
        protected int width = 300;
        protected int height = 300;
        protected boolean startMinimized = false;
        protected boolean doPack = false;
        protected String title;
        protected XMLDialog window;

        public WindowElement(int width, int height, String title, boolean startMinimized) {
            this.width = width;
            this.height = height;
            this.title = title;
            this.startMinimized = startMinimized;
        }

        @Override
        public String getTagName() {
            return "window";
        }

        @Override
        public int getMaxItems() {
            return 1;
        }

        public void clear() {
            if (this.window != null) {
                this.window.dispose();
            }
            this.window = null;
        }

        @Override
        public List getComponents() {
            if (this.window == null) {
                this.createWindow();
            }
            return Collections.singletonList(this.window);
        }

        public void createWindow() {
            this.window = new XMLDialog();
            if (this.x > -1 && this.y > -1) {
                this.window.setLocation(this.x, this.y);
            }
            this.window.setSize(this.width, this.height);
            if (this.startMinimized) {
                this.window.doButtonMinimize();
            } else {
                this.window.setVisible(true);
            }
        }

        protected Frame getDialogOwner() {
            if (this.layoutRoot == null || !(this.layoutRoot instanceof Container)) {
                return null;
            }
            return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Container)((Object)this.layoutRoot));
        }

        @Override
        public Component createComponent() {
            return null;
        }

        public class XMLDialog
        extends JDialog
        implements XMLLayoutComponent {
            private static final long serialVersionUID = 2749969648347275645L;

            public XMLDialog() {
                super(WindowElement.this.getDialogOwner());
                this.setDefaultCloseOperation(0);
                this.getContentPane().setLayout(new GridLayout(1, 1));
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        XMLDialog.this.doButtonMinimize();
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                        XMLDialog.this.doButtonMinimize();
                    }
                });
            }

            public void doButtonMinimize() {
                if (WindowElement.this.layoutRoot != null && WindowElement.this.layoutRoot instanceof XMLLayoutPanel) {
                    ((XMLLayoutPanel)WindowElement.this.layoutRoot).minimizeWindow(this);
                } else {
                    System.err.println("didn't do button minimize, layoutRoot = " + WindowElement.this.layoutRoot);
                }
            }

            @Override
            public void guiupdate() throws ExpressionException {
                if (WindowElement.this.title != null) {
                    this.setTitle(WindowElement.this.parse(WindowElement.this.title));
                }
                this.getContentPane().removeAll();
                Iterator it = WindowElement.this.getFirstItem().getComponents().iterator();
                if (it.hasNext()) {
                    this.getContentPane().add((Component)it.next());
                }
                this.getContentPane().validate();
            }

            @Override
            public void setVisible(boolean visible) {
                if (!this.isDisplayable() && WindowElement.this.doPack) {
                    this.pack();
                }
                super.setVisible(visible);
            }
        }
    }

    public static abstract class XMLSubPanel
    extends JPanel
    implements XMLLayoutComponent {
        protected LayoutContainerItem lcitem;

        public void setLayoutItem(LayoutContainerItem lcitem) {
            this.lcitem = lcitem;
        }

        @Override
        public void guiupdate() throws ExpressionException {
            this.removeAll();
            List items = this.lcitem.getItems();
            for (LayoutItem item : items) {
                List comps = item.getComponents();
                for (Component c : comps) {
                    this.add(c);
                }
            }
            this.validate();
        }
    }

    public static abstract class LayoutContainerItem
    extends LayoutItem {
        protected List items = new LinkedList();

        public void addItem(LayoutItem item) {
            if (item != null && !this.getSubItemType().isAssignableFrom(item.getClass())) {
                throw new RuntimeException("Cannot add a child of type " + item.getClass() + " to tag <" + this.getTagName() + ">; expected type " + this.getSubItemType());
            }
            this.items.add(item);
            if (this.getMaxItems() != -1 && this.items.size() > this.getMaxItems()) {
                throw new RuntimeException("Cannot add more than " + this.getMaxItems() + " child items to a <" + this.getTagName() + "> tag.");
            }
        }

        public int getMaxItems() {
            return -1;
        }

        public Class getSubItemType() {
            return LayoutItem.class;
        }

        @Override
        public void setLayoutRoot(XMLLayoutRoot layoutRoot) {
            super.setLayoutRoot(layoutRoot);
            for (LayoutItem item : this.items) {
                if (item == null) continue;
                item.setLayoutRoot(layoutRoot);
            }
            this.layoutRoot = layoutRoot;
        }

        public LayoutItem getFirstItem() {
            if (this.items.size() > 0) {
                return (LayoutItem)this.items.get(0);
            }
            return null;
        }

        public List getItems() {
            return this.items;
        }

        public boolean canAddDirectly() {
            return true;
        }
    }

    public static abstract class LayoutItem {
        Color background = null;
        Color foreground = null;
        int width = -1;
        int height = -1;
        int maxWidth = -1;
        int maxHeight = -1;
        Font font = null;
        String name;
        int leftMargin = 0;
        int rightMargin = 0;
        int bottomMargin = 0;
        int topMargin = 0;
        String borderTitle;
        List components;
        JexlContext context;
        XMLLayoutRoot layoutRoot;
        protected int lineNumber;
        protected boolean suppressExpressionExceptions;

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public void setSuppressExpressionExceptions(boolean suppressExpressionExceptions) {
            this.suppressExpressionExceptions = suppressExpressionExceptions;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public abstract String getTagName();

        public void setBackground(Color background, Color defaultBGColor) {
            if (background == null) {
                background = defaultBGColor;
            }
            this.background = background;
        }

        public void setLayoutRoot(XMLLayoutRoot layoutRoot) {
            this.layoutRoot = layoutRoot;
        }

        public void setContext(JexlContext context) {
            this.context = context;
        }

        public JexlContext getContext() {
            return this.context;
        }

        public String parse(String s) throws ExpressionException {
            if (s == null) {
                return null;
            }
            if (this.getContext() != null) {
                try {
                    return ExpressionUtil.resolveBacktickExpression(s, this.getContext());
                }
                catch (ExpressionException ex) {
                    if (!this.suppressExpressionExceptions) {
                        ex.setLineNumber(this.lineNumber);
                        throw ex;
                    }
                    return s;
                }
            }
            return s;
        }

        public List getComponents() throws ExpressionException {
            if (this.components == null) {
                this.components = this.createComponents();
                for (Component c : this.components) {
                    this.configure(c);
                    if (!(c instanceof XMLLayoutComponent)) continue;
                    ((XMLLayoutComponent)((Object)c)).guiupdate();
                }
            }
            return this.components;
        }

        protected void configureBorders(Component c) throws ExpressionException {
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                Border border = jc.getBorder();
                if (this.borderTitle != null) {
                    TitledBorder titledBorder = new TitledBorder(this.parse(this.borderTitle));
                    if (this.font != null) {
                        titledBorder.setTitleFont(this.font);
                    }
                    border = border == null ? titledBorder : new CompoundBorder(titledBorder, border);
                }
                if (this.leftMargin + this.rightMargin + this.topMargin + this.bottomMargin > 0) {
                    EmptyBorder emptyBorder = new EmptyBorder(this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin);
                    border = border == null ? emptyBorder : new CompoundBorder(emptyBorder, border);
                }
                if (border != null) {
                    jc.setBorder(border);
                }
            }
        }

        protected void configure(Component c) throws ExpressionException {
            this.configureBorders(c);
            if (this.foreground != null) {
                c.setForeground(this.foreground);
            }
            if (this.background != null) {
                c.setBackground(this.background);
            }
            if (this.font != null) {
                c.setFont(this.font);
            }
            if (this.name != null) {
                c.setName(this.name);
            }
            Dimension dim = null;
            if (this.width != -1) {
                if (dim == null) {
                    dim = c.getPreferredSize();
                }
                dim.width = this.width;
            }
            if (this.height != -1) {
                if (dim == null) {
                    dim = c.getPreferredSize();
                }
                dim.height = this.height;
            }
            if (c instanceof JComponent) {
                if (dim != null) {
                    ((JComponent)c).setPreferredSize(dim);
                }
            } else if (dim != null) {
                c.setSize(dim);
            }
            if (c instanceof JComponent) {
                dim = null;
                if (this.maxWidth != -1) {
                    if (dim == null) {
                        dim = c.getMaximumSize();
                    }
                    dim.width = this.maxWidth;
                }
                if (this.maxHeight != -1) {
                    if (dim == null) {
                        dim = c.getMaximumSize();
                    }
                    dim.height = this.maxHeight;
                }
                if (dim != null) {
                    ((JComponent)c).setMaximumSize(dim);
                }
            }
        }

        protected Component createComponent() throws ExpressionException {
            return null;
        }

        protected List createComponents() throws ExpressionException {
            Component c = this.createComponent();
            if (c == null) {
                return Collections.EMPTY_LIST;
            }
            LinkedList<Component> out = new LinkedList<Component>();
            out.add(c);
            return out;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }
    }
}

