/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.swing.XMLLayoutComponent;

public class XMLLayoutUtil {
    protected static final Logger logger = Logger.getLogger(XMLLayoutUtil.class);

    private XMLLayoutUtil() {
    }

    public static Collection<ExpressionException> guiupdateAll() {
        LinkedList<ExpressionException> out = new LinkedList<ExpressionException>();
        for (Frame frame : Frame.getFrames()) {
            XMLLayoutUtil.guiupdateTree(frame, out);
        }
        return out;
    }

    protected static void guiupdateTree(Window w, Collection<ExpressionException> exceptions) {
        for (Window child : w.getOwnedWindows()) {
            XMLLayoutUtil.guiupdateTree(child);
        }
        XMLLayoutUtil.guiupdateTree((Component)w, exceptions);
    }

    public static Collection<ExpressionException> guiupdateTree(Component c) {
        LinkedList<ExpressionException> out = new LinkedList<ExpressionException>();
        XMLLayoutUtil.guiupdateTree(c, out);
        c.repaint();
        return out;
    }

    protected static void guiupdateTree(Component c, Collection<ExpressionException> exceptions) {
        if (c instanceof XMLLayoutComponent) {
            try {
                ((XMLLayoutComponent)((Object)c)).guiupdate();
            }
            catch (ExpressionException e) {
                exceptions.add(e);
            }
        }
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                XMLLayoutUtil.guiupdateTree(child, exceptions);
            }
        }
    }
}

