/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.autocomplete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bbop.swing.autocomplete.AutocompleteModel;
import org.bbop.swing.autocomplete.MatchPair;
import org.bbop.util.AbstractTaskDelegate;
import org.bbop.util.StringUtil;
import org.bbop.util.TaskDelegate;

public abstract class AbstractAutocompleteModel<DISPLAY_TYPE, OUTPUT_TYPE>
implements AutocompleteModel<DISPLAY_TYPE, OUTPUT_TYPE> {
    protected MatchPairComparator matchComparator = new MatchPairComparator();

    protected boolean isIgnoreCase() {
        return true;
    }

    @Override
    protected Collection<DISPLAY_TYPE> getDisplayValues(Collection<OUTPUT_TYPE> values) {
        HashSet out = new HashSet();
        for (OUTPUT_TYPE o : values) {
            out.addAll(this.getDisplayValues(o));
        }
        return out;
    }

    protected Collection<OUTPUT_TYPE> getOutputValues(Collection<DISPLAY_TYPE> values) {
        HashSet out = new HashSet();
        for (DISPLAY_TYPE d : values) {
            out.add(this.getOutputValue(d));
        }
        return out;
    }

    @Override
    public TaskDelegate<List<MatchPair<DISPLAY_TYPE>>> getObjects(List<String> tokens) {
        return new MatchTaskDelegate(tokens);
    }

    @Override
    public double getWeight(DISPLAY_TYPE val) {
        return 1.0;
    }

    protected class MatchTaskDelegate
    extends AbstractTaskDelegate<List<MatchPair<DISPLAY_TYPE>>> {
        protected List<String> tokens;

        public MatchTaskDelegate(List<String> tokens) {
            this.tokens = tokens;
        }

        @Override
        public void execute() {
            try {
                ArrayList out = new ArrayList();
                Collection vals = AbstractAutocompleteModel.this.getAllValues();
                for (Object obj : vals) {
                    if (this.cancelled) {
                        return;
                    }
                    String s = AbstractAutocompleteModel.this.toString(obj);
                    Map<String, int[]> hits = StringUtil.getMatchMap(s, this.tokens, true, AbstractAutocompleteModel.this.isIgnoreCase());
                    if (this.cancelled) {
                        return;
                    }
                    if (hits.size() <= 0) continue;
                    double weight = AbstractAutocompleteModel.this.getWeight(obj);
                    MatchPair mp = new MatchPair(obj, s, this.tokens, weight, hits);
                    out.add(mp);
                }
                Collections.sort(out, AbstractAutocompleteModel.this.matchComparator);
                if (this.cancelled) {
                    return;
                }
                this.setResults(out);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected class MatchPairComparator
    implements Comparator<MatchPair<DISPLAY_TYPE>> {
        protected MatchPairComparator() {
        }

        @Override
        public int compare(MatchPair<DISPLAY_TYPE> o1, MatchPair<DISPLAY_TYPE> o2) {
            int intVal;
            double val = o2.getScore() - o1.getScore();
            if (Math.abs(val) < 1.0 && val != 0.0) {
                val = 1.0 / val;
            }
            if ((intVal = (int)val) == 0) {
                int lengthMatch = o1.getString().length() - o2.getString().length();
                if (lengthMatch == 0) {
                    return o1.getString().compareToIgnoreCase(o2.getString());
                }
                return lengthMatch;
            }
            return intVal;
        }
    }
}

