/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.autocomplete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.swing.autocomplete.AutocompleteModel;
import org.bbop.swing.autocomplete.MatchPair;
import org.bbop.util.AbstractTaskDelegate;
import org.bbop.util.StringUtil;
import org.bbop.util.TaskDelegate;

public class StringAlgorithmAutocompleteModel
implements AutocompleteModel<StringPair, String> {
    protected static final Logger logger = Logger.getLogger(StringAlgorithmAutocompleteModel.class);
    protected StringGenerator algorithm;

    public StringAlgorithmAutocompleteModel() {
        this(null);
    }

    public StringAlgorithmAutocompleteModel(StringGenerator algorithm) {
        this.setAlgorithm(algorithm);
    }

    public void setAlgorithm(StringGenerator algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public StringPair createValue(String val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<StringPair> getAllValues() {
        return Collections.emptySet();
    }

    @Override
    public Class<StringPair> getDisplayType() {
        return StringPair.class;
    }

    @Override
    public List<StringPair> getDisplayValues(String val) {
        Collection<String> strs = this.algorithm.generateStrings(val);
        LinkedList<StringPair> out = new LinkedList<StringPair>();
        out.add(new StringPair(val, val));
        for (String str : strs) {
            out.add(new StringPair(val, str));
        }
        return out;
    }

    @Override
    public Class<String> getOutputType() {
        return String.class;
    }

    @Override
    public String getOutputValue(StringPair val) {
        return val.getGenerated();
    }

    @Override
    public boolean isLegal(StringPair val) {
        return true;
    }

    @Override
    public String toString(StringPair val) {
        return val.getGenerated();
    }

    protected boolean isIgnoreCase() {
        return true;
    }

    @Override
    public TaskDelegate<List<MatchPair<StringPair>>> getObjects(List<String> tokens) {
        return new MatchTaskDelegate(tokens);
    }

    @Override
    public double getWeight(StringPair val) {
        return 1.0;
    }

    protected class MatchTaskDelegate
    extends AbstractTaskDelegate<List<MatchPair<StringPair>>> {
        protected List<String> tokens;

        public MatchTaskDelegate(List<String> tokens) {
            this.tokens = tokens;
        }

        @Override
        public void execute() {
            ArrayList<MatchPair<StringPair>> out = new ArrayList<MatchPair<StringPair>>();
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (String token : this.tokens) {
                if (this.cancelled) {
                    return;
                }
                if (first) {
                    first = false;
                } else {
                    buffer.append(" ");
                }
                buffer.append(token);
            }
            String str = buffer.toString();
            List<String> newTokens = Collections.singletonList(str);
            if (this.cancelled) {
                return;
            }
            List<StringPair> pairs = StringAlgorithmAutocompleteModel.this.getDisplayValues(buffer.toString());
            if (this.cancelled) {
                return;
            }
            for (StringPair pair : pairs) {
                if (this.cancelled) {
                    return;
                }
                String s = pair.getGenerated();
                Map<String, int[]> hits = StringUtil.getMatchMap(s, newTokens, true, StringAlgorithmAutocompleteModel.this.isIgnoreCase());
                if (this.cancelled) {
                    return;
                }
                if (hits.size() <= 0) continue;
                double weight = StringAlgorithmAutocompleteModel.this.getWeight(pair);
                MatchPair<StringPair> mp = new MatchPair<StringPair>(pair, s, newTokens, weight, hits);
                out.add(mp);
            }
            this.setResults(out);
        }
    }

    public static interface StringGenerator {
        public Collection<String> generateStrings(String var1);
    }

    public static class StringPair {
        protected String original;
        protected String generated;

        public StringPair(String original, String generated) {
            this.original = original;
            this.generated = generated;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getGenerated() {
            return this.generated;
        }
    }
}

