/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.dropbox;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.bbop.swing.dropbox.DropBoxContents;

public class DragHandler
extends MouseInputAdapter {
    protected static final Logger logger = Logger.getLogger(DragHandler.class);
    protected MouseEvent firstMouseEvent;
    protected DropBoxContents contents;

    public DragHandler(DropBoxContents contents) {
        this.contents = contents;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.firstMouseEvent = e;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.firstMouseEvent != null) {
            JComponent c = (JComponent)e.getComponent();
            TransferHandler handler = c.getTransferHandler();
            handler.exportAsDrag(c, this.firstMouseEvent, 1);
            logger.info((Object)("exporting drag " + e));
            this.firstMouseEvent = null;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.firstMouseEvent = null;
    }
}

