/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.dropbox;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;
import org.bbop.swing.dropbox.DragHandler;
import org.bbop.swing.dropbox.DropBoxContents;
import org.bbop.swing.dropbox.DropBoxContentsTransferable;
import org.bbop.swing.dropbox.DropBoxPanel;

public class DropBoxTransferHandler
extends TransferHandler {
    protected static final Logger logger = Logger.getLogger(DropBoxTransferHandler.class);
    private static final long serialVersionUID = -1195744937397730938L;
    protected DragHandler selectorDragHandler;
    protected DropBoxContents sourceSelector;
    protected Component handle;

    public DropBoxTransferHandler(DropBoxContents c, Component handle) {
        this.sourceSelector = c;
        this.handle = handle;
        this.selectorDragHandler = new DragHandler(c);
    }

    public Component getHandle() {
        return this.handle;
    }

    public static DropBoxTransferHandler installHandler(DropBoxContents c, Component handle) {
        DropBoxTransferHandler handler = new DropBoxTransferHandler(c, handle);
        ((JComponent)handle).setTransferHandler(handler);
        handle.addMouseMotionListener(handler.getDropBoxDragHandler());
        handle.addMouseListener(handler.getDropBoxDragHandler());
        return handler;
    }

    public DropBoxContents getObjectSelector() {
        return this.sourceSelector;
    }

    public static void removeHandler(DropBoxTransferHandler handler) {
        ((JComponent)handler.getHandle()).setTransferHandler(null);
        ((JComponent)handler.getHandle()).removeMouseMotionListener(handler.getDropBoxDragHandler());
        ((JComponent)handler.getHandle()).removeMouseListener(handler.getDropBoxDragHandler());
    }

    public DragHandler getDropBoxDragHandler() {
        return this.selectorDragHandler;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (!(c instanceof DropBoxPanel)) {
            return false;
        }
        if (this.canImport(c, t.getTransferDataFlavors())) {
            DropBoxPanel droppable = (DropBoxPanel)c;
            try {
                this.sourceSelector = (DropBoxContents)t.getTransferData(DropBoxContentsTransferable.DROP_BOX_CONTENTS_FLAVOR);
                droppable.add((Component)((Object)this.sourceSelector));
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                System.out.println("importData: unsupported data flavor");
            }
            catch (IOException ioe) {
                System.out.println("importData: I/O exception");
            }
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new DropBoxContentsTransferable(this.sourceSelector);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!DropBoxContentsTransferable.DROP_BOX_CONTENTS_FLAVOR.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

