/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.plaf;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import org.apache.log4j.Logger;
import org.bbop.swing.DragFriendlyUI;

public class DragFriendlyListUI
extends BasicListUI
implements DragFriendlyUI {
    protected static final Logger logger = Logger.getLogger(DragFriendlyListUI.class);
    protected boolean dragging = false;

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseFriendlyInputHandler();
    }

    @Override
    public void setIsDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public class MouseFriendlyInputHandler
    implements MouseInputListener {
        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row;
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!DragFriendlyListUI.this.list.isEnabled()) {
                return;
            }
            if (!DragFriendlyListUI.this.list.hasFocus()) {
                DragFriendlyListUI.this.list.requestFocus();
            }
            if ((row = DragFriendlyListUI.this.convertYToRow(e.getY())) != -1) {
                DragFriendlyListUI.this.list.setValueIsAdjusting(true);
                int anchorIndex = DragFriendlyListUI.this.list.getAnchorSelectionIndex();
                if (e.isControlDown()) {
                    if (DragFriendlyListUI.this.list.isSelectedIndex(row)) {
                        DragFriendlyListUI.this.list.removeSelectionInterval(row, row);
                    } else {
                        DragFriendlyListUI.this.list.addSelectionInterval(row, row);
                    }
                } else if (e.isShiftDown() && anchorIndex != -1) {
                    DragFriendlyListUI.this.list.setSelectionInterval(anchorIndex, row);
                } else {
                    DragFriendlyListUI.this.list.setSelectionInterval(row, row);
                }
                DragFriendlyListUI.this.list.setValueIsAdjusting(false);
            }
        }
    }
}

