/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.bbop.swing.autocomplete.AutocompleteModel;
import org.bbop.swing.autocomplete.MatchPair;
import org.bbop.swing.autocomplete.StringListAutocompleteModel;
import org.bbop.util.StringUtil;
import org.bbop.util.TaskDelegate;

public class AutocompleteBox<T>
extends JComboBox {
    protected static final Logger logger = Logger.getLogger(AutocompleteBox.class);
    protected FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            AutocompleteBox.this.hidePopup();
        }
    };
    protected AutocompleteModel autocompleteModel;
    protected ListCellRenderer renderer = new BasicComboBoxRenderer(){
        protected JLabel label = new JLabel();

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index < 0) {
                return this.label;
            }
            if (isSelected) {
                this.label.setOpaque(true);
                this.label.setBackground(AutocompleteBox.this.selectionBackground);
            } else {
                this.label.setOpaque(false);
            }
            MatchPair pair = AutocompleteBox.this.lastHits.get(index);
            String s = "<html>" + AutocompleteBox.this.formatHTML(pair) + "</html>";
            this.label.setText(s);
            return this.label;
        }
    };
    protected Color selectionBackground = Color.blue;
    protected DropTargetListener dropListener = new DropTargetListener(){
        LineBorder border = new LineBorder(Color.black, 2);
        Border oldBorder;

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (!AutocompleteBox.this.allowDrop(dtde)) {
                this.oldBorder = null;
                dtde.rejectDrag();
            }
            this.oldBorder = AutocompleteBox.this.getBorder();
            AutocompleteBox.this.setBorder(this.border);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            if (this.oldBorder != null) {
                AutocompleteBox.this.setBorder(this.oldBorder);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (!AutocompleteBox.this.allowDrop(dtde)) {
                this.oldBorder = null;
                dtde.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    };
    protected Collection<ActionListener> commitListeners = new LinkedList<ActionListener>();
    protected Collection<ActionListener> updateListeners = new LinkedList<ActionListener>();
    protected JList list;
    protected String id = "";
    protected Object cachedSelectedItem = null;
    protected List<MatchPair> lastHits;
    protected Timer timer = new Timer(true);
    protected TimerTask currentTask = null;
    protected int updateInterval = 100;
    protected boolean allowNonModelValues = false;
    protected boolean changing = false;
    protected int maxResults = 10;
    protected int minLength = 3;
    protected Comparator<MatchPair> alphabeticOrdering = new Comparator<MatchPair>(){

        @Override
        public int compare(MatchPair o1, MatchPair o2) {
            return o1.getString().compareToIgnoreCase(o2.getString());
        }
    };

    public void setAutocompleteModel(AutocompleteModel<?, T> model) {
        this.autocompleteModel = model;
    }

    public AutocompleteModel getAutocompleteModel() {
        return this.autocompleteModel;
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.selectionBackground = selectionBackground;
    }

    protected String formatHTML(MatchPair<?> hit) {
        StringBuffer buffer = new StringBuffer(hit.getString());
        ArrayList<int[]> indexList = new ArrayList<int[]>();
        for (String s : hit.getMatch().keySet()) {
            int[] indices;
            for (int index : indices = hit.getMatch().get(s)) {
                int[] indexPair = new int[]{index, s.length()};
                indexList.add(indexPair);
            }
        }
        Collections.sort(indexList, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return o2[0] - o1[0];
            }
        });
        for (int[] strHit : indexList) {
            int startIndex = strHit[0];
            int endIndex = startIndex + strHit[1];
            if (endIndex >= buffer.length()) {
                buffer.append("</b>");
            } else {
                buffer.insert(endIndex, "</b>");
            }
            buffer.insert(startIndex, "<b>");
        }
        return buffer.toString();
    }

    @Override
    protected void fireActionEvent() {
    }

    public void addCommitListener(ActionListener listener) {
        this.commitListeners.add(listener);
    }

    public void removeCommitListener(ActionListener listener) {
        this.commitListeners.remove(listener);
    }

    public void addUpdateListener(ActionListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ActionListener listener) {
        this.updateListeners.remove(listener);
    }

    protected void fireUpdateEvent() {
        ActionEvent e = new ActionEvent(this, 0, "update");
        for (ActionListener listener : this.updateListeners) {
            listener.actionPerformed(e);
        }
    }

    protected boolean allowDrop(DropTargetDragEvent selection) {
        return false;
    }

    public void setValue(T object) {
        if (object == null) {
            if (this.getSelectedItem() != null) {
                // empty if block
            }
            this.setSelectedItem(null);
        } else {
            List values = this.autocompleteModel.getDisplayValues(object);
            if (values.size() > 0) {
                this.setSelectedItem(values.get(0));
            } else {
                this.setSelectedItem(null);
            }
        }
    }

    public T getValue() {
        if (this.getSelectedItem() == null) {
            return null;
        }
        Object selected = this.getSelectedItem();
        if (this.allowNonModelValues) {
            String s = ((JTextComponent)((Object)this.editor)).getText();
            if (!this.autocompleteModel.toString(this.getSelectedItem()).equals(s)) {
                logger.debug((Object)("creating value " + s));
                return (T)this.autocompleteModel.getOutputValue(this.autocompleteModel.createValue(s));
            }
        }
        return (T)this.autocompleteModel.getOutputValue(selected);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject == null) {
            this.doSetSelectedItem(null);
        } else if (this.autocompleteModel.getDisplayType().isAssignableFrom(anObject.getClass())) {
            this.doSetSelectedItem(anObject);
            Object selected = this.getSelectedItem();
        } else if (this.autocompleteModel.getOutputType().isAssignableFrom(anObject.getClass())) {
            List values = this.autocompleteModel.getDisplayValues(anObject);
            if (values.size() > 0) {
                this.doSetSelectedItem(values.get(0));
            } else {
                this.doSetSelectedItem(null);
            }
        } else if (anObject instanceof String) {
            this.doSetSelectedItem(this.autocompleteModel.createValue((String)anObject));
        }
        if (this.isEditable() && this.getEditor() != null) {
            this.configureEditor(this.getEditor(), this.getSelectedItem());
        }
    }

    protected void doSetSelectedItem(Object o) {
        if (o == null) {
            super.setSelectedItem(null);
        } else if (this.allowNonModelValues || this.autocompleteModel.isLegal(o)) {
            super.setSelectedItem(o);
        } else {
            super.setSelectedItem(null);
        }
    }

    protected JList createList() {
        if (this.list == null) {
            this.list = new JList(this.getModel()){

                @Override
                public void processMouseEvent(MouseEvent e) {
                    if (e.isControlDown()) {
                        e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ 2, e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                    }
                    super.processMouseEvent(e);
                }
            };
        }
        return this.list;
    }

    public AutocompleteBox() {
        this((AutocompleteModel)null);
    }

    public AutocompleteBox(AutocompleteModel model, String id) {
        this(model);
        this.setId(id);
    }

    public AutocompleteBox(AutocompleteModel model) {
        this.setEditor(new AutoTextField());
        this.setAutocompleteModel(model);
        this.setModel(new AutocompleteListModel());
        this.setEditable(true);
        this.setRenderer(this.renderer);
        this.setValue(null);
        this.setDropTarget(new DropTarget(this, this.dropListener));
        this.addFocusListener(this.focusListener);
        super.setUI(new MetalComboBoxUI(){
            protected boolean userRequestedPopup = false;
            protected MouseListener buttonListener;

            @Override
            protected ComboPopup createPopup() {
                return new BasicComboPopup(AutocompleteBox.this){
                    protected boolean poppingUp;
                    {
                        this.poppingUp = false;
                    }

                    protected JList createList() {
                        return AutocompleteBox.this.createList();
                    }

                    @Override
                    public void show(Component invoker, int x, int y) {
                        if (this.poppingUp) {
                            return;
                        }
                        this.poppingUp = true;
                        if (userRequestedPopup) {
                            JTextComponent text = (JTextComponent)((Object)AutocompleteBox.this.editor);
                            if (text.getText().length() == 0) {
                                ArrayList list = new ArrayList();
                                list.addAll(AutocompleteBox.this.getAutocompleteModel().getAllValues());
                                AutocompleteBox.this.setDisplayResults(list);
                            } else {
                                TimerTask task = AutocompleteBox.this.createTimerTask(text.getText(), false);
                                task.run();
                            }
                        }
                        this.setPopupSize(AutocompleteBox.this.getWidth(), this.getPopupHeightForRowCount(AutocompleteBox.this.getMaximumRowCount()));
                        super.show(invoker, x, y);
                        this.poppingUp = false;
                    }
                };
            }

            @Override
            protected JButton createArrowButton() {
                return super.createArrowButton();
            }

            @Override
            public void configureArrowButton() {
                super.configureArrowButton();
                if (this.arrowButton != null) {
                    this.arrowButton.removeMouseListener(this.popup.getMouseListener());
                    this.arrowButton.addMouseListener(this.getButtonListener());
                }
            }

            @Override
            public void unconfigureArrowButton() {
                super.unconfigureArrowButton();
                if (this.arrowButton != null) {
                    this.arrowButton.removeMouseListener(this.getButtonListener());
                }
            }

            @Override
            protected FocusListener createFocusListener() {
                return null;
            }

            protected MouseListener getButtonListener() {
                if (this.buttonListener == null) {
                    this.buttonListener = new MouseListener(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            popup.getMouseListener().mouseClicked(e);
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            popup.getMouseListener().mouseEntered(e);
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            popup.getMouseListener().mouseExited(e);
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                            userRequestedPopup = true;
                            popup.getMouseListener().mousePressed(e);
                            userRequestedPopup = false;
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            popup.getMouseListener().mouseReleased(e);
                        }
                    };
                }
                return this.buttonListener;
            }

            @Override
            public void configureEditor() {
                super.configureEditor();
                this.editor.removeFocusListener(super.createFocusListener());
            }
        });
    }

    @Override
    public void setUI(ComboBoxUI ui) {
    }

    @Override
    protected void setUI(ComponentUI newUI) {
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
        super.setFocusTraversalKeysEnabled(focusTraversalKeysEnabled);
        if (this.getEditor() instanceof Component) {
            ((Component)((Object)this.getEditor())).setFocusTraversalKeysEnabled(focusTraversalKeysEnabled);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAllowNonModelValues(boolean allowNonModelValues) {
        this.allowNonModelValues = allowNonModelValues;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public String getEditorText() {
        AutoTextField field = (AutoTextField)this.getEditor();
        if (field == null) {
            return null;
        }
        return field.getText();
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public static void main(String[] args) {
        JDialog dialog = new JDialog((Frame)null, true);
        AutocompleteBox<String> box = new AutocompleteBox<String>();
        LinkedList<String> stringList = new LinkedList<String>();
        for (int i = 0; i < 200; ++i) {
            stringList.add(StringUtil.createRandomString(20));
        }
        box.setAutocompleteModel(new StringListAutocompleteModel(stringList));
        dialog.getContentPane().setLayout(new BoxLayout(dialog.getContentPane(), 0));
        dialog.getContentPane().add(box);
        dialog.getContentPane().add(Box.createHorizontalStrut(20));
        dialog.getContentPane().add(new JButton("button"));
        dialog.setVisible(true);
    }

    protected void updateSearchText(String str) {
        this.killPendingTasks();
        this.currentTask = this.createTimerTask(str, true);
        this.timer.schedule(this.currentTask, this.getUpdateInterval());
    }

    protected void killPendingTasks() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.currentTask = null;
    }

    protected void autocompleteSingleWord() {
        AutoTextField field = (AutoTextField)this.getEditor();
        if (field == null) {
            return;
        }
        String text = this.getEditorText();
        int cursorPos = field.getCaretPosition() - 1;
        int[] replaceIndices = StringUtil.getWordIndicesSurrounding(text, cursorPos, cursorPos);
        String currentWord = text.substring(replaceIndices[0], replaceIndices[1]);
        for (MatchPair matchPair : this.lastHits) {
            int[] indices = matchPair.getMatch().get(currentWord);
            if (indices == null) continue;
            int index = indices[0];
            String match = StringUtil.getWordSurrounding(matchPair.getString(), index, index);
            text = text.substring(0, replaceIndices[0]) + match + text.substring(replaceIndices[1], text.length());
            field.setText(text);
            return;
        }
    }

    protected TimerTask createTimerTask(final String str, final boolean invokeLater) {
        return new TimerTask(){
            protected boolean cancelled = false;
            TaskDelegate del;

            @Override
            public void run() {
                LinkedList<String> tokens = new LinkedList<String>();
                boolean longEnough = false;
                StringTokenizer st = new StringTokenizer(str);
                while (st.hasMoreTokens()) {
                    if (this.cancelled) {
                        return;
                    }
                    String token = st.nextToken();
                    if (token.length() >= AutocompleteBox.this.getMinLength()) {
                        longEnough = true;
                    }
                    tokens.add(token);
                }
                if (invokeLater && !longEnough) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutocompleteBox.this.setResults(Collections.emptyList());
                        }
                    });
                    return;
                }
                this.del = AutocompleteBox.this.autocompleteModel.getObjects(tokens);
                if (this.cancelled) {
                    return;
                }
                this.del.run();
                if (this.cancelled) {
                    return;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (!cancelled) {
                            AutocompleteBox.this.setResults((List)del.getResults());
                        }
                    }
                };
                if (invokeLater) {
                    SwingUtilities.invokeLater(r);
                } else {
                    r.run();
                }
            }

            @Override
            public boolean cancel() {
                this.cancelled = true;
                if (this.del != null) {
                    this.del.cancel();
                }
                return super.cancel();
            }
        };
    }

    protected List getMatches(String str) {
        LinkedList<String> tokens = new LinkedList<String>();
        boolean longEnough = false;
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() >= this.getMinLength()) {
                longEnough = true;
            }
            tokens.add(token);
        }
        TaskDelegate del = this.autocompleteModel.getObjects(tokens);
        del.run();
        return del.getResults();
    }

    protected void setDisplayResults(Collection results) {
        ArrayList matchList = new ArrayList(results.size());
        for (Object o : results) {
            MatchPair p = new MatchPair(o, this.autocompleteModel.toString(o), Collections.emptyList(), 1.0, Collections.emptyMap());
            matchList.add(p);
        }
        Collections.sort(matchList, this.alphabeticOrdering);
        this.setResults(matchList);
    }

    protected void setResults(List results) {
        this.lastHits = results;
        ((AutocompleteListModel)this.getModel()).update();
        if (this.lastHits != null) {
            if (this.lastHits.size() == 0) {
                super.setSelectedItem(null);
            } else {
                Object val = this.lastHits.get(0).getVal();
                super.setSelectedItem(null);
                if (this.isShowing() && this.hasMeaningfulFocus()) {
                    this.showPopup();
                }
            }
        }
    }

    public boolean hasMeaningfulFocus() {
        return this.isFocusOwner() || ((JComponent)((Object)this.getEditor())).isFocusOwner();
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    protected class AutocompleteListModel
    implements ComboBoxModel {
        protected Collection<ListDataListener> listeners = new LinkedList<ListDataListener>();
        protected Object selected;
        protected boolean updating = false;

        protected AutocompleteListModel() {
        }

        public boolean isUpdating() {
            return this.updating;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        public void update() {
            this.updating = true;
            ListDataEvent event = new ListDataEvent(AutocompleteBox.this, 0, 0, this.getSize());
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(event);
            }
            this.updating = false;
        }

        @Override
        public Object getElementAt(int index) {
            return AutocompleteBox.this.lastHits.get(index).getVal();
        }

        @Override
        public int getSize() {
            if (AutocompleteBox.this.lastHits == null) {
                return 0;
            }
            if (AutocompleteBox.this.getMaxResults() < 0) {
                return AutocompleteBox.this.lastHits.size();
            }
            return Math.min(AutocompleteBox.this.getMaxResults(), AutocompleteBox.this.lastHits.size());
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = anItem;
        }
    }

    protected class AutoTextField
    extends JTextField
    implements ComboBoxEditor {
        protected boolean updating = false;
        protected Runnable updateRunnable = new Runnable(){

            @Override
            public void run() {
                AutoTextField.this.update();
            }
        };
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AutoTextField.this.updateLater();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AutoTextField.this.updateLater();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AutoTextField.this.updateLater();
            }
        };
        protected KeyListener keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0 && e.isShiftDown() || e.isControlDown())) {
                    AutocompleteBox.this.autocompleteSingleWord();
                } else if (e.getKeyCode() == 10) {
                    boolean isVisible = AutocompleteBox.this.isPopupVisible();
                    int index = AutocompleteBox.this.list.getSelectedIndex();
                    if (isVisible && index >= 0) {
                        AutoTextField.this.commit(false);
                    } else {
                        AutocompleteBox.super.fireActionEvent();
                    }
                } else if (AutocompleteBox.this.isPopupVisible()) {
                    if (e.getKeyCode() == 40) {
                        int newIndex = AutocompleteBox.this.list.getSelectedIndex();
                        if (newIndex + 1 < AutocompleteBox.this.list.getModel().getSize()) {
                            ++newIndex;
                        }
                        AutocompleteBox.this.list.setSelectedIndex(newIndex);
                        AutocompleteBox.this.list.ensureIndexIsVisible(newIndex);
                    } else if (e.getKeyCode() == 38) {
                        int newIndex = AutocompleteBox.this.list.getSelectedIndex();
                        if (newIndex - 1 >= 0) {
                            --newIndex;
                        }
                        AutocompleteBox.this.list.setSelectedIndex(newIndex);
                        AutocompleteBox.this.list.ensureIndexIsVisible(newIndex);
                    }
                } else if (e.getKeyCode() == 40) {
                    AutocompleteBox.this.showPopup();
                }
            }
        };
        protected FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (AutocompleteBox.this.allowNonModelValues || AutocompleteBox.this.getSelectedItem() == null && AutoTextField.this.getText().length() >= AutocompleteBox.this.getMinLength() && AutocompleteBox.this.getItemCount() > 0) {
                    AutoTextField.this.commit(true);
                } else if (AutocompleteBox.this.getSelectedItem() != null) {
                    String s = AutocompleteBox.this.autocompleteModel.toString(AutocompleteBox.this.getSelectedItem());
                    AutoTextField.this.setText(s);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };

        protected void updateLater() {
            SwingUtilities.invokeLater(this.updateRunnable);
        }

        public AutoTextField() {
            this.getDocument().addDocumentListener(this.docListener);
            this.addKeyListener(this.keyListener);
            this.addFocusListener(this.focusListener);
        }

        public void commit(boolean focusCommit) {
            AutocompleteBox.this.killPendingTasks();
            if (this.getText().length() == 0) {
                AutocompleteBox.this.setSelectedItem(null);
            } else if (!(focusCommit && AutocompleteBox.this.allowNonModelValues || AutocompleteBox.this.lastHits == null || AutocompleteBox.this.lastHits.size() <= 0)) {
                AutocompleteBox.this.setSelectedItem(AutocompleteBox.this.list.getSelectedValue());
            } else if (AutocompleteBox.this.allowNonModelValues) {
                try {
                    AutocompleteBox.this.setSelectedItem(AutocompleteBox.this.autocompleteModel.createValue(this.getText()));
                }
                catch (Exception e) {
                    logger.debug((Object)("Exception while calling setSelectedItem(autocompleteModel.createValue(" + this.getText() + ")--oh well; doesn't seem to matter."));
                }
            }
            ActionEvent e = new ActionEvent(AutocompleteBox.this, (int)(Math.random() * 2.147483647E9), "commit");
            for (ActionListener listener : AutocompleteBox.this.commitListeners) {
                listener.actionPerformed(e);
            }
            AutocompleteBox.this.fireUpdateEvent();
            AutocompleteBox.this.hidePopup();
            AutocompleteBox.this.list.setSelectedIndex(-1);
        }

        protected void update() {
            this.updating = true;
            this.getDocument().removeDocumentListener(this.docListener);
            try {
                String text = this.getDocument().getText(0, this.getDocument().getLength());
                AutocompleteBox.this.updateSearchText(text);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            AutocompleteBox.this.fireUpdateEvent();
            this.getDocument().addDocumentListener(this.docListener);
            this.updating = false;
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            Object out = null;
            if (AutocompleteBox.this.lastHits != null && AutocompleteBox.this.lastHits.size() > 0 && AutocompleteBox.this.list.getSelectedIndex() >= 0) {
                out = AutocompleteBox.this.lastHits.get(AutocompleteBox.this.list.getSelectedIndex()).getVal();
            }
            return out;
        }

        @Override
        public void setText(String t) {
            if (((AutocompleteListModel)AutocompleteBox.this.getModel()).isUpdating() || this.updating) {
                return;
            }
            this.updating = true;
            super.setText(t);
            this.updating = false;
        }

        @Override
        public void setItem(Object anObject) {
            this.getDocument().removeDocumentListener(this.docListener);
            if (anObject == null) {
                this.setText("");
            } else {
                this.setText(AutocompleteBox.this.autocompleteModel.toString(anObject));
            }
            this.getDocument().addDocumentListener(this.docListener);
        }
    }
}

