/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.bbop.swing.FocusHierarchyListener;
import org.bbop.swing.FocusHierarchyManager;
import org.bbop.swing.HTMLTableRenderer;
import org.bbop.swing.tablelist.ListTableEditor;

public class TableList<T>
extends JComponent {
    protected static final Logger logger = Logger.getLogger(TableList.class);
    protected boolean completingEdit = false;
    protected ListTableEditor<T> editor;
    protected TableCellRenderer renderer = new HTMLTableRenderer();
    protected List<T> data = new ArrayList<T>();
    protected ActionListener commitListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ListTableCellEditor tce = (ListTableCellEditor)TableList.this.table.getDefaultEditor(Object.class);
            tce.stopCellEditing();
        }
    };
    protected JTable table;
    protected int lastEditRow = -1;
    protected FocusHierarchyListener focusListener = new FocusHierarchyListener(){

        @Override
        public void focusGained(FocusEvent e) {
            logger.debug((Object)"TableList.focusGained");
        }

        @Override
        public void focusLost(FocusEvent e) {
            logger.debug((Object)"TableList.focusLost");
        }
    };

    public TableList() {
        this(false, false);
    }

    public TableList(boolean wrapInScroller, boolean installButtons) {
        this.setOpaque(false);
        this.table = new ListTable();
        this.setLayout(new BorderLayout());
        this.table.setDefaultEditor(Object.class, new ListTableCellEditor());
        this.table.setDefaultRenderer(Object.class, new ListTableCellRenderer());
        this.table.setModel(new ListTableModel());
        if (wrapInScroller) {
            this.add((Component)new JScrollPane(this.table), "Center");
        } else {
            this.add((Component)this.table, "Center");
        }
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                List l = TableList.this.getSelection();
                for (Object t : l) {
                    if (TableList.this.data.contains(t)) continue;
                    TableList.this.setSelection(l);
                    return;
                }
            }
        });
        if (installButtons) {
            this.installDefaultButtons();
        }
    }

    public void installDefaultButtons() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        ImageIcon plusIcon = new ImageIcon(this.getClass().getResource("/org/bbop/swing/tablelist/resources/plus.gif"));
        ImageIcon minusIcon = new ImageIcon(this.getClass().getResource("/org/bbop/swing/tablelist/resources/minus.gif"));
        JButton add = new JButton(plusIcon);
        final JButton remove = new JButton(minusIcon);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(add);
        panel.add(remove);
        this.add((Component)panel, "South");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableList.this.add();
                remove.setEnabled(TableList.this.getSelectedRowCount() > 0 || TableList.this.table.isEditing());
            }
        });
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableList.this.deleteSelectedRows();
            }
        });
        this.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                remove.setEnabled(TableList.this.getSelectedRowCount() > 0 || TableList.this.table.isEditing());
            }
        });
        remove.setEnabled(this.getSelectedRowCount() > 0 || this.table.isEditing());
    }

    public void setRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    protected void editNext() {
        this.completingEdit = true;
        int row = this.lastEditRow;
        this.editNext(row);
        this.completingEdit = false;
    }

    protected void editNext(int row) {
        if (row < this.table.getRowCount() - 1) {
            this.table.editCellAt(row + 1, 0);
        } else {
            this.createNewRow();
        }
    }

    public void commitPendingEdits() {
        logger.debug((Object)"TableList.commitPendingEdits");
        ListTableCellEditor tce = (ListTableCellEditor)this.table.getDefaultEditor(Object.class);
        if (!this.isEditing()) {
            tce.stopCellEditing();
        }
    }

    public void setSelectionMode(int mode) {
        this.table.setSelectionMode(mode);
    }

    public void add() {
        this.createNewRow();
    }

    public void add(T ... items) {
        this.add((Iterable<T>)Arrays.asList(items));
    }

    public void addTableModelListener(TableModelListener listener) {
        this.table.getModel().addTableModelListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.table.getModel().removeTableModelListener(listener);
    }

    public int getSelectedRowCount() {
        return this.getSelectedRows().length;
    }

    public void add(Iterable<T> items) {
        ((ListTableModel)this.table.getModel()).add(items);
    }

    public void deleteSelectedRows() {
        ((ListTableModel)this.table.getModel()).deleteSelectedRows();
    }

    public int getSelectionMode() {
        return this.table.getSelectionModel().getSelectionMode();
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().removeListSelectionListener(listener);
    }

    protected void createNewRow() {
        int row = ((ListTableModel)this.table.getModel()).addRow();
        this.table.getSelectionModel().clearSelection();
        this.table.getSelectionModel().addSelectionInterval(row, row);
        this.table.editCellAt(row, 0);
    }

    public void setEditor(ListTableEditor<T> editor) {
        if (this.editor != null) {
            this.editor.removeCommitListener(this.commitListener);
        }
        this.editor = editor;
        editor.addCommitListener(this.commitListener);
    }

    public void cancelEditing() {
        logger.debug((Object)"TableList.cancelEditing");
        this.table.removeEditor();
    }

    public ListTableEditor<T> getEditor() {
        return this.editor;
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public List<T> getSelection() {
        int[] rows;
        ArrayList<T> out = new ArrayList<T>();
        for (int row : rows = this.getSelectedRows()) {
            if (row >= this.data.size()) continue;
            out.add(this.data.get(row));
        }
        return out;
    }

    public void setSelection(Collection<T> c) {
        logger.debug((Object)"TableList.setSelection");
        ArrayList<Integer> temp = new ArrayList<Integer>();
        for (T t : c) {
            int index = this.data.indexOf(t);
            if (index == -1) continue;
            temp.add(index);
        }
        this.table.getSelectionModel().clearSelection();
        for (Integer i : temp) {
            this.table.getSelectionModel().addSelectionInterval(i, i);
        }
        this.repaint();
        this.validate();
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.table.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.table.removeMouseListener(l);
    }

    public void setData(T ... data) {
        this.setData((Collection<T>)Arrays.asList(data));
    }

    public boolean isEditing() {
        return this.table.isEditing();
    }

    public T getItemAt(Point p) {
        int row = this.table.rowAtPoint(p);
        if (row >= this.getData().size()) {
            return null;
        }
        return this.getData().get(row);
    }

    public void setData(Collection<T> data) {
        if (this.isEditing()) {
            this.cancelEditing();
        }
        this.data = new ArrayList<T>(data);
        ((ListTableModel)this.table.getModel()).fireTableDataChanged();
    }

    public List<T> getData() {
        this.flushEdits();
        return this.data;
    }

    protected void flushEdits() {
        if (this.table.isEditing()) {
            ((ListTableModel)this.table.getModel()).setValueAt(this.table.getEditingRow(), this.editor.getValue(), false);
            this.table.repaint();
        }
    }

    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    protected class ListTable
    extends JTable {
        protected boolean marginAdjust = false;

        protected ListTable() {
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component out = super.prepareEditor(editor, row, column);
            int requiredHeight = out.getPreferredSize().height * 2;
            if (requiredHeight != this.getRowHeight(row)) {
                this.setRowHeight(row, requiredHeight);
            }
            TableList.this.table.scrollRectToVisible(TableList.this.table.getCellRect(row, 0, true));
            return out;
        }

        @Override
        public boolean editCellAt(int row, int column, EventObject e) {
            TableList.this.lastEditRow = row;
            super.editCellAt(row, column, e);
            return false;
        }

        @Override
        public void removeEditor() {
            if (this.marginAdjust) {
                return;
            }
            if (!TableList.this.completingEdit) {
                TableList.this.editor.notifyCancel();
            }
            super.removeEditor();
        }

        @Override
        public void setCellEditor(TableCellEditor anEditor) {
            super.setCellEditor(anEditor);
            if (TableList.this.editor != null) {
                TableList.this.editor.notifyActive();
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            this.marginAdjust = true;
            super.columnMarginChanged(e);
            this.marginAdjust = false;
        }
    }

    protected class ListTableModel
    extends AbstractTableModel {
        protected ListTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return TableList.this.data.size();
        }

        public void addValue(T value) {
            TableList.this.data.add(value);
            this.fireTableRowsInserted(TableList.this.data.size() - 1, TableList.this.data.size() - 1);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return TableList.this.data.get(rowIndex);
        }

        public void setValueAt(int rowIndex, T value, boolean fireEvent) {
            if (rowIndex >= TableList.this.data.size()) {
                this.addValue(value);
            } else {
                TableList.this.data.set(rowIndex, value);
                if (fireEvent) {
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public int addRow() {
            TableList.this.data.add(TableList.this.editor.createNewValue());
            int row = TableList.this.data.size() - 1;
            this.fireTableRowsInserted(row, row);
            return row;
        }

        public void add(Iterable t) {
            int start = TableList.this.data.size();
            int count = 0;
            for (Object o : t) {
                TableList.this.data.add(o);
                ++count;
            }
            if (count > 0) {
                this.fireTableRowsInserted(start, start + count - 1);
            }
        }

        public void deleteSelectedRows() {
            int row = TableList.this.table.getEditingRow();
            if (row >= 0) {
                ListTableCellEditor te = (ListTableCellEditor)TableList.this.table.getDefaultEditor(Object.class);
                te.cancelCellEditing();
                TableList.this.data.remove(row);
            } else {
                int[] rows = TableList.this.table.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    TableList.this.data.remove(rows[i]);
                }
            }
            this.fireTableStructureChanged();
        }

        @Override
        public String getColumnName(int column) {
            return null;
        }
    }

    protected class ListTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public void notifyCancel() {
            TableList.this.editor.notifyCancel();
        }

        public void notifyActive() {
            TableList.this.editor.notifyActive();
            FocusHierarchyManager.addFocusHierarchyListener((Component)((Object)TableList.this.editor), TableList.this.focusListener);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (TableList.this.editor != null && (e == null || e instanceof MouseEvent && ((MouseEvent)e).getClickCount() == 2)) {
                return super.isCellEditable(e);
            }
            return false;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            try {
                TableList.this.editor.setValue(value);
                return (Component)((Object)TableList.this.editor);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public boolean stopCellEditing() {
            TableList.this.completingEdit = true;
            TableList.this.flushEdits();
            TableList.this.completingEdit = false;
            boolean b = super.stopCellEditing();
            FocusHierarchyManager.removeFocusHierarchyListener((Component)((Object)TableList.this.editor), TableList.this.focusListener);
            return b;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            FocusHierarchyManager.removeFocusHierarchyListener((Component)((Object)TableList.this.editor), TableList.this.focusListener);
        }

        @Override
        public Object getCellEditorValue() {
            return TableList.this.editor.getValue();
        }
    }

    protected class ListTableCellRenderer
    extends DefaultTableCellRenderer {
        protected ListTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component out = TableList.this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (out.getPreferredSize().height != table.getRowHeight(row)) {
                table.setRowHeight(row, out.getPreferredSize().height);
            }
            return out;
        }
    }
}

