/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.bbop.util.TaskDelegate;

public abstract class AbstractTaskDelegate<T>
implements TaskDelegate<T> {
    protected static final Logger logger = Logger.getLogger(AbstractTaskDelegate.class);
    protected boolean cancelled = false;
    protected boolean threwException = false;
    protected boolean running = false;
    protected boolean isSwingFriendly = false;
    protected Integer progress = 0;
    protected String progressString = null;
    protected T results;
    protected Throwable exception;
    protected List<Runnable> postExecuteRunnables = new LinkedList<Runnable>();
    protected List<Runnable> cancelledRunnables = new LinkedList<Runnable>();
    protected List<Runnable> failedRunnables = new LinkedList<Runnable>();

    @Override
    public T getResults() {
        return this.results;
    }

    protected void setResults(T results) {
        this.results = results;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.running = false;
    }

    @Override
    public String getProgressString() {
        return this.progressString;
    }

    @Override
    public Number getProgressValue() {
        return this.progress;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.execute();
        }
        catch (Exception e) {
            this.threwException = true;
            e.printStackTrace();
            this.exception = e;
        }
        catch (Throwable t) {
            this.threwException = true;
            this.exception = t;
            logger.error((Object)"Problem running task:", t);
        }
        if (this.isFailed()) {
            for (Runnable r : this.failedRunnables) {
                if (this.isSwingFriendly) {
                    try {
                        SwingUtilities.invokeAndWait(r);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                r.run();
            }
            this.failed();
        } else if (this.isCancelled()) {
            for (Runnable r : this.cancelledRunnables) {
                if (this.isSwingFriendly) {
                    try {
                        SwingUtilities.invokeAndWait(r);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (InvocationTargetException e) {}
                    continue;
                }
                r.run();
            }
            this.cancelled();
        } else {
            for (Runnable r : this.postExecuteRunnables) {
                if (this.isSwingFriendly) {
                    try {
                        SwingUtilities.invokeAndWait(r);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                r.run();
            }
            this.done();
        }
        this.running = false;
    }

    protected void setProgressValue(Integer progress) {
        this.progress = progress;
    }

    protected void setProgressString(String string) {
        this.progressString = string;
    }

    protected void done() {
    }

    protected void cancelled() {
    }

    public void addPostExecuteRunnable(Runnable r) {
        this.postExecuteRunnables.add(r);
    }

    public void removePostExecuteRunnable(Runnable r) {
        this.postExecuteRunnables.add(r);
    }

    public void addCancelledRunnable(Runnable r) {
        this.cancelledRunnables.add(r);
    }

    public void removeCancelledRunnable(Runnable r) {
        this.cancelledRunnables.remove(r);
    }

    public void addFailedRunnable(Runnable r) {
        this.failedRunnables.add(r);
    }

    public void removeFailedRunnable(Runnable r) {
        this.failedRunnables.remove(r);
    }

    public abstract void execute() throws Exception;

    @Override
    public boolean isFailed() {
        return this.threwException;
    }

    protected void failed() {
    }

    public void setSwingFriendly(boolean swingFriendly) {
        this.isSwingFriendly = swingFriendly;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }
}

