/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.bbop.util.CollectionChanges;
import org.bbop.util.ComparableComparator;
import org.bbop.util.EmptyIterator;
import org.bbop.util.EqualityComparator;
import org.bbop.util.EqualsEqualityComparator;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.bbop.util.ObjectUtil;

public class CollectionUtil {
    protected static final Logger logger = Logger.getLogger(CollectionUtil.class);
    public static final EmptyIterator EMPTY_ITERATOR = EmptyIterator.EMPTY_ITERATOR;
    protected static final ComparableComparator comparableComparator = new ComparableComparator();
    private static final EqualsEqualityComparator equalityComparator = new EqualsEqualityComparator();

    private CollectionUtil() {
    }

    public static <T> T[] array(T ... in) {
        return in;
    }

    public static <K, V> MultiMap<V, K> invertMap(MultiMap<K, V> map) {
        MultiHashMap out = new MultiHashMap();
        for (Object key : map.keySet()) {
            Collection vals = (Collection)map.get(key);
            for (Object val : vals) {
                out.add(val, key);
            }
        }
        return out;
    }

    public static boolean hasSameContents(Collection a, Collection b) {
        return CollectionUtil.hasSameContents(a, b, equalityComparator);
    }

    public static boolean hasSameContents(Collection a, Collection b, EqualityComparator cmp) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator it = a.iterator();
        while (it.hasNext()) {
            if (CollectionUtil.contains(b, it.next(), cmp)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection vector, Object o, EqualityComparator cmp) {
        Iterator it = vector.iterator();
        while (it.hasNext()) {
            if (!cmp.equals(it.next(), o)) continue;
            return true;
        }
        return false;
    }

    public static List createSortedList(Collection v, Comparator c, boolean duplicates) {
        ArrayList out = new ArrayList();
        Iterator it = v.iterator();
        while (it.hasNext()) {
            CollectionUtil.insertSorted(out, c, it.next(), duplicates);
        }
        return out;
    }

    public static boolean insertSorted(List v, Comparator c, Object o, boolean duplicates) {
        int pos = Collections.binarySearch(v, o, c);
        if (duplicates && pos >= 0) {
            if (pos >= v.size()) {
                pos = v.size() - 1;
            }
            if (pos < 0) {
                pos = 0;
            }
            v.add(pos, o);
            return true;
        }
        if (pos < 0) {
            v.add(-pos - 1, o);
            return true;
        }
        return false;
    }

    public static boolean insertSorted(List v, Comparator c, Object o) {
        return CollectionUtil.insertSorted(v, c, o, true);
    }

    public static void insertSorted(List v, Object o) {
        CollectionUtil.insertSorted(v, comparableComparator, o);
    }

    public static void copyIntoSorted(Iterator it, List dest, Comparator comparator) {
        while (it.hasNext()) {
            CollectionUtil.insertSorted(dest, comparator, it.next());
        }
    }

    public static void copyIntoSorted(Collection source, List dest, Comparator comparator) {
        CollectionUtil.copyIntoSorted(source.iterator(), dest, comparator);
    }

    public static void addAll(Collection c, Iterator it) {
        while (it.hasNext()) {
            c.add(it.next());
        }
    }

    public static boolean contains(Iterator it, Object o) {
        while (it.hasNext()) {
            if (!ObjectUtil.equals(o, it.next())) continue;
            return true;
        }
        return false;
    }

    public static Collection initialize(Collection c, Iterator it) {
        c.clear();
        CollectionUtil.addAll(c, it);
        return c;
    }

    public static <T> CollectionChanges<T> getChanges(Collection<T> cold, Collection<T> cnew) {
        final LinkedList<T> added = new LinkedList<T>();
        final LinkedList<T> deleted = new LinkedList<T>();
        for (T oldobj : cold) {
            if (cnew.contains(oldobj)) continue;
            deleted.add(oldobj);
        }
        for (T newobj : cnew) {
            if (cold.contains(newobj)) continue;
            added.add(newobj);
        }
        return new CollectionChanges<T>(){

            @Override
            public Collection<T> getAddedItems() {
                return added;
            }

            @Override
            public Collection<T> getDeletedItems() {
                return deleted;
            }
        };
    }

    public static <T> CollectionChanges<T> getChanges(Collection<T> cold, Collection<T> cnew, EqualityComparator eq) {
        boolean found;
        if (eq == null) {
            eq = equalityComparator;
        }
        final LinkedList<T> added = new LinkedList<T>();
        final LinkedList<T> deleted = new LinkedList<T>();
        for (T oldobj : cold) {
            found = false;
            for (T newobj : cnew) {
                if (!eq.equals(oldobj, newobj)) continue;
                found = true;
                break;
            }
            if (found) continue;
            deleted.add(oldobj);
        }
        for (T newobj : cnew) {
            found = false;
            for (T oldobj : cnew) {
                if (!eq.equals(oldobj, newobj)) continue;
                found = true;
                break;
            }
            if (found) continue;
            added.add(newobj);
        }
        return new CollectionChanges<T>(){

            @Override
            public Collection<T> getAddedItems() {
                return added;
            }

            @Override
            public Collection<T> getDeletedItems() {
                return deleted;
            }
        };
    }

    public static <T> List<T> deepCopy(Collection<T> c) {
        if (c instanceof List) {
            return CollectionUtil.deepCopy((List)c);
        }
        return CollectionUtil.deepCopy(new LinkedList<T>(c));
    }

    public static <T> List<T> deepCopy(List<T> list) {
        return CollectionUtil.deepCopy(list, null);
    }

    public static <T> List<T> deepCopy(List<T> list, List<T> dest) {
        if (dest == null) {
            dest = new ArrayList<T>(list.size());
        } else {
            dest.clear();
        }
        for (T t : list) {
            if (t instanceof List) {
                dest.add(CollectionUtil.deepCopy((List)t, null));
                continue;
            }
            Object newT = ObjectUtil.cloneObject(t);
            if (newT == null) {
                newT = t;
            }
            dest.add(newT);
        }
        return dest;
    }

    public static <T> List<T> createList(Queue<T> queue, List<T> outputList, boolean reverse) {
        if (outputList == null) {
            outputList = new ArrayList<T>(queue.size());
        }
        while (!queue.isEmpty()) {
            outputList.add(queue.poll());
        }
        if (reverse) {
            Collections.reverse(outputList);
        }
        return outputList;
    }

    public static <T> List<T> list(T ... items) {
        ArrayList<T> out = new ArrayList<T>();
        for (T t : items) {
            out.add(t);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Collection<T> createEmpty(Collection<?> in) {
        Class<?> originalClass = in.getClass();
        try {
            Constructor<?> originalConstructor = originalClass.getConstructor(new Class[0]);
            Collection collection = (Collection)originalConstructor.newInstance(new Object[0]);
            return collection;
        }
        catch (IllegalArgumentException e) {}
        catch (InstantiationException e) {}
        catch (IllegalAccessException e) {}
        catch (InvocationTargetException e) {}
        catch (SecurityException e) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        finally {
            return null;
        }
    }

    public static <T> Collection<T> getObjectsOfType(Collection<?> input, Class<T> type) {
        return CollectionUtil.getObjectsOfType(input, type, null);
    }

    public static <T> Collection<T> getObjectsOfType(Collection<?> input, Class<T> type, Collection<T> output) {
        if (output == null && (output = CollectionUtil.createEmpty(input)) == null) {
            output = new ArrayList<T>();
        }
        for (Object o : input) {
            if (!type.isAssignableFrom(o.getClass())) continue;
            output.add(o);
        }
        return output;
    }
}

