/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.bbop.util.AsynchronousListener;

public class EventUtil {
    protected static final Logger logger = Logger.getLogger(EventUtil.class);

    private EventUtil() {
    }

    protected static boolean isObjectMethod(Method m) {
        return m.getDeclaringClass().equals(Object.class);
    }

    public static AsynchronousListener getThreadSafeListener(AsynchronousListener l) {
        return (AsynchronousListener)Proxy.newProxyInstance(l.getClass().getClassLoader(), l.getClass().getInterfaces(), (InvocationHandler)new AWTSafeDelegate(l));
    }

    protected static class AWTSafeDelegate
    implements InvocationHandler {
        protected Object target;

        public AWTSafeDelegate(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            if (SwingUtilities.isEventDispatchThread() || EventUtil.isObjectMethod(method)) {
                return method.invoke(this.target, args);
            }
            ReturnValRunnable r = new ReturnValRunnable(){

                @Override
                public void run() {
                    try {
                        this.setVal(method.invoke(target, args));
                    }
                    catch (Throwable t) {
                        this.setException(t);
                    }
                }
            };
            if (method.getReturnType().equals(Void.TYPE)) {
                SwingUtilities.invokeLater(r);
                return null;
            }
            SwingUtilities.invokeAndWait(r);
            if (r.getException() != null) {
                throw r.getException();
            }
            return r.getVal();
        }
    }

    protected static abstract class ReturnValRunnable
    implements Runnable {
        protected Object val;
        protected Throwable exception;

        protected ReturnValRunnable() {
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setVal(Object val) {
            this.val = val;
        }

        public Object getVal() {
            return this.val;
        }
    }
}

