/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.MapValueFactory;

public class FactoryBackedMap<K, V>
implements Map<K, V> {
    protected static final Logger logger = Logger.getLogger(FactoryBackedMap.class);
    protected Map<K, V> cacheMap;
    protected MapValueFactory<K, V> factory;
    protected Set<K> keySet;

    public FactoryBackedMap(MapValueFactory<K, V> factory, Collection<K> keySet) {
        this(null, factory, keySet);
    }

    public FactoryBackedMap(Map<K, V> cacheMap, MapValueFactory<K, V> factory, Collection<K> keySet) {
        if (cacheMap == null) {
            this.cacheMap = new HashMap();
        } else {
            this.cacheMap = cacheMap;
            this.cacheMap.clear();
        }
        this.factory = factory;
        this.keySet = new HashSet<K>();
        for (K key : keySet) {
            this.keySet.add(key);
        }
    }

    @Override
    public void clear() {
        this.cacheMap.clear();
        this.keySet.clear();
    }

    public boolean containsCachedKey(Object key) {
        return this.cacheMap.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.cacheAllKeys();
        return this.cacheMap.containsValue(value);
    }

    protected void cacheAllKeys() {
        for (K key : this.keySet()) {
            this.get(key);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.cacheAllKeys();
        return this.cacheMap.entrySet();
    }

    @Override
    public V get(Object key) {
        if (this.cacheMap.containsKey(key)) {
            logger.info((Object)("CACHE: returned " + this.cacheMap.get(key) + " from " + key));
            return this.cacheMap.get(key);
        }
        V val = this.factory.createObject(key);
        this.cacheMap.put(key, val);
        if (!this.keySet.contains(key)) {
            this.keySet.add(key);
        }
        logger.info((Object)("FACTORY: returned " + val + " from " + key));
        return val;
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        this.keySet.add(key);
        return this.cacheMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public V remove(Object key) {
        this.keySet.remove(key);
        return this.cacheMap.remove(key);
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public Collection<V> values() {
        this.cacheAllKeys();
        return this.cacheMap.values();
    }
}

