/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.util.VectorFilter;

public class FilteredIterator
implements Iterator {
    protected static final Logger logger = Logger.getLogger(FilteredIterator.class);
    protected boolean outOfGas = true;
    protected Object nextObject;
    protected VectorFilter filter;
    protected Iterator iterator;

    @Override
    public boolean hasNext() {
        return !this.outOfGas;
    }

    public Object next() {
        Object out = this.nextObject;
        this.fetchNextObject();
        return out;
    }

    protected void fetchNextObject() {
        while (this.iterator.hasNext()) {
            Object o = this.iterator.next();
            if (!this.filter.satisfies(o)) continue;
            this.outOfGas = false;
            this.nextObject = o;
            return;
        }
        this.nextObject = null;
        this.outOfGas = true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Filtered iterators are read only");
    }

    public FilteredIterator() {
    }

    public FilteredIterator(VectorFilter filter, Iterator iterator) {
        this.setFilter(filter);
        this.setIterator(iterator);
    }

    public VectorFilter getFilter() {
        return this.filter;
    }

    public void setFilter(VectorFilter filter) {
        this.filter = filter;
        this.outOfGas = true;
        this.nextObject = null;
    }

    public Iterator getIterator() {
        return this.iterator;
    }

    public void setIterator(Iterator iterator) {
        this.iterator = iterator;
        this.fetchNextObject();
    }

    public static void main(String[] args) {
        VectorFilter filter = new VectorFilter(){

            public boolean satisfies(Object o) {
                return o.toString().startsWith("a");
            }
        };
        LinkedList<String> list = new LinkedList<String>();
        list.add("monkeylegs");
        list.add("armenia");
        list.add("aspergers");
        list.add("bolus");
        list.add("wurst");
        FilteredIterator it = new FilteredIterator(filter, list.iterator());
        while (it.hasNext()) {
            logger.debug(it.next());
        }
    }
}

