/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.Subset;
import org.bbop.util.Subsetable;
import org.bbop.util.VectorFilter;

public class HashSubsetable
extends LinkedHashSet
implements Subsetable,
Serializable {
    protected static final Logger logger = Logger.getLogger(HashSubsetable.class);
    private static final long serialVersionUID = -999036291683126314L;
    protected HashSet subsets = new HashSet();

    @Override
    public Set getUncachedSubset(VectorFilter filter) {
        Subset out = new Subset(filter, this, false);
        this.subsets.add(out);
        return out;
    }

    @Override
    public Set getSubset(VectorFilter filter) {
        Subset out = new Subset(filter, this, true);
        this.subsets.add(out);
        return out;
    }

    @Override
    public boolean removeSubset(Set set) {
        return this.subsets.remove(set);
    }

    @Override
    public void clear() {
        super.clear();
        for (Subset set : this.subsets) {
            set.cacheSize(0);
        }
    }

    @Override
    public boolean add(Object o) {
        boolean add = super.add(o);
        if (add) {
            for (Subset set : this.subsets) {
                set.updateAdd(o);
            }
        }
        return add;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        if (remove) {
            for (Subset set : this.subsets) {
                set.updateRemove(o);
            }
        }
        return remove;
    }

    @Override
    public void markForRecategorize(Object o) {
        for (Subset set : this.subsets) {
            set.markForRecategorize(o);
        }
    }

    @Override
    public void recategorize(Object o) {
        for (Subset set : this.subsets) {
            set.recategorize(o);
        }
    }

    public void recache(Set s) {
        if (this.subsets.contains(s)) {
            ((Subset)s).cacheSize();
        }
    }

    @Override
    public void recache() {
        for (Subset set : this.subsets) {
            set.cacheSize();
        }
    }
}

