/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.MapSoftReference;
import org.bbop.util.ReferenceCleanupEvent;
import org.bbop.util.ReferenceCleanupListener;
import org.bbop.util.ReferenceQueueCleanupThread;
import org.bbop.util.TinySet;

public class ReferenceMap<K, V>
implements Map<K, V> {
    protected static final Logger logger = Logger.getLogger(ReferenceMap.class);
    public Map<K, MapSoftReference<K, V>> backingMap;
    protected ReferenceQueue<MapSoftReference.SoftPointer<V>> referenceQueue = new ReferenceQueue();
    protected ReferenceQueueCleanupThread cleanupThread;
    protected Collection<ReferenceCleanupListener> cleanupListeners = new LinkedList<ReferenceCleanupListener>();

    public ReferenceMap() {
        this(new HashMap());
    }

    public ReferenceMap(Map<K, MapSoftReference<K, V>> backingMap) {
        this.backingMap = Collections.synchronizedMap(backingMap);
    }

    public void startCleanupThread() {
        if (this.cleanupThread != null && this.cleanupThread.isAlive()) {
            this.cleanupThread.halt();
        }
        this.cleanupThread = new ReferenceQueueCleanupThread<MapSoftReference.SoftPointer<V>>(this.referenceQueue);
        this.cleanupThread.addCleanupListener(new ReferenceCleanupListener(){

            public void cleanup(ReferenceCleanupEvent event) {
                MapSoftReference ref = (MapSoftReference)event.getReference();
                ReferenceMap.this.doCleanup(ref);
            }
        });
        this.cleanupThread.start();
    }

    protected synchronized void doCleanup(MapSoftReference ref) {
        this.fireCleanup(ref);
        this.backingMap.remove(ref.getKey());
        ref.reallyClear();
        logger.info((Object)("backingMap size = " + this.backingMap.size()));
    }

    public void stopCleanupThread() {
        if (this.cleanupThread != null) {
            this.cleanupThread.halt();
        }
    }

    public void addCleanupListener(ReferenceCleanupListener listener) {
        this.cleanupListeners.add(listener);
    }

    public void removeCleanupListener(ReferenceCleanupListener<V> listener) {
        this.cleanupListeners.remove(listener);
    }

    protected void fireCleanup(Reference<Object> ref) {
        ReferenceCleanupEvent<Object> event = new ReferenceCleanupEvent<Object>(this.referenceQueue, ref);
        for (ReferenceCleanupListener listener : this.cleanupListeners) {
            listener.cleanup(event);
        }
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values()) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        TinySet<Map.Entry<K, V>> out = new TinySet<Map.Entry<K, V>>();
        for (final Map.Entry<K, MapSoftReference<K, V>> entry : this.backingMap.entrySet()) {
            final V value = entry.getValue().getValue();
            if (value == null) continue;
            out.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V v) {
                    MapSoftReference ref = ReferenceMap.this.createReference(entry.getKey(), v, false);
                    entry.setValue(ref);
                    return value;
                }
            });
        }
        return out;
    }

    @Override
    public V get(Object key) {
        MapSoftReference<K, V> r = this.backingMap.get(key);
        if (r != null) {
            return r.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    public V put(K key, V value, boolean isDirty) {
        MapSoftReference<K, V> r = this.backingMap.put(key, this.createReference(key, value, isDirty));
        if (r != null) {
            return r.getValue();
        }
        return null;
    }

    protected MapSoftReference<K, V> createReference(K key, V value, boolean isDirty) {
        return new MapSoftReference<K, V>(key, value, isDirty, this.referenceQueue);
    }

    public synchronized void markDirty(K key, boolean isDirty) {
        MapSoftReference<K, V> r = this.backingMap.get(key);
        r.setDirty(isDirty);
    }

    public boolean isDirty(K key) {
        MapSoftReference<K, V> r = this.backingMap.get(key);
        return r.isDirty();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        MapSoftReference<K, V> r = this.backingMap.remove(key);
        if (r != null) {
            return r.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public Collection<V> values() {
        LinkedList<V> out = new LinkedList<V>();
        for (MapSoftReference<K, V> r : this.backingMap.values()) {
            V value = r.getValue();
            if (value == null) continue;
            out.add(value);
        }
        return out;
    }
}

