/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.util.CycleState;

public class StateCycler {
    protected static final Logger logger = Logger.getLogger(StateCycler.class);
    protected List states = new LinkedList();
    protected int currentIndex = 0;
    protected boolean tryEveryState = false;
    protected String desc;

    public StateCycler() {
    }

    public StateCycler(String desc) {
        this.setDesc(desc);
    }

    public void addState(CycleState state) {
        this.states.add(state);
    }

    public void addState(CycleState state, int index) {
        this.states.add(index, state);
    }

    public void removeState(CycleState state) {
        this.states.remove(state);
    }

    public CycleState getCurrentState() {
        if (this.states.size() == 0) {
            return null;
        }
        return (CycleState)this.states.get(this.currentIndex);
    }

    public void enforceCurrentState() {
        CycleState currentState = this.getCurrentState();
        if (currentState != null) {
            currentState.apply();
        }
    }

    public void setCurrentState(CycleState state) {
        int index = this.states.indexOf(state);
        if (index >= 0) {
            this.currentIndex = index;
            this.enforceCurrentState();
        }
    }

    public void cycleStates() {
        int updates = 0;
        CycleState currentState = this.getCurrentState();
        if (!currentState.isActive()) {
            this.enforceCurrentState();
            return;
        }
        do {
            this.currentIndex = (this.currentIndex + 1) % this.states.size();
            ++updates;
            currentState = this.getCurrentState();
            if (!this.tryEveryState && !currentState.alwaysActivate() && currentState.isActive()) continue;
            this.enforceCurrentState();
            return;
        } while (updates < this.states.size());
    }

    public boolean getTryEveryState() {
        return this.tryEveryState;
    }

    public void setTryEveryState(boolean tryEveryState) {
        this.tryEveryState = tryEveryState;
    }

    public List getStates() {
        return this.states;
    }

    public void setStates(List states) {
        this.states = states;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

