/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.bbop.util.FilteredIterator;
import org.bbop.util.VectorFilter;

public class Subset<T>
extends AbstractSet<T>
implements Serializable {
    protected static final Logger logger = Logger.getLogger(Subset.class);
    private static final long serialVersionUID = 8179875474046027783L;
    protected VectorFilter<T> filter;
    protected int size = -1;
    protected boolean containedMarked = false;
    protected Collection<T> set;
    protected boolean cacheSize;

    public Subset() {
        this(null, null, false);
    }

    public Subset(VectorFilter<T> filter, Collection<T> set) {
        this(filter, set, false);
    }

    public Subset(VectorFilter<T> filter, Collection<T> set, boolean cacheSize) {
        this.filter = filter;
        this.set = set;
        this.cacheSize = cacheSize;
        if (cacheSize) {
            this.cacheSize();
        }
    }

    @Override
    public Iterator iterator() {
        if (this.cacheSize) {
            return new CachedSubsetIterator();
        }
        return new FilteredIterator(this.filter, this.set.iterator());
    }

    @Override
    public boolean remove(Object o) {
        if (this.filter.satisfies(o)) {
            return this.set.remove(o);
        }
        return false;
    }

    protected void markForRecategorize(Object o) {
        this.containedMarked = this.contains(o);
    }

    protected void recategorize(Object o) {
        if (this.contains(o)) {
            if (!this.containedMarked) {
                ++this.size;
            }
        } else if (this.containedMarked) {
            --this.size;
        }
    }

    @Override
    public boolean isEmpty() {
        Iterator<T> it = this.set.iterator();
        while (it.hasNext()) {
            if (!this.filter.satisfies(it.next())) continue;
            return false;
        }
        return true;
    }

    public void setFilter(VectorFilter<T> filter) {
        this.filter = filter;
    }

    public void setData(Collection<T> set) {
        this.set = set;
    }

    @Override
    public boolean add(T o) {
        if (this.filter.satisfies(o)) {
            return this.set.add(o);
        }
        return false;
    }

    protected void updateRemove(T o) {
        if (this.filter.satisfies(o)) {
            --this.size;
        }
    }

    protected void updateAdd(T o) {
        if (this.filter.satisfies(o)) {
            ++this.size;
        }
    }

    protected void cacheSize() {
        this.cacheSize(0);
        Iterator<T> it = this.set.iterator();
        while (it.hasNext()) {
            if (!this.filter.satisfies(it.next())) continue;
            ++this.size;
        }
    }

    protected void cacheSize(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        if (!this.cacheSize) {
            this.cacheSize();
        }
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.filter.satisfies(o) && this.set.contains(o);
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    protected class CachedSubsetIterator
    implements Iterator<T> {
        int index = 0;
        Iterator<T> internal;
        T lastObject;

        protected CachedSubsetIterator() {
            this.internal = Subset.this.set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.index < Subset.this.size;
        }

        @Override
        public T next() {
            do {
                this.lastObject = this.internal.next();
            } while (!Subset.this.filter.satisfies(this.lastObject));
            ++this.index;
            return this.lastObject;
        }

        @Override
        public void remove() {
            if (Subset.this.filter.satisfies(this.lastObject)) {
                this.internal.remove();
            }
        }
    }
}

