/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.util;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.util.IteratorFactory;
import org.bbop.util.SuperIterator;

public class SuperCollection<IN, OUT>
extends AbstractCollection<OUT> {
    protected static final Logger logger = Logger.getLogger(SuperCollection.class);
    protected IN root;
    protected List<IteratorFactory> factories;

    public SuperCollection(IN root, IteratorFactory ... factories) {
        this.root = root;
        this.factories = new LinkedList<IteratorFactory>();
        for (IteratorFactory factory : factories) {
            this.factories.add(factory);
        }
    }

    public SuperCollection(IN root, List<IteratorFactory> factories) {
        this.factories = factories;
        this.root = root;
    }

    @Override
    public Iterator<OUT> iterator() {
        return new SuperIterator(this.root, this.factories);
    }

    @Override
    public int size() {
        int i = 0;
        Iterator<OUT> it = this.iterator();
        while (it.hasNext()) {
            ++i;
            it.next();
        }
        return i;
    }
}

