/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.BranchAddDependency;
import org.mindswap.pellet.BranchDependency;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.ClashDependency;
import org.mindswap.pellet.DependencyEntry;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.DisjunctionBranch;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.KnowledgeBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyIndex {
    public static final Log log = LogFactory.getLog(DependencyIndex.class);
    private Map<ATermAppl, DependencyEntry> dependencies;
    private Map<Branch, Set<BranchDependency>> branchIndex;
    private Set<ClashDependency> clashIndex;
    private KnowledgeBase kb;

    public DependencyIndex(KnowledgeBase kb) {
        this.dependencies = new HashMap<ATermAppl, DependencyEntry>();
        this.branchIndex = new HashMap<Branch, Set<BranchDependency>>();
        this.clashIndex = new HashSet<ClashDependency>();
        this.kb = kb;
    }

    public DependencyIndex(KnowledgeBase kb, DependencyIndex oldIndex) {
        this.kb = kb;
        this.dependencies = new HashMap<ATermAppl, DependencyEntry>();
        for (ATermAppl next : oldIndex.getDependencies().keySet()) {
            DependencyEntry entry = oldIndex.getDependencies(next).copy();
            this.dependencies.put(next, entry);
        }
    }

    protected DependencyEntry getDependencies(ATermAppl assertion) {
        return this.dependencies.get(assertion);
    }

    protected Map<ATermAppl, DependencyEntry> getDependencies() {
        return this.dependencies;
    }

    protected void addTypeDependency(ATermAppl ind, ATermAppl type, DependencySet ds) {
        for (ATermAppl nextAtom : ds.explain) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            this.dependencies.get(nextAtom).addTypeDependency(ind, type);
        }
    }

    protected void addMergeDependency(ATermAppl ind, ATermAppl mergedTo, DependencySet ds) {
        for (ATermAppl nextAtom : ds.explain) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            this.dependencies.get(nextAtom).addMergeDependency(ind, mergedTo);
        }
    }

    protected void addEdgeDependency(Edge edge, DependencySet ds) {
        for (ATermAppl nextAtom : ds.explain) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            this.dependencies.get(nextAtom).addEdgeDependency(edge);
        }
    }

    protected void addBranchAddDependency(Branch branch) {
        for (ATermAppl nextAtom : branch.termDepends.explain) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("DependencyIndex- Adding branch add dependency for assertion: " + nextAtom + " -  Branch id [" + branch.branch + "]   ,  Branch [" + branch + "]"));
            }
            BranchDependency newDep = this.dependencies.get(nextAtom).addBranchAddDependency(nextAtom, branch.branch, branch);
            if (!this.branchIndex.containsKey(branch)) {
                HashSet<BranchDependency> newS = new HashSet<BranchDependency>();
                newS.add(newDep);
                this.branchIndex.put(branch, newS);
                continue;
            }
            this.branchIndex.get(branch).add(newDep);
        }
    }

    protected void addCloseBranchDependency(Branch branch, DependencySet ds) {
        for (ATermAppl nextAtom : ds.explain) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            ATermAppl label = null;
            if (branch instanceof DisjunctionBranch) {
                label = ((DisjunctionBranch)branch).disj[((DisjunctionBranch)branch).tryNext];
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("DependencyIndex- Adding branch remove ds dependency for assertion: " + nextAtom + " -  Branch id [" + branch.branch + "]   ,  Branch [" + branch + "]   on label [" + label + "]  ,    tryNext [" + branch.tryNext + "]"));
            }
            BranchDependency newDep = this.dependencies.get(nextAtom).addCloseBranchDependency(nextAtom, branch);
            if (!this.branchIndex.containsKey(branch)) {
                HashSet<BranchDependency> newS = new HashSet<BranchDependency>();
                newS.add(newDep);
                this.branchIndex.put(branch, newS);
                continue;
            }
            this.branchIndex.get(branch).add(newDep);
        }
    }

    protected void removeDependencies(ATermAppl assertion) {
        this.dependencies.remove(assertion);
    }

    protected void removeBranchDependencies(Branch b) {
        Set<BranchDependency> deps = this.branchIndex.get(b);
        if (deps == null) {
            return;
        }
        for (BranchDependency next : deps) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("DependencyIndex: RESTORE causing remove of branch index for assertion: " + next.getAssertion() + " branch dep.: " + next));
            }
            if (!(next instanceof BranchAddDependency)) continue;
            this.dependencies.get(next.getAssertion()).getBranchAdds().remove(next);
        }
    }

    protected void setClashDependencies(Clash clash) {
        for (ClashDependency next : this.clashIndex) {
            if (this.dependencies.get(next.getAssertion()) == null) continue;
            this.dependencies.get(next.getAssertion()).setClash(null);
        }
        this.clashIndex.clear();
        if (clash == null) {
            return;
        }
        for (ATermAppl nextAtom : clash.depends.explain) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  DependencyIndex- Adding clash dependency: Axiom [" + nextAtom + "]   ,  Clash [" + clash + "]"));
            }
            ClashDependency newDep = new ClashDependency(nextAtom, clash);
            this.dependencies.get(nextAtom).setClash(newDep);
            this.clashIndex.add(newDep);
        }
    }
}

