/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.CachedNode;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.SHOIQStrategy;
import org.mindswap.pellet.SubsetBlocking;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.Timer;

public class EmptySHNStrategy
extends SHOIQStrategy {
    private LinkedList mayNeedExpanding;
    private Individual root;
    private Map cachedNodes;
    public static final int NONE = 0;
    public static final int HIT = 1;
    public static final int MISS = 2;
    public static final int FAIL = 4;
    public static final int ADD = 8;
    public static final int ALL = 15;
    public static int SHOW_CACHE_INFO = 0;

    public EmptySHNStrategy(ABox abox) {
        super(abox);
        this.blocking = new SubsetBlocking();
    }

    boolean supportsPseudoModelCompletion() {
        return false;
    }

    public void initialize() {
        this.mergeList = new ArrayList();
        this.cachedNodes = new HashMap();
        this.root = (Individual)this.abox.getNodes().iterator().next();
        this.root.setChanged(true);
        this.applyUniversalRestrictions(this.root);
        this.abox.setBranch(1);
        this.abox.treeDepth = 1;
        this.abox.changed = true;
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    ABox complete() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"************  EmptySHNStrategy  ************");
        }
        if (this.abox.getNodes().isEmpty()) {
            this.abox.setComplete(true);
            return this.abox;
        }
        if (this.abox.getNodes().size() > 1) {
            throw new RuntimeException("EmptySHNStrategy can only be used with an ABox that has a single individual.");
        }
        this.initialize();
        this.mayNeedExpanding = new LinkedList();
        this.mayNeedExpanding.add(this.root);
        while (!this.abox.isComplete() && !this.abox.isClosed()) {
            Individual x = this.getNextIndividual();
            if (x == null) {
                this.abox.setComplete(true);
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting with node " + x));
                this.abox.printTree();
                this.abox.validate();
            }
            this.expand(x);
            if (!this.abox.isClosed()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash()));
            }
            if (this.backtrack()) {
                this.abox.setClash(null);
                continue;
            }
            this.abox.setComplete(true);
        }
        if (log.isDebugEnabled()) {
            this.abox.printTree();
        }
        if (PelletOptions.USE_ADVANCED_CACHING && !this.abox.isClosed()) {
            IndividualIterator i = this.abox.getIndIterator();
            while (i.hasNext()) {
                Individual ind = (Individual)i.next();
                ATermAppl c = (ATermAppl)this.cachedNodes.get(ind);
                if (c == null || !this.abox.cache.putSat(c, true)) continue;
                if ((SHOW_CACHE_INFO & 8) != 0) {
                    System.out.println("+++ Cache sat concept " + c);
                }
                if (!ATermUtils.isAnd(c)) continue;
                ATermList list = (ATermList)c.getArgument(0);
                while (!list.isEmpty()) {
                    ATermAppl d = (ATermAppl)list.getFirst();
                    if (this.abox.cache.putSat(d, true) && (SHOW_CACHE_INFO & 8) != 0) {
                        System.out.println("+++ Cache sat concept " + d);
                    }
                    list = list.getNext();
                }
            }
        }
        return this.abox;
    }

    private Individual getNextIndividual() {
        Node next = null;
        while (!this.mayNeedExpanding.isEmpty() && (next = (Node)this.mayNeedExpanding.get(0)) instanceof Literal) {
            next = null;
            this.mayNeedExpanding.remove(0);
        }
        return (Individual)next;
    }

    private void expand(Individual x) {
        if (this.blocking.isBlocked(x)) {
            this.mayNeedExpanding.remove(0);
            return;
        }
        if (PelletOptions.USE_ADVANCED_CACHING) {
            Timer t = this.abox.getKB().timers.startTimer("cache");
            Bool cachedSat = this.cachedSat(x);
            t.stop();
            if (cachedSat.isKnown()) {
                if (cachedSat.isTrue()) {
                    this.mayNeedExpanding.remove(0);
                } else {
                    DependencySet ds = DependencySet.EMPTY;
                    for (ATermAppl c : x.getTypes()) {
                        ds = ds.union(x.getDepends(c), this.abox.doExplanation());
                    }
                    this.abox.setClash(Clash.atomic(x, ds));
                }
                return;
            }
        }
        do {
            this.applyUnfoldingRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.applyDisjunctionRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            if (x.canApply(0) || x.canApply(1)) continue;
            this.applySomeValuesRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.applyMinRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            if (x.canApply(0) || x.canApply(1)) continue;
            this.applyChooseRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.applyMaxRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        } while (x.canApply(0) || x.canApply(1) || x.canApply(2) || x.canApply(4));
        this.mayNeedExpanding.remove(0);
        int insert = PelletOptions.SEARCH_TYPE ? 0 : this.mayNeedExpanding.size();
        this.mayNeedExpanding.addAll(insert, x.getSortedSuccessors());
    }

    private ATermAppl createConcept(Individual x) {
        HashSet types = new HashSet(x.getTypes());
        types.remove(ATermUtils.TOP);
        types.remove(ATermUtils.makeValue(x.getName()));
        if (types.isEmpty()) {
            return ATermUtils.TOP;
        }
        int count = 0;
        ATerm[] terms = new ATerm[types.size()];
        for (ATermAppl c : types) {
            if (ATermUtils.isAnd(c)) continue;
            terms[count++] = c;
        }
        return ATermUtils.makeAnd(ATermUtils.toSet(terms, count));
    }

    private Bool cachedSat(Individual x) {
        ATermList concepts;
        if (x.equals(this.root)) {
            return Bool.UNKNOWN;
        }
        ATermAppl c = this.createConcept(x);
        if (this.cachedNodes.containsValue(c)) {
            if ((SHOW_CACHE_INFO & 1) != 0) {
                System.out.println("already searching for " + c);
            }
            return Bool.TRUE;
        }
        Bool sat = this.abox.getCachedSat(c);
        if (sat.isUnknown() && ATermUtils.isAnd(c) && (concepts = (ATermList)c.getArgument(0)).getLength() == 2) {
            ATermAppl c1 = (ATermAppl)concepts.getFirst();
            ATermAppl c2 = (ATermAppl)concepts.getLast();
            CachedNode cached1 = this.abox.getCached(c1);
            CachedNode cached2 = this.abox.getCached(c2);
            if (cached1 != null && cached1.isComplete() && cached2 != null && cached2.isComplete() && (sat = this.abox.mergable(cached1.node, cached2.node, cached1.depends.isIndependent() && cached2.depends.isIndependent())).isKnown()) {
                this.abox.cache.putSat(c, sat.isTrue());
            }
        }
        if (sat.isUnknown()) {
            if ((SHOW_CACHE_INFO & 2) != 0) {
                System.out.println("??? Cache miss for " + c);
            }
            this.cachedNodes.put(x, c);
        } else if ((SHOW_CACHE_INFO & 1) != 0) {
            System.out.println("*** Cache hit for " + c + " sat = " + sat);
        }
        return sat;
    }

    public void restore(Branch br) {
        Node clashNode = this.abox.getClash().node;
        List clashPath = clashNode.getPath();
        clashPath.add(clashNode.getName());
        this.abox.setBranch(br.branch);
        this.abox.setClash(null);
        this.abox.anonCount = br.anonCount;
        this.mergeList.clear();
        List nodeList = this.abox.getNodeNames();
        Map nodes = this.abox.getNodeMap();
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESTORE: Branch " + br.branch));
            if (br.nodeCount < nodeList.size()) {
                log.debug((Object)("Remove nodes " + nodeList.subList(br.nodeCount, nodeList.size())));
            }
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ATerm x = (ATerm)nodeList.get(i);
            Node node = this.abox.getNode(x);
            if (i >= br.nodeCount) {
                nodes.remove(x);
                ATermAppl c = (ATermAppl)this.cachedNodes.remove(node);
                if (c == null || !PelletOptions.USE_ADVANCED_CACHING) continue;
                if (clashPath.contains(x)) {
                    if ((SHOW_CACHE_INFO & 8) != 0) {
                        System.out.println("+++ Cache unsat concept " + c);
                    }
                    this.abox.cache.putSat(c, false);
                    continue;
                }
                if ((SHOW_CACHE_INFO & 8) == 0) continue;
                System.out.println("--- Do not cache concept " + c + " " + x + " " + clashNode + " " + clashPath);
                continue;
            }
            node.restore(br.branch);
            if (!node.equals(clashNode)) continue;
            this.cachedNodes.remove(node);
        }
        nodeList.subList(br.nodeCount, nodeList.size()).clear();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.applyAllValues(ind);
        }
        if (log.isDebugEnabled()) {
            this.abox.printTree();
        }
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            int lastBranch = this.abox.getClash().depends.max();
            if (lastBranch <= 0) {
                return false;
            }
            List branches = this.abox.getBranches();
            Branch newBranch = null;
            if (lastBranch <= branches.size()) {
                branches.subList(lastBranch, branches.size()).clear();
                newBranch = (Branch)branches.get(lastBranch - 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JUMP: " + lastBranch));
                }
                if (newBranch == null || lastBranch != newBranch.branch) {
                    throw new RuntimeException("Internal error in reasoner: Trying to backtrack branch " + lastBranch + " but got " + newBranch);
                }
                if (newBranch.tryNext < newBranch.tryCount) {
                    newBranch.setLastClash(this.abox.getClash().depends);
                }
                ++newBranch.tryNext;
                if (newBranch.tryNext < newBranch.tryCount) {
                    this.restore(newBranch);
                    branchFound = newBranch.tryNext();
                }
            }
            if (!branchFound) {
                this.abox.getClash().depends.remove(lastBranch);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("FAIL: " + lastBranch));
                continue;
            }
            this.mayNeedExpanding = new LinkedList((List)newBranch.get("mnx"));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("MNX : " + this.mayNeedExpanding));
        }
        this.abox.validate();
        return branchFound;
    }

    void addBranch(Branch newBranch) {
        super.addBranch(newBranch);
        newBranch.put("mnx", new ArrayList(this.mayNeedExpanding));
    }
}

