/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;

class LiteralIterator
implements Iterator {
    protected Map nodes;
    protected List nodeList;
    protected int index;
    protected int start;
    protected int stop;

    public LiteralIterator(ABox abox) {
        this(abox, true);
    }

    protected LiteralIterator(ABox abox, boolean findNext) {
        this.nodes = abox.getNodeMap();
        this.nodeList = abox.getNodeNames();
        this.start = 0;
        this.stop = this.nodeList.size();
        this.index = this.start;
        if (findNext) {
            this.findNext();
        }
    }

    public LiteralIterator(ABox abox, int start, int stop) {
        this.nodes = abox.getNodeMap();
        this.nodeList = abox.getNodeNames();
        this.start = start;
        this.stop = Math.max(stop, this.nodeList.size());
        this.index = start;
        this.findNext();
    }

    public int getIndex() {
        return this.index;
    }

    protected void findNext() {
        Node node;
        while (this.index < this.stop && ((node = (Node)this.nodes.get(this.nodeList.get(this.index))).isPruned() || !(node instanceof Literal))) {
            ++this.index;
        }
    }

    public boolean hasNext() {
        this.findNext();
        return this.index < this.stop;
    }

    public void reset() {
        this.index = this.start;
        this.findNext();
    }

    public void jump(int i) {
        this.index = i;
    }

    public Object next() {
        this.findNext();
        Literal lit = (Literal)this.nodes.get(this.nodeList.get(this.index++));
        return lit;
    }

    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }
}

