/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RoleTaxonomyBuilder;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RBox {
    public static Log log = LogFactory.getLog(RBox.class);
    private Map<ATermAppl, Role> roles = new HashMap<ATermAppl, Role>();
    private Set<Role> reflexiveRoles = new HashSet<Role>();
    private Taxonomy taxonomy;
    boolean consistent = true;

    public Role getRole(ATerm r) {
        return this.roles.get(r);
    }

    public Role getDefinedRole(ATerm r) {
        Role role = this.roles.get(r);
        if (role == null) {
            throw new RuntimeException(r + " is not defined as a property");
        }
        return role;
    }

    public boolean isConsistent() {
        return this.consistent;
    }

    public Role addRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 0);
            this.roles.put(r, role);
        }
        return role;
    }

    public Role addObjectRole(ATermAppl r) {
        Role role = this.getRole(r);
        int roleType = role == null ? 0 : role.getType();
        switch (roleType) {
            case 2: {
                role = null;
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (role == null) {
                    role = new Role(r, 1);
                    this.roles.put(r, role);
                } else {
                    role.setType(1);
                }
                ATermAppl invR = ATermUtils.makeInv(r);
                Role invRole = new Role(invR, 1);
                this.roles.put(invR, invRole);
                role.setInverse(invRole);
                invRole.setInverse(role);
            }
        }
        return role;
    }

    public Role addDatatypeRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 2);
            this.roles.put(r, role);
        } else {
            switch (role.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(2);
                }
            }
        }
        return role;
    }

    public Role addAnnotationRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 3);
            this.roles.put(r, role);
        } else if (role.getType() == 0) {
            role.setType(3);
        } else if (role.getType() != 3) {
            role = null;
        }
        return role;
    }

    public Role addOntologyRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 4);
            this.roles.put(r, role);
        } else if (role.getType() == 0) {
            role.setType(4);
        } else if (role.getType() != 4) {
            role = null;
        }
        return role;
    }

    public boolean addSubRole(ATerm sub, ATerm sup) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(sub, sup)) : DependencySet.INDEPENDENT;
        return this.addSubRole(sub, sup, ds);
    }

    public boolean addSubRole(ATerm sub, ATerm sup, DependencySet ds) {
        Role roleSup = this.getRole(sup);
        Role roleSub = this.getRole(sub);
        if (roleSup == null) {
            return false;
        }
        if (sub.getType() == 4) {
            roleSup.addSubRoleChain((ATermList)sub, ds);
        } else {
            if (roleSub == null) {
                return false;
            }
            roleSup.addSubRole(roleSub, ds);
            roleSub.addSuperRole(roleSup, ds);
        }
        return true;
    }

    public boolean addSameRole(ATerm s, ATerm r) {
        return this.addEquivalentRole(s, r);
    }

    public boolean addEquivalentRole(ATerm s, ATerm r) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeEqProp(r, s)) : DependencySet.INDEPENDENT;
        return this.addEquivalentRole(r, s, ds);
    }

    public boolean addEquivalentRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addSubRole(roleS, ds);
        roleR.addSuperRole(roleS, ds);
        roleS.addSubRole(roleR, ds);
        roleS.addSuperRole(roleR, ds);
        if (roleR.getInverse() != null) {
            roleR.getInverse().addSubRole(roleS.getInverse(), ds);
            roleR.getInverse().addSuperRole(roleS.getInverse(), ds);
            roleS.getInverse().addSubRole(roleR.getInverse(), ds);
            roleS.getInverse().addSuperRole(roleR.getInverse(), ds);
        }
        return true;
    }

    public boolean addDisjointRole(ATerm s, ATerm r) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addDisjointRole(roleS);
        roleS.addDisjointRole(roleR);
        return true;
    }

    public boolean addInverseRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null || !roleS.isObjectRole() || !roleR.isObjectRole()) {
            return false;
        }
        this.addEquivalentRole(roleS.getInverse().getName(), r, ds);
        return true;
    }

    public boolean isRole(ATerm r) {
        return this.roles.containsKey(r);
    }

    public void prepare() {
        boolean hasComplexSubRoles = false;
        for (Role role : this.roles.values()) {
            if (role.getType() != 1 && role.getType() != 2) continue;
            HashMap subExplain = new HashMap();
            HashSet subRoles = new HashSet();
            HashSet subRoleChains = new HashSet();
            hasComplexSubRoles |= role.hasComplexSubRole();
            this.computeSubRoles(role, subRoles, subRoleChains, subExplain, DependencySet.INDEPENDENT);
            role.setSubRolesAndChains(subRoles, subRoleChains, subExplain);
        }
        for (Role role : this.roles.values()) {
            Role invR = role.getInverse();
            if (invR != null) {
                Set ranges;
                DependencySet ds = PelletOptions.USE_TRACING ? role.getExplainInverse() : DependencySet.INDEPENDENT;
                Set domains = invR.getDomains();
                if (domains != null) {
                    if (PelletOptions.USE_TRACING) {
                        for (ATermAppl domain : domains) {
                            if (role.getExplainRange(domain) != null) continue;
                            role.addRange(domain, ds.union(invR.getExplainDomain(domain), true));
                        }
                    } else {
                        role.addRanges(domains);
                    }
                }
                if ((ranges = invR.getRanges()) != null) {
                    if (PelletOptions.USE_TRACING) {
                        for (ATermAppl range : ranges) {
                            if (role.getExplainDomain(range) != null) continue;
                            role.addDomain(range, ds.union(invR.getExplainRange(range), true));
                        }
                    } else {
                        role.addDomains(ranges);
                    }
                }
                if (invR.isTransitive() && !role.isTransitive()) {
                    role.setTransitive(true, invR.getExplainTransitive().union(ds, true));
                } else if (role.isTransitive() && !invR.isTransitive()) {
                    invR.setTransitive(true, role.getExplainTransitive().union(ds, true));
                }
                if (invR.isFunctional() && !role.isInverseFunctional()) {
                    role.setInverseFunctional(true, invR.getExplainFunctional().union(ds, true));
                }
                if (role.isFunctional() && !invR.isInverseFunctional()) {
                    invR.setInverseFunctional(true, role.getExplainFunctional().union(ds, true));
                }
                if (invR.isInverseFunctional() && !role.isFunctional()) {
                    role.setFunctional(true, invR.getExplainInverseFunctional().union(ds, true));
                }
                if (invR.isAntisymmetric() && !role.isAntisymmetric()) {
                    role.setAntisymmetric(true, invR.getExplainAntisymmetric().union(ds, true));
                }
                if (role.isAntisymmetric() && !invR.isAntisymmetric()) {
                    invR.setAntisymmetric(true, role.getExplainAntisymmetric().union(ds, true));
                }
                if (invR.isReflexive() && !role.isReflexive()) {
                    role.setReflexive(true, invR.getExplainReflexive().union(ds, true));
                }
                if (role.isReflexive() && !invR.isReflexive()) {
                    invR.setReflexive(true, role.getExplainReflexive().union(ds, true));
                }
                if (invR.hasComplexSubRole()) {
                    role.setHasComplexSubRole(true);
                }
                if (role.hasComplexSubRole()) {
                    invR.setHasComplexSubRole(true);
                }
            }
            Set domains = role.getDomains();
            Set ranges = role.getRanges();
            for (Role s : role.getSubRoles()) {
                s.addSuperRole(role, role.getExplainSub(s.getName()));
                if (role.isForceSimple()) {
                    s.setForceSimple(true);
                }
                if (!s.isSimple()) {
                    role.setSimple(false);
                }
                if (s.hasComplexSubRole()) {
                    role.setHasComplexSubRole(true);
                }
                if (domains != null) {
                    if (PelletOptions.USE_TRACING) {
                        for (ATermAppl domain : new HashSet(domains)) {
                            if (s.getExplainRange(domain) != null) continue;
                            s.addDomain(domain, role.getExplainSub(s.getName()).union(role.getExplainDomain(domain), true));
                        }
                    } else {
                        s.addDomains(domains);
                    }
                }
                if (ranges == null) continue;
                if (PelletOptions.USE_TRACING) {
                    for (ATermAppl range : new HashSet(ranges)) {
                        if (s.getExplainRange(range) != null) continue;
                        s.addRange(range, role.getExplainSub(s.getName()).union(role.getExplainRange(range), true));
                    }
                    continue;
                }
                s.addRanges(ranges);
            }
        }
        for (Role r : this.roles.values()) {
            r.normalize();
            if (r.isForceSimple()) {
                if (!r.isSimple()) {
                    this.ignoreTransitivity(r);
                }
            } else {
                boolean isTransitive = r.isTransitive();
                DependencySet transitiveDS = r.getExplainTransitive();
                for (Role s : r.getSubRoles()) {
                    if (!s.isTransitive()) continue;
                    if (r.isSubRoleOf(s) && r != s) {
                        isTransitive = true;
                        transitiveDS = r.getExplainSub(s.getName()).union(s.getExplainTransitive(), true);
                    }
                    r.addTransitiveSubRole(s);
                }
                if (isTransitive != r.isTransitive()) {
                    r.setTransitive(isTransitive, transitiveDS);
                }
                if (hasComplexSubRoles && !r.isSimple()) {
                    this.buildDFA(r);
                }
            }
            for (Role s : r.getSuperRoles()) {
                DependencySet ds;
                if (s.isFunctional()) {
                    ds = PelletOptions.USE_TRACING ? r.getExplainSuper(s.getName()).union(s.getExplainFunctional(), true) : DependencySet.INDEPENDENT;
                    r.setFunctional(true, ds);
                    r.addFunctionalSuper(s);
                }
                if (!s.isIrreflexive() || r.isIrreflexive()) continue;
                ds = PelletOptions.USE_TRACING ? r.getExplainSuper(s.getName()).union(s.getExplainIrreflexive(), true) : DependencySet.INDEPENDENT;
                r.setIrreflexive(true, ds);
            }
            if (r.isReflexive() && !r.isAnon()) {
                this.reflexiveRoles.add(r);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)r.debugString());
        }
        this.taxonomy = null;
    }

    private void ignoreTransitivity(Role role) {
        Role namedRole = role.isAnon() ? role.getInverse() : role;
        String msg = "Unsupported axiom: Ignoring transitivity and/or complex subproperty axioms for " + namedRole;
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(msg);
        }
        log.warn((Object)msg);
        role.removeSubRoleChains();
        role.getInverse().removeSubRoleChains();
        role.setSimple(true);
    }

    private void computeImmediateSubRoles(Role r, Set subs, Map dependencies) {
        DependencySet subDS;
        Role invR = r.getInverse();
        if (invR != null && invR != r) {
            DependencySet ds = PelletOptions.USE_TRACING ? r.getExplainInverse() : DependencySet.INDEPENDENT;
            for (Role invSubR : invR.getSubRoles()) {
                Role subR = invSubR.getInverse();
                if (subR == null) {
                    System.err.println("Property " + invSubR + " was supposed to be an ObjectProperty but it is not!");
                    continue;
                }
                if (subR == r) continue;
                DependencySet subDS2 = PelletOptions.USE_TRACING ? ds.union(invR.getExplainSub(invSubR.getName()).union(invSubR.getExplainInverse(), true), true) : DependencySet.INDEPENDENT;
                subs.add(subR);
                dependencies.put(subR.getName(), subDS2);
            }
            for (ATermList roleChain : invR.getSubRoleChains()) {
                DependencySet subDS3 = PelletOptions.USE_TRACING ? ds.union(invR.getExplainSub(roleChain), true) : DependencySet.INDEPENDENT;
                ATermList subChain = this.inverse(roleChain);
                subs.add(subChain);
                dependencies.put(subChain, subDS3);
            }
        }
        for (Role sub : r.getSubRoles()) {
            subDS = PelletOptions.USE_TRACING ? r.getExplainSub(sub.getName()) : DependencySet.INDEPENDENT;
            subs.add(sub);
            dependencies.put(sub.getName(), subDS);
        }
        for (ATermList subChain : r.getSubRoleChains()) {
            subDS = PelletOptions.USE_TRACING ? r.getExplainSub(subChain) : DependencySet.INDEPENDENT;
            subs.add(subChain);
            dependencies.put(subChain, subDS);
        }
    }

    private void computeSubRoles(Role r, Set subRoles, Set subRoleChains, Map dependencies, DependencySet ds) {
        if (subRoles.contains(r)) {
            return;
        }
        subRoles.add(r);
        dependencies.put(r.getName(), ds);
        HashSet immSubs = new HashSet();
        HashMap immDeps = new HashMap();
        this.computeImmediateSubRoles(r, immSubs, immDeps);
        for (Object sub : immSubs) {
            if (sub instanceof Role) {
                ATermAppl name = ((Role)sub).getName();
                DependencySet subDS = PelletOptions.USE_TRACING ? ds.union((DependencySet)immDeps.get(name), true) : DependencySet.INDEPENDENT;
                this.computeSubRoles((Role)sub, subRoles, subRoleChains, dependencies, subDS);
                continue;
            }
            DependencySet subDS = PelletOptions.USE_TRACING ? ds.union((DependencySet)immDeps.get(sub), true) : DependencySet.INDEPENDENT;
            subRoleChains.add(sub);
            dependencies.put(sub, subDS);
        }
    }

    private TransitionGraph buildDFA(Role s) {
        TransitionGraph tg = s.getFSM();
        if (tg != null) {
            return tg;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building NFA for " + s));
        }
        tg = this.buildNFA(s);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Determinize " + s + ": " + tg.size()));
        }
        tg.determinize();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Minimize NFA for " + s + ": " + tg.size()));
        }
        tg.minimize();
        tg.renumber();
        s.setFSM(tg);
        Set eqRoles = SetUtils.intersection(s.getSubRoles(), s.getSuperRoles());
        eqRoles.remove(s);
        for (Role eqRole : eqRoles) {
            eqRole.setFSM(tg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("NFA for " + tg));
        }
        return tg;
    }

    private TransitionGraph buildNFA(Role s) {
        TransitionGraph tg = new TransitionGraph();
        State i = tg.newState();
        State f = tg.newState();
        tg.setInitialState(i);
        tg.addFinalState(f);
        tg.addTransition(i, s, f);
        Set subRoles = SetUtils.difference(s.getSubRoles(), s.getSuperRoles());
        for (Role sub : subRoles) {
            tg.addTransition(i, sub, f);
        }
        for (ATermList subChain : s.getSubRoleChains()) {
            this.addTransition(tg, s, subChain);
        }
        HashSet alphabet = new HashSet(tg.getAlpahabet());
        alphabet.remove(s);
        for (Role r : alphabet) {
            this.addTransitions(tg, r);
        }
        return tg;
    }

    private void addTransition(TransitionGraph tg, Role s, ATermList chain) {
        State first = tg.getInitialState();
        State last = tg.getFinalState();
        if (ATermUtils.isTransitiveChain(chain, s.getName())) {
            tg.addTransition(last, first);
            return;
        }
        if (((Object)chain.getFirst()).equals(s.getName())) {
            chain = chain.getNext();
            first = tg.getFinalState();
        } else if (((Object)chain.getLast()).equals(s.getName())) {
            chain = chain.remove(s.getName());
            last = tg.getInitialState();
        }
        State next = tg.newState();
        tg.addTransition(first, next);
        first = next;
        while (!chain.isEmpty()) {
            next = tg.newState();
            tg.addTransition(first, this.getRole(chain.getFirst()), next);
            first = next;
            chain = chain.getNext();
        }
        tg.addTransition(first, last);
    }

    private void addTransitions(TransitionGraph tg, Role r) {
        List<Pair<State, State>> pairs = tg.findTransitions(r);
        Iterator<Pair<State, State>> i = pairs.iterator();
        while (i.hasNext()) {
            TransitionGraph newGraph = this.buildDFA(r).copy();
            Pair<State, State> pair = i.next();
            tg.insert(newGraph, (State)pair.first, (State)pair.second);
        }
    }

    public String toString() {
        return "[RBox " + this.roles.values() + "]";
    }

    public ATermList inverse(ATermList roles) {
        ATermList invList = ATermUtils.EMPTY_LIST;
        ATermList list = roles;
        while (!list.isEmpty()) {
            ATermAppl r = (ATermAppl)list.getFirst();
            Role role = this.getRole(r);
            Role invR = role.getInverse();
            if (invR == null) {
                System.err.println("Property " + r + " was supposed to be an ObjectProperty but it is not!");
            } else {
                invList = invList.insert(invR.getName());
            }
            list = list.getNext();
        }
        return invList;
    }

    public Set getRoleNames() {
        return this.roles.keySet();
    }

    public Set<Role> getReflexiveRoles() {
        return this.reflexiveRoles;
    }

    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    public Taxonomy getTaxonomy() {
        if (this.taxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this);
            this.taxonomy = builder.classify();
        }
        return this.taxonomy;
    }
}

