/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role {
    public static final String[] TYPES = new String[]{"Untyped", "Object", "Datatype", "Annotation", "Ontology"};
    public static final int UNDEFINED = 0;
    public static final int UNTYPED = 0;
    public static final int OBJECT = 1;
    public static final int DATATYPE = 2;
    public static final int ANNOTATION = 3;
    public static final int ONTOLOGY = 4;
    private ATermAppl name;
    private int type = 0;
    private Role inverse = null;
    private Set<Role> subRoles = Collections.emptySet();
    private Set<Role> superRoles = Collections.emptySet();
    private Set<Role> disjointRoles = Collections.emptySet();
    private Set subRoleChains = Collections.emptySet();
    private Set functionalSupers = Collections.emptySet();
    private Set transitiveSubRoles = Collections.emptySet();
    private ATermAppl domain = null;
    private ATermAppl range = null;
    private Set domains = null;
    private Set ranges = null;
    private TransitionGraph tg;
    public static int TRANSITIVE = 1;
    public static int FUNCTIONAL = 2;
    public static int INV_FUNCTIONAL = 4;
    public static int REFLEXIVE = 8;
    public static int IRREFLEXIVE = 16;
    public static int ANTI_SYM = 32;
    public static int SIMPLE = 64;
    public static int COMPLEX_SUB = 128;
    public static int FORCE_SIMPLE = 256;
    private int flags = SIMPLE;
    private DependencySet explainAntisymmetric = DependencySet.INDEPENDENT;
    private DependencySet explainDomain = DependencySet.INDEPENDENT;
    private DependencySet explainRange = DependencySet.INDEPENDENT;
    private DependencySet explainFunctional = DependencySet.INDEPENDENT;
    private DependencySet explainIrreflexive = DependencySet.INDEPENDENT;
    private DependencySet explainReflexive = DependencySet.INDEPENDENT;
    private DependencySet explainSymmetric = DependencySet.INDEPENDENT;
    private DependencySet explainTransitive = DependencySet.INDEPENDENT;
    private DependencySet explainInverseFunctional = DependencySet.INDEPENDENT;
    private DependencySet explainInverse = DependencySet.INDEPENDENT;
    private Map explainSub = new HashMap();
    private Map explainSup = new HashMap();
    private Map explainDomains = null;
    private Map explainRanges = null;

    public Role(ATermAppl name) {
        this(name, 0);
    }

    public Role(ATermAppl name, int type) {
        this.name = name;
        this.type = type;
        this.addSubRole(this, DependencySet.INDEPENDENT);
        this.addSuperRole(this, DependencySet.INDEPENDENT);
    }

    public boolean equals(Object o) {
        if (o instanceof Role) {
            return this.name == ((Role)o).getName();
        }
        return false;
    }

    public String toString() {
        return this.name.getArity() == 0 ? this.name.getName() : this.name.toString();
    }

    public String debugString() {
        String str = "(" + TYPES[this.type] + "Role " + this.name;
        if (this.isTransitive()) {
            str = str + " Transitive";
        }
        if (this.isReflexive()) {
            str = str + " Reflexive";
        }
        if (this.isIrreflexive()) {
            str = str + " Irreflexive";
        }
        if (this.isSymmetric()) {
            str = str + " Symmetric";
        }
        if (this.isAntisymmetric()) {
            str = str + " Antisymmetric";
        }
        if (this.isFunctional()) {
            str = str + " Functional";
        }
        if (this.isInverseFunctional()) {
            str = str + " InverseFunctional";
        }
        if (this.hasComplexSubRole()) {
            str = str + " ComplexSubRole";
        }
        if (this.isSimple()) {
            str = str + " Simple";
        }
        if (this.type == 1 || this.type == 2) {
            if (this.domain != null) {
                str = str + " domain=" + this.domain;
            }
            if (this.range != null) {
                str = str + " range=" + this.range;
            }
            str = str + " superPropertyOf=" + this.subRoles;
            str = str + " subPropertyOf=" + this.superRoles;
            str = str + " hasSubPropertyChain=" + this.subRoleChains;
            str = str + " disjointWith=" + this.disjointRoles;
        }
        str = str + ")";
        return str;
    }

    public void addSubRoleChain(ATermList chain) {
        this.addSubRoleChain(chain, DependencySet.INDEPENDENT);
    }

    public void addSubRoleChain(ATermList chain, DependencySet ds) {
        if (chain.isEmpty()) {
            throw new InternalReasonerException("Adding a subproperty chain that is empty!");
        }
        if (chain.getLength() == 1) {
            throw new InternalReasonerException("Adding a subproperty chain that has a single element!");
        }
        this.subRoleChains = SetUtils.add(chain, this.subRoleChains);
        this.explainSub.put(chain, ds);
        this.setSimple(false);
        boolean transitiveChain = ATermUtils.isTransitiveChain(chain, this.name);
        if (transitiveChain) {
            if (!this.isTransitive()) {
                this.setTransitive(true, ds);
            }
        } else {
            this.setHasComplexSubRole(true);
        }
    }

    public void removeSubRoleChain(ATermList chain) {
        this.subRoleChains = SetUtils.remove(chain, this.subRoleChains);
        this.explainSub.remove(chain);
        if (this.isTransitive() && ATermUtils.isTransitiveChain(chain, this.name)) {
            this.setTransitive(false, null);
        }
    }

    public void removeSubRoleChains() {
        this.subRoleChains = Collections.emptySet();
        if (this.isTransitive()) {
            this.setTransitive(false, null);
        }
    }

    public void addSubRole(Role r) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(r.getName(), this.getName())) : DependencySet.INDEPENDENT;
        this.addSubRole(r, ds);
    }

    public void addSubRole(Role r, DependencySet ds) {
        if (PelletOptions.USE_TRACING && this.explainSub.get(r.getName()) == null) {
            this.explainSub.put(r.getName(), ds);
        }
        this.subRoles = SetUtils.add(r, this.subRoles);
        this.explainSub.put(r.getName(), ds);
    }

    public void removeSubRole(Role r) {
        this.subRoles = SetUtils.remove(r, this.subRoles);
    }

    public void addSuperRole(Role r) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(this.name, r.getName())) : DependencySet.INDEPENDENT;
        this.addSuperRole(r, ds);
    }

    public void addSuperRole(Role r, DependencySet ds) {
        this.superRoles = SetUtils.add(r, this.superRoles);
        this.explainSup.put(r.getName(), ds);
    }

    public void addDisjointRole(Role r) {
        this.disjointRoles = SetUtils.add(r, this.disjointRoles);
    }

    void normalize() {
        if (this.domains != null) {
            if (this.domains.size() == 1) {
                this.domain = (ATermAppl)this.domains.iterator().next();
                this.explainDomain = PelletOptions.USE_TRACING ? this.getExplainDomain(this.domain) : DependencySet.INDEPENDENT;
            } else {
                this.domain = ATermUtils.makeSimplifiedAnd(this.domains);
                this.explainDomain = DependencySet.INDEPENDENT;
                if (PelletOptions.USE_TRACING) {
                    for (ATermAppl d : this.domains) {
                        if (!PelletOptions.USE_TRACING) continue;
                        this.explainDomain = this.explainDomain.union(this.getExplainDomain(d), true);
                    }
                }
            }
        }
        if (this.ranges != null) {
            if (this.ranges.size() == 1) {
                this.range = (ATermAppl)this.ranges.iterator().next();
                this.explainRange = PelletOptions.USE_TRACING ? this.getExplainRange(this.range) : DependencySet.INDEPENDENT;
            } else {
                this.range = ATermUtils.makeSimplifiedAnd(this.ranges);
                this.explainRange = DependencySet.INDEPENDENT;
                if (PelletOptions.USE_TRACING) {
                    for (ATermAppl r : this.ranges) {
                        if (!PelletOptions.USE_TRACING) continue;
                        this.explainRange = this.explainRange.union(this.getExplainRange(r), true);
                    }
                }
            }
        }
    }

    public void addDomain(ATermAppl a) {
        this.addDomain(a, DependencySet.INDEPENDENT);
    }

    public void addDomain(ATermAppl a, DependencySet ds) {
        if (this.domains == null) {
            this.domains = new HashSet();
        }
        if (this.explainDomains == null) {
            this.explainDomains = new HashMap();
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        this.domains.add(normalized);
        this.explainDomains.put(normalized, ds);
    }

    public void addRange(ATermAppl a) {
        this.addRange(a, DependencySet.INDEPENDENT);
    }

    public void addRange(ATermAppl a, DependencySet ds) {
        if (this.ranges == null) {
            this.ranges = new HashSet();
        }
        if (this.explainRanges == null) {
            this.explainRanges = new HashMap();
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        this.ranges.add(normalized);
        this.explainRanges.put(normalized, ds);
    }

    public void addDomains(Set a) {
        if (this.domains == null) {
            this.domains = new HashSet();
        }
        if (this.explainDomains == null) {
            this.explainDomains = new HashMap();
        }
        this.domains.addAll(a);
    }

    public void addRanges(Set a) {
        if (this.ranges == null) {
            this.ranges = new HashSet();
        }
        if (this.explainRanges == null) {
            this.explainRanges = new HashMap();
        }
        this.ranges.addAll(a);
    }

    public boolean isObjectRole() {
        return this.type == 1;
    }

    public boolean isDatatypeRole() {
        return this.type == 2;
    }

    public boolean isOntologyRole() {
        return this.type == 4;
    }

    public boolean isAnnotationRole() {
        return this.type == 3;
    }

    public boolean isUntypedRole() {
        return this.type == 0;
    }

    public Role getInverse() {
        return this.inverse;
    }

    public boolean hasNamedInverse() {
        return this.inverse != null && !this.inverse.isAnon();
    }

    public boolean hasComplexSubRole() {
        return (this.flags & COMPLEX_SUB) != 0;
    }

    public boolean isFunctional() {
        return (this.flags & FUNCTIONAL) != 0;
    }

    public boolean isInverseFunctional() {
        return (this.flags & INV_FUNCTIONAL) != 0;
    }

    public boolean isSymmetric() {
        return this.inverse != null && this.inverse.equals(this);
    }

    public boolean isAntisymmetric() {
        return (this.flags & ANTI_SYM) != 0;
    }

    public boolean isTransitive() {
        return (this.flags & TRANSITIVE) != 0;
    }

    public boolean isReflexive() {
        return (this.flags & REFLEXIVE) != 0;
    }

    public boolean isIrreflexive() {
        return (this.flags & IRREFLEXIVE) != 0;
    }

    public boolean isAnon() {
        return this.name.getArity() != 0;
    }

    public ATermAppl getName() {
        return this.name;
    }

    public ATermAppl getDomain() {
        return this.domain;
    }

    public ATermAppl getRange() {
        return this.range;
    }

    public Set getDomains() {
        return this.domains;
    }

    public Set getRanges() {
        return this.ranges;
    }

    public Set<Role> getSubRoles() {
        return Collections.unmodifiableSet(this.subRoles);
    }

    public Set getSubRoleChains() {
        return this.subRoleChains;
    }

    public Set<Role> getSuperRoles() {
        return Collections.unmodifiableSet(this.superRoles);
    }

    public Set<Role> getDisjointRoles() {
        return Collections.unmodifiableSet(this.disjointRoles);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return TYPES[this.type];
    }

    public boolean isSubRoleOf(Role r) {
        return this.superRoles.contains(r);
    }

    public boolean isSuperRoleOf(Role r) {
        return this.subRoles.contains(r);
    }

    public void setInverse(Role term) {
        this.setInverse(term, DependencySet.INDEPENDENT);
    }

    public void setInverse(Role term, DependencySet ds) {
        this.inverse = term;
        this.explainInverse = ds;
    }

    public void setFunctional(boolean b) {
        DependencySet ds = DependencySet.INDEPENDENT;
        this.setFunctional(b, ds);
    }

    public void setFunctional(boolean b, DependencySet ds) {
        if (b) {
            this.flags |= FUNCTIONAL;
            this.explainFunctional = ds;
        } else {
            this.flags &= ~FUNCTIONAL;
            this.explainFunctional = DependencySet.INDEPENDENT;
        }
    }

    public void setInverseFunctional(boolean b) {
        this.setInverseFunctional(b, DependencySet.INDEPENDENT);
    }

    public void setInverseFunctional(boolean b, DependencySet ds) {
        if (b) {
            this.flags |= INV_FUNCTIONAL;
            this.explainInverseFunctional = ds;
        } else {
            this.flags &= ~INV_FUNCTIONAL;
            this.explainInverseFunctional = DependencySet.INDEPENDENT;
        }
    }

    public void setTransitive(boolean b) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTransitive(this.name)) : DependencySet.INDEPENDENT;
        this.setTransitive(b, ds);
    }

    public void setTransitive(boolean b, DependencySet ds) {
        ATermList roleChain = ATermUtils.makeList(new ATerm[]{this.name, this.name});
        if (b) {
            this.flags |= TRANSITIVE;
            this.explainTransitive = ds;
            this.addSubRoleChain(roleChain, ds);
        } else {
            this.flags &= ~TRANSITIVE;
            this.explainTransitive = ds;
            this.removeSubRoleChain(roleChain);
        }
    }

    public void setReflexive(boolean b) {
        this.setReflexive(b, DependencySet.INDEPENDENT);
    }

    public void setReflexive(boolean b, DependencySet ds) {
        this.flags = b ? (this.flags |= REFLEXIVE) : (this.flags &= ~REFLEXIVE);
        this.explainReflexive = ds;
    }

    public void setIrreflexive(boolean b) {
        this.setIrreflexive(b, DependencySet.INDEPENDENT);
    }

    public void setIrreflexive(boolean b, DependencySet ds) {
        this.flags = b ? (this.flags |= IRREFLEXIVE) : (this.flags &= ~IRREFLEXIVE);
        this.explainIrreflexive = ds;
    }

    public void setAntisymmetric(boolean b) {
        this.setAntisymmetric(b, DependencySet.INDEPENDENT);
    }

    public void setAntisymmetric(boolean b, DependencySet ds) {
        this.flags = b ? (this.flags |= ANTI_SYM) : (this.flags &= ~ANTI_SYM);
        this.explainAntisymmetric = ds;
    }

    public void setHasComplexSubRole(boolean b) {
        if (b == this.hasComplexSubRole()) {
            return;
        }
        this.flags = b ? (this.flags |= COMPLEX_SUB) : (this.flags &= ~COMPLEX_SUB);
        if (this.inverse != null) {
            this.inverse.setHasComplexSubRole(b);
        }
        if (b) {
            this.setSimple(false);
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setSubRolesAndChains(Set subRoles, Set subRoleChains, Map dependencies) {
        this.subRoles = subRoles;
        this.subRoleChains = subRoleChains;
        this.explainSub = dependencies;
    }

    public void setSubRoleChains(Set subRoleChains) {
        this.subRoleChains = subRoleChains;
    }

    public void setSubRoles(Set subRoles) {
        this.subRoles = subRoles;
    }

    public void setSuperRoles(Set superRoles) {
        this.superRoles = superRoles;
    }

    public Set getFunctionalSupers() {
        return this.functionalSupers;
    }

    public void addFunctionalSuper(Role r) {
        for (Role fs : this.functionalSupers) {
            if (fs.isSubRoleOf(r)) {
                this.functionalSupers = SetUtils.remove(fs, this.functionalSupers);
                break;
            }
            if (!r.isSubRoleOf(fs)) continue;
            return;
        }
        this.functionalSupers = SetUtils.add(r, this.functionalSupers);
    }

    public void setForceSimple(boolean b) {
        if (b == this.isForceSimple()) {
            return;
        }
        this.flags = b ? (this.flags |= FORCE_SIMPLE) : (this.flags &= ~FORCE_SIMPLE);
        if (this.inverse != null) {
            this.inverse.setForceSimple(b);
        }
    }

    public boolean isForceSimple() {
        return (this.flags & FORCE_SIMPLE) != 0;
    }

    public boolean isSimple() {
        return (this.flags & SIMPLE) != 0;
    }

    void setSimple(boolean b) {
        if (b == this.isSimple()) {
            return;
        }
        this.flags = b ? (this.flags |= SIMPLE) : (this.flags &= ~SIMPLE);
        if (this.inverse != null) {
            this.inverse.setSimple(b);
        }
    }

    public Set getTransitiveSubRoles() {
        return this.transitiveSubRoles;
    }

    public void addTransitiveSubRole(Role r) {
        this.setSimple(false);
        if (this.transitiveSubRoles.isEmpty()) {
            this.transitiveSubRoles = SetUtils.singleton(r);
        } else if (this.transitiveSubRoles.size() == 1) {
            Role tsr = (Role)this.transitiveSubRoles.iterator().next();
            if (tsr.isSubRoleOf(r)) {
                this.transitiveSubRoles = SetUtils.singleton(r);
            } else if (!r.isSubRoleOf(tsr)) {
                this.transitiveSubRoles = new HashSet(2);
                this.transitiveSubRoles.add(tsr);
                this.transitiveSubRoles.add(r);
            }
        } else {
            for (Role tsr : this.transitiveSubRoles) {
                if (tsr.isSubRoleOf(r)) {
                    this.transitiveSubRoles.remove(tsr);
                    this.transitiveSubRoles.add(r);
                    return;
                }
                if (!r.isSubRoleOf(tsr)) continue;
                return;
            }
            this.transitiveSubRoles.add(r);
        }
    }

    protected Role copy(Map conversion) {
        Role newr;
        if (conversion.containsKey(this)) {
            newr = (Role)conversion.get(this);
        } else {
            newr = new Role(this.name);
            conversion.put(this, newr);
        }
        newr.type = this.type;
        newr.domains = this.domains != null ? (Set)((HashSet)this.domains).clone() : null;
        newr.ranges = this.ranges != null ? (Set)((HashSet)this.ranges).clone() : null;
        newr.domain = this.domain;
        newr.range = this.range;
        newr.flags = this.flags;
        if (this.inverse != null) {
            if (!conversion.containsKey(this.inverse)) {
                conversion.put(this.inverse, new Role(this.inverse.name));
            }
            newr.inverse = (Role)conversion.get(this.inverse);
        } else {
            newr.inverse = null;
        }
        newr.subRoles = this.roleSetCopy(this.subRoles, conversion);
        newr.superRoles = this.roleSetCopy(this.superRoles, conversion);
        newr.disjointRoles = this.roleSetCopy(this.disjointRoles, conversion);
        newr.functionalSupers = this.roleSetCopy(this.functionalSupers, conversion);
        newr.explainAntisymmetric = this.explainAntisymmetric;
        newr.explainDomain = this.explainDomain;
        newr.explainDomains = this.explainDomains == null ? null : new HashMap(this.explainDomains);
        newr.explainFunctional = this.explainFunctional;
        newr.explainInverse = this.explainInverse;
        newr.explainInverseFunctional = this.explainInverseFunctional;
        newr.explainIrreflexive = this.explainIrreflexive;
        newr.explainRange = this.explainRange;
        newr.explainRanges = this.explainRanges == null ? null : new HashMap(this.explainRanges);
        newr.explainReflexive = this.explainReflexive;
        newr.explainSub = new HashMap(this.explainSub);
        newr.explainSup = new HashMap(this.explainSup);
        newr.explainSymmetric = this.explainSymmetric;
        newr.explainTransitive = this.explainTransitive;
        return newr;
    }

    private Set roleSetCopy(Set roleset, Map conversion) {
        if (roleset == null) {
            return null;
        }
        HashSet newroles = new HashSet();
        for (Role role : roleset) {
            if (!conversion.containsKey(role)) {
                conversion.put(role, new Role(role.name));
            }
            newroles.add(conversion.get(role));
        }
        return newroles;
    }

    public void setFSM(TransitionGraph tg) {
        this.tg = tg;
    }

    public TransitionGraph getFSM() {
        return this.tg;
    }

    public DependencySet getExplainAntisymmetric() {
        return this.explainAntisymmetric;
    }

    public DependencySet getExplainDomain() {
        return this.explainDomain;
    }

    public DependencySet getExplainDomain(ATermAppl a) {
        DependencySet ds = null;
        if (this.explainDomains != null) {
            ds = (DependencySet)this.explainDomains.get(a);
        }
        return ds;
    }

    public DependencySet getExplainFunctional() {
        return this.explainFunctional;
    }

    public DependencySet getExplainInverse() {
        return this.explainInverse;
    }

    public DependencySet getExplainInverseFunctional() {
        return this.explainInverseFunctional;
    }

    public DependencySet getExplainIrreflexive() {
        return this.explainIrreflexive;
    }

    public DependencySet getExplainRange() {
        return this.explainRange;
    }

    public DependencySet getExplainRange(ATermAppl a) {
        DependencySet ds = null;
        if (this.explainRanges != null) {
            ds = (DependencySet)this.explainRanges.get(a);
        }
        return ds;
    }

    public DependencySet getExplainReflexive() {
        return this.explainReflexive;
    }

    public DependencySet getExplainSub(ATerm r) {
        DependencySet ds = (DependencySet)this.explainSub.get(r);
        if (ds == null) {
            return DependencySet.INDEPENDENT;
        }
        return ds;
    }

    public DependencySet getExplainSuper(ATerm r) {
        DependencySet ds = (DependencySet)this.explainSup.get(r);
        if (ds == null) {
            return DependencySet.INDEPENDENT;
        }
        return ds;
    }

    public DependencySet getExplainSymmetric() {
        return this.explainSymmetric;
    }

    public DependencySet getExplainTransitive() {
        return this.explainTransitive;
    }
}

