/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RuleBranch;
import org.mindswap.pellet.SHOIQStrategy;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Interpreter;
import org.mindswap.pellet.rete.Rule;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.Triple;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.URIUtils;
import org.semanticweb.owl.model.OWLException;

public class RuleStrategy
extends SHOIQStrategy {
    int total = 0;
    public static QNameProvider qnames = new QNameProvider();

    public RuleStrategy(ABox abox) {
        super(abox);
    }

    public List getVars(Rule rule) throws OWLException {
        HashSet vars = new HashSet();
        for (Triple triple : rule.body) {
            List tripleVars = triple.getVars();
            vars.addAll(tripleVars);
        }
        return new ArrayList(vars);
    }

    public void applyRULERule() {
        HashMap bindings = new HashMap();
        for (Rule rule : this.abox.getKB().getRules()) {
            try {
                List vars = this.getVars(rule);
                this.total = 0;
                this.findBinding(0, bindings, vars, rule);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("total bindings:" + this.total));
                log.debug((Object)("branches:" + this.abox.getBranch()));
            }
            catch (OWLException e) {
                e.printStackTrace();
            }
        }
    }

    private void findBinding(int current, HashMap bindings, List vars, Rule rule) throws OWLException {
        Individual ind = null;
        if (current < vars.size()) {
            IndividualIterator i = this.abox.getIndIterator();
            while (i.hasNext()) {
                ind = (Individual)i.next();
                if (!ind.isNamedIndividual()) continue;
                bindings.put(vars.get(current), ind);
                if (this.triviallySatisfiedAllBindings(bindings, rule)) {
                    bindings.remove(vars.get(current));
                    continue;
                }
                this.findBinding(current + 1, bindings, vars, rule);
                bindings.remove(vars.get(current));
            }
        } else {
            ++this.total;
            if (log.isDebugEnabled()) {
                for (Object k : bindings.keySet()) {
                    log.debug((Object)("key:" + k + " value:" + bindings.get(k) + "-"));
                }
                log.debug((Object)("total:" + this.total));
            }
            if (!this.abox.isClosed()) {
                this.createDisjunctionsFromBinding(bindings, rule);
            }
        }
    }

    private boolean triviallySatisfiedAllBindings(HashMap bindings, Rule rule) throws OWLException {
        List inds;
        Triple head = (Triple)rule.head.iterator().next();
        Term pred = head.getPred();
        if (pred.equals(Constant.TYPE)) {
            ATermAppl c = this.term(head.getObj().toString());
            Individual ind = this.getIndividual(head.getSubj(), bindings);
            if (ind != null && ind.hasType(c)) {
                return true;
            }
        } else if (pred.equals(Constant.SAME_AS)) {
            inds = this.getIndividuals(head, bindings);
            if (inds.size() == 2) {
                ATermAppl sam = ATermUtils.makeValue(((Individual)inds.get(1)).getTerm());
                if (((Individual)inds.get(0)).hasType(sam)) {
                    return true;
                }
            }
        } else if (pred.equals(Constant.DIFF_FROM)) {
            inds = this.getIndividuals(head, bindings);
            if (inds.size() == 2) {
                ATermAppl dif = ATermUtils.makeNot(ATermUtils.makeValue(((Individual)inds.get(1)).getTerm()));
                if (((Individual)inds.get(0)).hasType(dif)) {
                    return true;
                }
            }
        } else {
            inds = this.getIndividuals(head, bindings);
            if (inds.size() == 2) {
                ATermAppl p = this.term(head.getPred().toString());
                ATermAppl notO = ATermUtils.negate(ATermUtils.makeValue(((Individual)inds.get(1)).getTerm()));
                ATermAppl notAllPnotO = ATermUtils.negate(ATermUtils.makeAllValues(p, notO));
                if (((Individual)inds.get(0)).hasType(notAllPnotO)) {
                    return true;
                }
            }
        }
        for (Triple atom : rule.body) {
            List inds2;
            pred = atom.getPred();
            if (pred.equals(Constant.TYPE)) {
                Individual ind = this.getIndividual(atom.getSubj(), bindings);
                ATermAppl c = this.term(atom.getObj().toString());
                ATermAppl notC = ATermUtils.negate(c);
                if (ind == null || !ind.hasType(notC)) continue;
                return true;
            }
            if (pred.equals(Constant.SAME_AS)) {
                inds2 = this.getIndividuals(atom, bindings);
                if (inds2.size() != 2) continue;
                ATermAppl dif = ATermUtils.makeNot(ATermUtils.makeValue(((Individual)inds2.get(1)).getTerm()));
                if (!((Individual)inds2.get(0)).hasType(dif)) continue;
                return true;
            }
            if (pred.equals(Constant.DIFF_FROM)) {
                inds2 = this.getIndividuals(atom, bindings);
                if (inds2.size() != 2) continue;
                ATermAppl sam = ATermUtils.makeValue(((Individual)inds2.get(1)).getTerm());
                if (!((Individual)inds2.get(0)).hasType(sam)) continue;
                return true;
            }
            inds2 = this.getIndividuals(atom, bindings);
            if (inds2.size() != 2) continue;
            ATermAppl p = this.term(pred.toString());
            ATermAppl notO = ATermUtils.negate(ATermUtils.makeValue(((Individual)inds2.get(1)).getTerm()));
            ATermAppl allPNotO = ATermUtils.makeAllValues(p, notO);
            if (!((Individual)inds2.get(0)).hasType(allPNotO)) continue;
            return true;
        }
        return false;
    }

    private Individual getIndividual(Term term, Map bindings) {
        Individual ind = term instanceof Variable ? (Individual)bindings.get(term) : this.abox.getIndividual(this.term(((Constant)term).getValue()));
        return ind;
    }

    private void addIndividual(Term term, Map bindings, List inds) {
        Individual ind = this.getIndividual(term, bindings);
        if (ind != null) {
            inds.add(ind);
        }
    }

    private List getIndividuals(Triple triple, Map bindings) {
        ArrayList inds = new ArrayList();
        this.addIndividual(triple.getSubj(), bindings, inds);
        if (!triple.getPred().equals(Constant.TYPE)) {
            this.addIndividual(triple.getObj(), bindings, inds);
        }
        return inds;
    }

    private void createDisjunctionsFromBinding(Map bindings, Rule rule) throws OWLException {
        Individual s2;
        Individual s1;
        ATermAppl disjunction = null;
        ATerm[] disj = new ATermAppl[rule.body.size() + 1];
        ATermAppl[] inds = new ATermAppl[rule.body.size() + 1];
        int index = 0;
        Triple head = (Triple)rule.head.iterator().next();
        Term pred = head.getPred();
        if (pred.equals(Constant.TYPE)) {
            ATermAppl c = this.term(head.getObj().toString());
            Individual ind = this.getIndividual(head.getSubj(), bindings);
            disj[index] = c;
            inds[index] = ind.getName();
            ++index;
            disjunction = disjunction == null ? c : ATermUtils.makeOr(disjunction, c);
        } else if (pred.equals(Constant.SAME_AS)) {
            ATermAppl sam;
            List eqInds = this.getIndividuals(head, bindings);
            s1 = (Individual)eqInds.get(0);
            s2 = (Individual)eqInds.get(1);
            disj[index] = sam = ATermUtils.makeValue(s2.getTerm());
            inds[index] = s1.getName();
            ++index;
            disjunction = disjunction == null ? sam : ATermUtils.makeOr(disjunction, sam);
        } else if (pred.equals(Constant.DIFF_FROM)) {
            ATermAppl dif;
            List ineqInds = this.getIndividuals(head, bindings);
            s1 = (Individual)ineqInds.get(0);
            s2 = (Individual)ineqInds.get(1);
            disj[index] = dif = ATermUtils.makeNot(ATermUtils.makeValue(s2.getTerm()));
            inds[index] = s1.getName();
            ++index;
            disjunction = disjunction == null ? dif : ATermUtils.makeOr(disjunction, dif);
        } else {
            List propertyInds = this.getIndividuals(head, bindings);
            Individual s = (Individual)propertyInds.get(0);
            Individual o = (Individual)propertyInds.get(1);
            ATermAppl p = this.term(pred.toString());
            ATermAppl notO = ATermUtils.negate(ATermUtils.makeValue(o.getTerm()));
            ATermAppl notAllPnotO = ATermUtils.negate(ATermUtils.makeAllValues(p, notO));
            disj[index] = notAllPnotO;
            inds[index] = s.getName();
            ++index;
            disjunction = disjunction == null ? notAllPnotO : ATermUtils.makeOr(disjunction, notAllPnotO);
        }
        for (Triple atom : rule.body) {
            Individual s22;
            Individual s12;
            pred = atom.getPred();
            if (pred.equals(Constant.TYPE)) {
                ATermAppl c = this.term(atom.getObj().toString());
                ATermAppl notC = ATermUtils.negate(c);
                Individual ind = this.getIndividual(atom.getSubj(), bindings);
                disj[index] = notC;
                inds[index++] = ind.getName();
                if (disjunction == null) {
                    disjunction = notC;
                    continue;
                }
                disjunction = ATermUtils.makeOr(disjunction, notC);
                continue;
            }
            if (pred.equals(Constant.SAME_AS)) {
                List eqInds = this.getIndividuals(atom, bindings);
                s12 = (Individual)eqInds.get(0);
                s22 = (Individual)eqInds.get(1);
                ATermAppl dif = ATermUtils.makeNot(ATermUtils.makeValue(s22.getTerm()));
                disj[index] = dif;
                inds[index] = s12.getName();
                ++index;
                if (disjunction == null) {
                    disjunction = dif;
                    continue;
                }
                disjunction = ATermUtils.makeOr(disjunction, dif);
                continue;
            }
            if (pred.equals(Constant.DIFF_FROM)) {
                List ineqInds = this.getIndividuals(atom, bindings);
                s12 = (Individual)ineqInds.get(0);
                s22 = (Individual)ineqInds.get(1);
                ATermAppl sam = ATermUtils.makeValue(s22.getTerm());
                disj[index] = sam;
                inds[index] = s12.getName();
                ++index;
                if (disjunction == null) {
                    disjunction = sam;
                    continue;
                }
                disjunction = ATermUtils.makeOr(disjunction, sam);
                continue;
            }
            List propertyInds = this.getIndividuals(atom, bindings);
            Individual s = (Individual)propertyInds.get(0);
            Individual o = (Individual)propertyInds.get(1);
            ATermAppl p = this.term(pred.toString());
            ATermAppl notO = ATermUtils.negate(ATermUtils.makeValue(o.getTerm()));
            ATermAppl allPNotO = ATermUtils.makeAllValues(p, notO);
            disj[index] = allPNotO;
            inds[index] = s.getName();
            ++index;
            if (disjunction == null) {
                disjunction = allPNotO;
                continue;
            }
            disjunction = ATermUtils.makeOr(disjunction, allPNotO);
        }
        disjunction = ATermUtils.makeOr(ATermUtils.makeList(disj));
        if (!this.abox.isClosed()) {
            RuleBranch r = new RuleBranch(this.abox, this, this.abox.getIndividual(inds[0]), inds, disjunction, new DependencySet(this.abox.getBranch()), (ATermAppl[])disj);
            this.addBranch(r);
            r.tryBranch();
        }
    }

    public ATermAppl term(String s) {
        if (PelletOptions.USE_LOCAL_NAME) {
            s = URIUtils.getLocalName(s);
        } else if (PelletOptions.USE_QNAME) {
            s = qnames.shortForm(s);
        }
        return ATermUtils.makeTermAppl(s);
    }

    ABox complete() {
        this.completionTimer.start();
        Expressivity expressivity = this.abox.getKB().getExpressivity();
        boolean fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
        this.initialize();
        if (!this.abox.ranRete && this.abox.rulesNotApplied) {
            Interpreter interp = new Interpreter();
            try {
                Set rules = this.abox.getKB().getRules();
                interp.rete.compile(rules);
            }
            catch (Exception e) {
                System.err.println("Exception while compiling rules!");
                System.err.println(e);
            }
            Set facts = interp.rete.compileFacts(this.abox);
            interp.addFacts(facts, true);
            interp.run();
            if (log.isDebugEnabled()) {
                log.debug((Object)(interp.inferredFacts.size() + " inferred fact(s)"));
            }
            Iterator it = interp.inferredFacts.iterator();
            DependencySet ds = DependencySet.INDEPENDENT;
            while (it.hasNext()) {
                Fact f = (Fact)it.next();
                if (f.getPred().equals(Constant.TYPE)) {
                    Individual ind = this.abox.getIndividual(ATermUtils.makeTermAppl(f.getSubj().toString()));
                    ATermAppl type = ATermUtils.makeTermAppl(f.getObj().toString());
                    ind.addType(type, ds);
                    continue;
                }
                Individual from = this.abox.getIndividual(ATermUtils.makeTermAppl(f.getSubj().toString()));
                Individual to = this.abox.getIndividual(ATermUtils.makeTermAppl(f.getObj().toString()));
                Role r = this.abox.getRole(ATermUtils.makeTermAppl(f.getPred().toString()));
                this.addEdge(from, r, to, ds);
            }
            this.abox.ranRete = true;
        }
        while (!this.abox.isComplete()) {
            while (this.abox.changed && !this.abox.isClosed()) {
                Timer t;
                this.completionTimer.check();
                this.abox.changed = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb"));
                    this.abox.validate();
                    this.abox.printTree();
                }
                IndividualIterator i = this.abox.getIndIterator();
                if (!PelletOptions.USE_PSEUDO_NOMINALS) {
                    t = this.timers.startTimer("rule-nominal");
                    this.applyNominalRule(i);
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-guess");
                this.applyGuessingRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-max");
                this.applyMaxRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                if (fullDatatypeReasoning) {
                    t = this.timers.startTimer("check-dt-count");
                    this.checkDatatypeCount(i);
                    t.stop();
                    if (this.abox.isClosed()) break;
                    t = this.timers.startTimer("rule-lit");
                    this.applyLiteralRule();
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-unfold");
                this.applyUnfoldingRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-disj");
                this.applyDisjunctionRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-some");
                this.applySomeValuesRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-min");
                this.applyMinRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Applying RULE rule at branch:" + this.abox.getBranch()));
                }
                if (this.abox.rulesNotApplied) {
                    this.abox.rulesNotApplied = false;
                    this.applyRULERule();
                }
                if (!this.abox.isClosed()) continue;
                break;
            }
            if (this.abox.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash()));
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = (Branch)this.abox.getBranches().get(i);
                    ++unexploredBranch.tryNext;
                    if (unexploredBranch.tryNext < unexploredBranch.tryCount) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring branch " + unexploredBranch.branch + " tryNext = " + unexploredBranch.tryNext + " tryCount = " + unexploredBranch.tryCount);
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing branch " + unexploredBranch.branch);
                    this.abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
        this.completionTimer.stop();
        return this.abox;
    }
}

