/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DoubleBlocking;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.OptimizedDoubleBlocking;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.QueueElement;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Timer;

public class SHOIQStrategy
extends CompletionStrategy {
    public SHOIQStrategy(ABox abox) {
        super(abox, PelletOptions.FORCE_OPTIMIZED_BLOCKING ? new OptimizedDoubleBlocking() : new DoubleBlocking());
    }

    boolean supportsPseudoModelCompletion() {
        return true;
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            this.completionTimer.check();
            int lastBranch = this.abox.getClash().depends.max();
            if (lastBranch <= 0) {
                return false;
            }
            if (lastBranch > this.abox.getBranches().size()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but has only " + this.abox.getBranches().size() + " branches");
            }
            if (PelletOptions.USE_INCREMENTAL_DELETION) {
                Branch br = (Branch)this.abox.getBranches().get(lastBranch - 1);
                if (br.tryNext == br.tryCount - 1 && this.abox.getClash().depends.size() == 2) {
                    this.abox.getKB().getDependencyIndex().addCloseBranchDependency(br, this.abox.getClash().depends);
                    return false;
                }
            }
            List branches = this.abox.getBranches();
            if (PelletOptions.USE_TRACING && PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                List brList = branches.subList(lastBranch, branches.size());
                Iterator it = brList.iterator();
                while (it.hasNext()) {
                    this.abox.getKB().getDependencyIndex().removeBranchDependencies((Branch)it.next());
                }
                brList.clear();
            } else {
                branches.subList(lastBranch, branches.size()).clear();
            }
            Branch newBranch = (Branch)branches.get(lastBranch - 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JUMP: Branch " + lastBranch));
            }
            if (lastBranch != newBranch.branch) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but got " + newBranch.branch);
            }
            if (newBranch.tryNext < newBranch.tryCount) {
                newBranch.setLastClash(this.abox.getClash().depends);
            }
            ++newBranch.tryNext;
            if (newBranch.tryNext < newBranch.tryCount) {
                this.restore(newBranch);
                branchFound = newBranch.tryNext();
            } else {
                this.abox.getClash().depends.remove(lastBranch);
            }
            if (branchFound || !log.isDebugEnabled()) continue;
            log.debug((Object)("FAIL: Branch " + lastBranch));
        }
        return branchFound;
    }

    ABox complete() {
        this.completionTimer.start();
        Expressivity expressivity = this.abox.getKB().getExpressivity();
        boolean fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
        this.initialize();
        while (!this.abox.isComplete()) {
            while (this.abox.changed && !this.abox.isClosed()) {
                Timer t;
                this.completionTimer.check();
                this.abox.changed = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb"));
                    this.abox.validate();
                    this.printBlocked();
                    this.abox.printTree();
                }
                IndividualIterator i = this.abox.getIndIterator();
                if (!PelletOptions.USE_PSEUDO_NOMINALS) {
                    t = this.timers.startTimer("rule-nominal");
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.completionQueue.init(CompletionQueue.NOMLIST);
                        while (this.abox.completionQueue.hasNext(CompletionQueue.NOMLIST)) {
                            this.applyNominalRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.NOMLIST));
                            if (!this.abox.isClosed()) continue;
                            break;
                        }
                    } else {
                        this.applyNominalRule(i);
                    }
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-guess");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.completionQueue.init(CompletionQueue.GUESSLIST);
                    while (this.abox.completionQueue.hasNext(CompletionQueue.GUESSLIST)) {
                        this.applyGuessingRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.GUESSLIST));
                        if (!this.abox.isClosed()) continue;
                        break;
                    }
                } else {
                    this.applyGuessingRule(i);
                }
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-choose");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.completionQueue.init(CompletionQueue.CHOOSELIST);
                    while (this.abox.completionQueue.hasNext(CompletionQueue.CHOOSELIST)) {
                        this.applyChooseRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.CHOOSELIST));
                        if (!this.abox.isClosed()) continue;
                        break;
                    }
                } else {
                    this.applyChooseRule(i);
                }
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-max");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.completionQueue.init(CompletionQueue.MAXLIST);
                    while (this.abox.completionQueue.hasNext(CompletionQueue.MAXLIST)) {
                        this.applyMaxRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.MAXLIST));
                        if (!this.abox.isClosed()) continue;
                        break;
                    }
                } else {
                    this.applyMaxRule(i);
                }
                t.stop();
                if (this.abox.isClosed()) break;
                if (fullDatatypeReasoning) {
                    t = this.timers.startTimer("check-dt-count");
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.completionQueue.init(CompletionQueue.DATATYPELIST);
                        while (this.abox.completionQueue.hasNext(CompletionQueue.DATATYPELIST)) {
                            this.checkDatatypeCount((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.DATATYPELIST));
                            this.abox.completionQueue.init(CompletionQueue.DATATYPELIST);
                            if (!this.abox.isClosed()) continue;
                            break;
                        }
                    } else {
                        this.checkDatatypeCount(i);
                    }
                    t.stop();
                    if (this.abox.isClosed()) break;
                    t = this.timers.startTimer("rule-lit");
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.completionQueue.init(CompletionQueue.LITERALLIST);
                        while (this.abox.completionQueue.hasNext(CompletionQueue.LITERALLIST)) {
                            this.applyLiteralRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.LITERALLIST));
                            if (!this.abox.isClosed()) continue;
                            break;
                        }
                    } else {
                        this.applyLiteralRule();
                    }
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-unfold");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.completionQueue.init(CompletionQueue.ATOMLIST);
                    while (this.abox.completionQueue.hasNext(CompletionQueue.ATOMLIST)) {
                        this.applyUnfoldingRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.ATOMLIST));
                        if (!this.abox.isClosed()) continue;
                        break;
                    }
                } else {
                    this.applyUnfoldingRule(i);
                }
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-disj");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.completionQueue.init(CompletionQueue.ORLIST);
                    while (this.abox.completionQueue.hasNext(CompletionQueue.ORLIST)) {
                        this.applyDisjunctionRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.ORLIST));
                        if (!this.abox.isClosed()) continue;
                        break;
                    }
                } else {
                    this.applyDisjunctionRule(i);
                }
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-some");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.completionQueue.init(CompletionQueue.SOMELIST);
                    while (this.abox.completionQueue.hasNext(CompletionQueue.SOMELIST)) {
                        this.applySomeValuesRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.SOMELIST));
                        if (!this.abox.isClosed()) continue;
                        break;
                    }
                } else {
                    this.applySomeValuesRule(i);
                }
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-min");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.completionQueue.init(CompletionQueue.MINLIST);
                    while (this.abox.completionQueue.hasNext(CompletionQueue.MINLIST)) {
                        this.applyMinRule((QueueElement)this.abox.completionQueue.getNext(CompletionQueue.MINLIST));
                        if (!this.abox.isClosed()) continue;
                        break;
                    }
                } else {
                    this.applyMinRule(i);
                }
                t.stop();
                if (!this.abox.isClosed()) continue;
                break;
            }
            if (this.abox.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash()));
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = (Branch)this.abox.getBranches().get(i);
                    ++unexploredBranch.tryNext;
                    if (unexploredBranch.tryNext < unexploredBranch.tryCount) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring branch " + unexploredBranch.branch + " tryNext = " + unexploredBranch.tryNext + " tryCount = " + unexploredBranch.tryCount);
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing branch " + unexploredBranch.branch);
                    this.abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
        this.completionTimer.stop();
        return this.abox;
    }
}

