/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.UnionDatatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.SetUtils;

public class BaseUnionDatatype
extends BaseDatatype
implements UnionDatatype {
    protected Set members;

    BaseUnionDatatype(ATermAppl name, Datatype[] members) {
        super(name);
        this.members = SetUtils.create(members);
    }

    BaseUnionDatatype(ATermAppl name, Set members) {
        super(name);
        this.members = members;
    }

    BaseUnionDatatype(Datatype[] members) {
        super(null);
        this.members = SetUtils.create(members);
    }

    BaseUnionDatatype(Set members) {
        super(null);
        this.members = members;
    }

    public Set getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public int size() {
        int size = 0;
        for (Datatype dt : this.members) {
            if ((size += dt.size()) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    public boolean contains(Object value) {
        for (Datatype dt : this.members) {
            if (!dt.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object value, AtomicDatatype datatype) {
        for (Datatype dt : this.members) {
            if (dt instanceof AtomicDatatype && !datatype.getPrimitiveType().equals(((AtomicDatatype)dt).getPrimitiveType()) || !dt.contains(value, datatype)) continue;
            return true;
        }
        return false;
    }

    public Object getValue(String value, String datatypeURI) {
        Object obj = null;
        Iterator i = this.members.iterator();
        while (obj == null && i.hasNext()) {
            Datatype dt = (Datatype)i.next();
            obj = dt.getValue(value, datatypeURI);
        }
        return obj;
    }

    public Datatype singleton(Object value) {
        Datatype datatype = null;
        Iterator i = this.members.iterator();
        while (datatype == null && i.hasNext()) {
            Datatype dt = (Datatype)i.next();
            if (!dt.contains(value)) continue;
            datatype = dt.singleton(value);
        }
        return datatype;
    }

    public ATermAppl getValue(int n) {
        for (Datatype dt : this.members) {
            if (n <= dt.size()) {
                return dt.getValue(n);
            }
            n -= dt.size();
        }
        throw new InternalReasonerException("No values for this datatype");
    }

    public String toString() {
        return "UnionDatatype " + this.members;
    }
}

