/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.dig.DIGResponse;
import org.mindswap.pellet.dig.DIGTellHandler;
import org.mindswap.pellet.dig.ElementList;
import org.mindswap.pellet.utils.SetUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGAskHandler
extends DIGTellHandler {
    private DIGResponse response = new DIGResponse("responses");

    public Document asks(Element asks) {
        Document doc = null;
        if (!this.kb.isConsistent()) {
            doc = DIGResponse.createErrorResponse(12, "Inconsistent KB");
        } else {
            this.response = new DIGResponse("responses");
            ElementList askElements = DIGAskHandler.getElements(asks);
            for (int i = 0; i < askElements.getLength(); ++i) {
                Element ask = askElements.item(i);
                String tag = DIGAskHandler.getTagName(ask);
                String id = DIGAskHandler.getId(ask);
                Element[] params = DIGAskHandler.getElementArray(ask);
                if (tag.equals("toldValues")) {
                    this.toldValues(params[0], params[1], id);
                    continue;
                }
                Element result = null;
                if (tag.equals("allConceptNames")) {
                    result = this.allConceptNames();
                } else if (tag.equals("allRoleNames")) {
                    result = this.allRoleNames();
                } else if (tag.equals("allIndividuals")) {
                    result = this.allIndividuals();
                } else if (tag.equals("satisfiable")) {
                    result = this.satisfiable(params[0]);
                } else if (tag.equals("subsumes")) {
                    result = this.subsumes(params[0], params[1]);
                } else if (tag.equals("parents")) {
                    result = this.parents(params[0]);
                } else if (tag.equals("ancestors")) {
                    result = this.ancestors(params[0]);
                } else if (tag.equals("children")) {
                    result = this.children(params[0]);
                } else if (tag.equals("descendants")) {
                    result = this.descendants(params[0]);
                } else if (tag.equals("equivalents")) {
                    result = this.equivalents(params[0]);
                } else if (tag.equals("disjoint")) {
                    result = this.disjoint(params[0], params[1]);
                } else if (tag.equals("rparents")) {
                    result = this.rparents(params[0]);
                } else if (tag.equals("rancestors")) {
                    result = this.rancestors(params[0]);
                } else if (tag.equals("rchildren")) {
                    result = this.rchildren(params[0]);
                } else if (tag.equals("rdescendants")) {
                    result = this.rdescendants(params[0]);
                } else if (tag.equals("instances")) {
                    result = this.instances(params[0]);
                } else if (tag.equals("instance")) {
                    result = this.instance(params[0], params[1]);
                } else if (tag.equals("types")) {
                    result = this.types(params[0]);
                } else if (tag.equals("roleFillers")) {
                    result = this.roleFillers(params[0], params[1]);
                } else if (tag.equals("relatedIndividuals")) {
                    result = this.relatedIndividuals(params[0]);
                } else {
                    result = this.response.addError(14, tag + " is not a known ask operation");
                    log.error((Object)("ERROR (14) : " + tag + " is not a known ask operation"));
                }
                result.setAttribute("id", id);
            }
            if (askElements.isEmpty()) {
                this.response.addElement("ok");
            }
            doc = this.response.getDocument();
        }
        return doc;
    }

    public Element allConceptNames() {
        Element conceptSet = this.response.addElement("conceptSet");
        ArrayList<ATermAppl> classes = new ArrayList<ATermAppl>(this.kb.getAllClasses());
        for (int i = 0; i < classes.size(); ++i) {
            ATermAppl c = (ATermAppl)classes.get(i);
            Set<ATermAppl> eqs = this.kb.getAllEquivalentClasses(c);
            classes.subList(i + 1, classes.size()).removeAll(eqs);
            this.response.addSynonms(conceptSet, eqs, "catom");
        }
        return conceptSet;
    }

    public Element allRoleNames() {
        Element roleSet = this.response.addElement("roleSet");
        ArrayList<ATermAppl> properties = new ArrayList<ATermAppl>(this.kb.getProperties());
        for (int i = 0; i < properties.size(); ++i) {
            ATermAppl prop = (ATermAppl)properties.get(i);
            Set<ATermAppl> eqs = this.kb.getEquivalentProperties(prop);
            eqs.add(prop);
            properties.subList(i + 1, properties.size()).removeAll(eqs);
            this.response.addSynonms(roleSet, eqs, "ratom");
        }
        return roleSet;
    }

    public Element allIndividuals() {
        Set<ATermAppl> individuals = this.kb.getIndividuals();
        return this.response.addIndividualSet(individuals);
    }

    public Element satisfiable(Element node) {
        ATermAppl c = this.concept(node);
        boolean result = this.kb.isSatisfiable(c);
        return this.response.addBoolean(result);
    }

    public Element subsumes(Element node1, Element node2) {
        ATermAppl c1 = this.concept(node1);
        ATermAppl c2 = this.concept(node2);
        boolean result = this.kb.isSubClassOf(c2, c1);
        return this.response.addBoolean(result);
    }

    public Element disjoint(Element node1, Element node2) {
        ATermAppl c1 = this.concept(node1);
        ATermAppl c2 = this.concept(node2);
        boolean result = this.kb.isDisjoint(c1, c2);
        return this.response.addBoolean(result);
    }

    public Element children(Element node) {
        ATermAppl c = this.concept(node);
        Set<Set<ATermAppl>> children = this.kb.getSubClasses(c, true);
        return this.response.addConceptSet(children);
    }

    public Element descendants(Element node) {
        ATermAppl c = this.concept(node);
        Set<Set<ATermAppl>> descendants = this.kb.getSubClasses(c, false);
        return this.response.addConceptSet(descendants);
    }

    public Element parents(Element node) {
        ATermAppl c = this.concept(node);
        Set<Set<ATermAppl>> parents = this.kb.getSuperClasses(c, true);
        return this.response.addConceptSet(parents);
    }

    public Element ancestors(Element node) {
        ATermAppl c = this.concept(node);
        Set<Set<ATermAppl>> ancestors = this.kb.getSuperClasses(c, false);
        return this.response.addConceptSet(ancestors);
    }

    public Element equivalents(Element node) {
        ATermAppl c = this.concept(node);
        Set equivalents = SetUtils.singleton(this.kb.getAllEquivalentClasses(c));
        return this.response.addConceptSet(equivalents);
    }

    public Element rchildren(Element node) {
        ATermAppl prop = this.property(node);
        boolean isAttribute = this.kb.isDatatypeProperty(prop);
        Set<Set<ATermAppl>> rchildren = this.kb.getSubProperties(prop, true);
        return this.response.addRoleSet(rchildren, isAttribute);
    }

    public Element rdescendants(Element node) {
        ATermAppl prop = this.property(node);
        boolean isAttribute = this.kb.isDatatypeProperty(prop);
        Set<Set<ATermAppl>> rdescendants = this.kb.getSubProperties(prop, false);
        rdescendants.add(this.kb.getAllEquivalentProperties(prop));
        return this.response.addRoleSet(rdescendants, isAttribute);
    }

    public Element rparents(Element node) {
        ATermAppl prop = this.property(node);
        boolean isAttribute = this.kb.isDatatypeProperty(prop);
        Set<Set<ATermAppl>> rparents = this.kb.getSuperProperties(prop, true);
        return this.response.addRoleSet(rparents, isAttribute);
    }

    public Element rancestors(Element node) {
        ATermAppl prop = this.property(node);
        boolean isAttribute = this.kb.isDatatypeProperty(prop);
        Set<Set<ATermAppl>> rancestors = this.kb.getSuperProperties(prop, false);
        rancestors.add(this.kb.getAllEquivalentProperties(prop));
        return this.response.addRoleSet(rancestors, isAttribute);
    }

    public Element instances(Element node) {
        ATermAppl c = this.concept(node);
        Set<ATermAppl> instances = this.kb.getInstances(c);
        return this.response.addIndividualSet(instances);
    }

    public Element instance(Element node1, Element node2) {
        ATermAppl ind = DIGAskHandler.individual(node1);
        ATermAppl c = this.concept(node2);
        boolean result = this.kb.isType(ind, c);
        return this.response.addBoolean(result);
    }

    public Element types(Element node) {
        ATermAppl ind = DIGAskHandler.individual(node);
        Set<Set<ATermAppl>> types = this.kb.getTypes(ind);
        return this.response.addConceptSet(types);
    }

    public Element relatedIndividuals(Element node) {
        ATermAppl role = this.property(node);
        Map<ATermAppl, List<ATermAppl>> values = this.kb.getPropertyValues(role);
        return this.response.addIndividualPairSet(values);
    }

    public Element roleFillers(Element nodeInd, Element nodeRole) {
        ATermAppl ind = DIGAskHandler.individual(nodeInd);
        ATermAppl prop = this.property(nodeRole);
        List<ATermAppl> values = this.kb.getPropertyValues(prop, ind);
        return this.response.addIndividualSet(values);
    }

    public void toldValues(Element nodeInd, Element nodeRole, String id) {
        ATermAppl ind = DIGAskHandler.individual(nodeInd);
        ATermAppl prop = this.property(nodeRole);
        List<ATermAppl> values = this.kb.getPropertyValues(prop, ind);
        this.response.addValues(values, id);
    }
}

