/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.dig.DIGAskHandler;
import org.mindswap.pellet.dig.DIGResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PelletDIGReasoner
extends DIGAskHandler {
    private String baseURI = "urn:dig:pellet:kb";
    private Map allKBs = new HashMap();
    private String selectedKB;
    private Document identifier;
    private static final String[] supportLang = new String[]{"top", "bottom", "catom", "and", "or", "not", "some", "all", "atmost", "atleast", "iset", "ratom", "inverse", "attribute", "intequals", "stringequals"};
    private static final String[] supportTell = new String[]{"defconcept", "impliesc", "equalc", "disjoint", "defrole", "defattribute", "impliesr", "equalr", "domain", "range", "transitive", "functional", "defindividual", "instanceof", "related", "value", "rangeint", "rangestring"};
    private static final String[] supportAsk = new String[]{"allConceptNames", "allRoleNames", "allIndividuals", "satisfiable", "subsumes", "disjoint", "parents", "children", "ancestors", "descendants", "equivalents", "rparents", "rchildren", "rancestors", "rdescendants", "instances", "types", "instance", "roleFillers", "relatedIndividuals", "toldValues"};
    private DOMParser parser = new DOMParser();

    public PelletDIGReasoner() {
        try {
            this.parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.selectedKB = "NO_KB";
    }

    public void process(InputStream in, OutputStream out) throws SAXException, IOException {
        this.process(new InputStreamReader(in), new OutputStreamWriter(out));
    }

    public void process(Reader in, Writer out) throws SAXException, IOException {
        this.parser.parse(new InputSource(in));
        Document doc = this.parser.getDocument();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n" + PelletDIGReasoner.serialize(doc) + "\n"));
        }
        Document result = this.process(doc);
        OutputFormat format = new OutputFormat(result);
        format.setLineWidth(0);
        format.setPreserveSpace(false);
        format.setIndenting(true);
        format.setOmitXMLDeclaration(false);
        XMLSerializer serial = new XMLSerializer(out, format);
        serial.asDOMSerializer();
        serial.serialize(result.getDocumentElement());
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n" + PelletDIGReasoner.serialize(result) + "\n"));
        }
    }

    public Document process(Document cmd) {
        Document result;
        block18: {
            Element cmdNode = cmd.getDocumentElement();
            String cmdName = PelletDIGReasoner.getTagName(cmdNode);
            if (cmdName.equals("getIdentifier")) {
                result = this.getIdentifier();
            } else if (cmdName.equals("newKB")) {
                try {
                    String uri = this.newKB();
                    result = DIGResponse.createKBResponse(uri);
                }
                catch (Exception e) {
                    result = DIGResponse.createErrorResponse(4, "Cannot create KB!");
                }
            } else if (cmdName.equals("releaseKB")) {
                String uri = PelletDIGReasoner.getURI(cmdNode);
                boolean success = this.releaseKB(uri);
                result = success ? DIGResponse.createOkResponse() : DIGResponse.createErrorResponse(7, "Cannot release KB " + uri);
            } else if (cmdName.equals("asks")) {
                try {
                    String uri = PelletDIGReasoner.getURI(cmdNode);
                    if (this.selectKB(uri)) {
                        result = this.asks(cmdNode);
                        break block18;
                    }
                    result = DIGResponse.createErrorResponse(6, uri + " is not known KB URI");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = DIGResponse.createErrorResponse(12, e.getMessage());
                }
            } else if (cmdName.equals("tells")) {
                try {
                    String uri = PelletDIGReasoner.getURI(cmdNode);
                    if (this.selectKB(uri)) {
                        result = this.tells(cmdNode);
                    }
                    result = DIGResponse.createErrorResponse(6, uri + " is not known KB URI");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return DIGResponse.createErrorResponse(9, e.getMessage());
                }
            } else {
                result = DIGResponse.createErrorResponse(1, "Unknown request " + cmd);
            }
        }
        return result;
    }

    public boolean selectKB(String uri) {
        if (uri.equals(this.selectedKB)) {
            return true;
        }
        if (!this.allKBs.containsKey(uri)) {
            return false;
        }
        this.selectedKB = uri;
        KnowledgeBase kb = (KnowledgeBase)this.allKBs.get(uri);
        this.setKB(kb);
        return true;
    }

    public void unselectKB(String uri) {
        if (!uri.equals(this.selectedKB)) {
            return;
        }
        this.selectedKB = "NO_KB";
    }

    public Document getIdentifier() {
        if (this.identifier == null) {
            DIGResponse response = new DIGResponse("identifier");
            this.identifier = response.getDocument();
            Element id = this.identifier.getDocumentElement();
            id.setAttribute("name", "Pellet");
            id.setAttribute("version", Pellet.getVersionInfo().getVersionString());
            id.setAttribute("message", "Pellet - OWL DL Reasoner");
            Element supports = response.addElement("supports", id);
            Element language = response.addElement("language", supports);
            for (int i = 0; i < supportLang.length; ++i) {
                response.addElement(supportLang[i], language);
            }
            Element tell = response.addElement("tell", supports);
            for (int i = 0; i < supportTell.length; ++i) {
                response.addElement(supportTell[i], tell);
            }
            Element ask = response.addElement("ask", supports);
            for (int i = 0; i < supportAsk.length; ++i) {
                response.addElement(supportAsk[i], ask);
            }
        }
        return this.identifier;
    }

    public String newKB() {
        String newURI = this.baseURI + new UID().toString();
        this.newKB(newURI);
        return newURI;
    }

    public KnowledgeBase newKB(String newURI) {
        KnowledgeBase newKB = new KnowledgeBase();
        this.allKBs.put(newURI, newKB);
        return newKB;
    }

    public boolean releaseKB(String uri) {
        this.unselectKB(uri);
        this.allKBs.remove(uri);
        return true;
    }
}

