/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import java.net.BindException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.dig.PelletDIGReasoner;
import org.mindswap.pellet.utils.VersionInfo;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.MultiException;

public class PelletDIGServer
extends AbstractHttpHandler
implements HttpHandler {
    private static final long serialVersionUID = 5605350732186236386L;
    protected static Log log = LogFactory.getLog(PelletDIGServer.class);
    private PelletDIGReasoner reasoner = new PelletDIGReasoner();
    public static int DEFAULT_PORT = 8081;

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) {
        try {
            response.setContentType("text/html");
            this.reasoner.process(request.getInputStream(), response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void usage() {
        System.out.println("Pellet DIG Server");
        System.out.println("DIG Server that is backed by Pellet reasoner");
        System.out.println("");
        System.out.println("Usage: java PelletDIGServer [-port portNum]");
        System.out.println("   -port portNum           The port number user by the server (default");
        System.out.println("                           port number used is 8081)");
        System.out.println("   -help                   Print this information");
    }

    public static void main(String[] args) {
        int port = DEFAULT_PORT;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-help")) {
                PelletDIGServer.usage();
                System.exit(0);
                continue;
            }
            if (arg.equalsIgnoreCase("-port")) {
                try {
                    port = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException e1) {
                    System.err.println("Invalid port number: " + args[i]);
                    System.exit(1);
                }
                continue;
            }
            System.err.println("Unrecognized option: " + arg);
            PelletDIGServer.usage();
            System.exit(1);
        }
        try {
            HttpServer server = new HttpServer();
            SocketListener listener = new SocketListener();
            listener.setPort(port);
            listener.setMinThreads(2);
            listener.setMaxThreads(10);
            server.addListener((HttpListener)listener);
            HttpContext context = server.addContext("/");
            context.addHandler((HttpHandler)new PelletDIGServer());
            server.start();
            VersionInfo vinfo = Pellet.getVersionInfo();
            System.out.println();
            System.out.print("PelletDIGServer ");
            System.out.print("Version " + vinfo.getVersionString());
            System.out.print(" (" + vinfo.getReleaseDate() + ")");
            System.out.println();
            System.out.println("Port: " + port);
            log.debug((Object)"Debug is enabled");
        }
        catch (Exception e) {
            if (e instanceof MultiException && ((MultiException)e).getException(0) instanceof BindException) {
                System.err.println("Cannot start server. Port " + port + " is already in use!");
            } else {
                e.printStackTrace();
            }
            System.exit(0);
        }
    }
}

