/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Map;
import org.mindswap.pellet.datatypes.RDFXMLLiteral;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class JenaUtils {
    public static ATermAppl makeLiteral(LiteralLabel jenaLiteral) {
        String lexicalValue = jenaLiteral.getLexicalForm();
        String datatypeURI = jenaLiteral.getDatatypeURI();
        ATermAppl literalValue = null;
        literalValue = datatypeURI != null ? ATermUtils.makeTypedLiteral(lexicalValue, datatypeURI) : (jenaLiteral.language() == null ? ATermUtils.makePlainLiteral(lexicalValue, jenaLiteral.language()) : ATermUtils.makePlainLiteral(lexicalValue));
        return literalValue;
    }

    public static Node makeGraphLiteral(ATermAppl literal) {
        Node node;
        String lexicalValue = ((ATermAppl)literal.getArgument(0)).getName();
        String lang = ((ATermAppl)literal.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)literal.getArgument(2)).getName();
        if (!lang.equals("")) {
            node = Node.createLiteral((String)lexicalValue, (String)lang, (boolean)false);
        } else if (datatypeURI.equals("")) {
            node = Node.createLiteral((String)lexicalValue);
        } else if (datatypeURI.equals(RDFXMLLiteral.instance.getURI())) {
            node = Node.createLiteral((String)lexicalValue, (String)"", (boolean)true);
        } else {
            RDFDatatype datatype = TypeMapper.getInstance().getTypeByName(datatypeURI);
            node = Node.createLiteral((String)lexicalValue, (String)"", (RDFDatatype)datatype);
        }
        return node;
    }

    public static Node makeGraphResource(ATermAppl term) {
        String name = term.getName();
        if (name.startsWith("bNode")) {
            String anonID = name.substring("bNode".length());
            return Node.createAnon((AnonId)new AnonId(anonID));
        }
        if (term.equals(ATermUtils.TOP)) {
            return OWL.Thing.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM)) {
            return OWL.Nothing.asNode();
        }
        if (term.getArity() == 0) {
            return Node.createURI((String)name);
        }
        throw new InternalReasonerException("Invalid term found " + term);
    }

    public static Node makeGraphNode(ATermAppl value) {
        if (ATermUtils.isLiteral(value)) {
            return JenaUtils.makeGraphLiteral(value);
        }
        return JenaUtils.makeGraphResource(value);
    }

    public static Literal makeLiteral(ATermAppl literal, Model model) {
        Literal node = null;
        String lexicalValue = ((ATermAppl)literal.getArgument(0)).getName();
        String lang = ((ATermAppl)literal.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)literal.getArgument(2)).getName();
        node = !lang.equals("") ? model.createLiteral(lexicalValue, lang) : (datatypeURI.equals("") ? model.createLiteral(lexicalValue) : (datatypeURI.equals(RDFXMLLiteral.instance.getURI()) ? model.createLiteral(lexicalValue, true) : model.createTypedLiteral(lexicalValue, datatypeURI)));
        return node;
    }

    public static Resource makeResource(ATermAppl term, Model model) {
        if (term.equals(ATermUtils.TOP)) {
            return OWL.Thing;
        }
        if (term.equals(ATermUtils.BOTTOM)) {
            return OWL.Nothing;
        }
        if (term.getArity() == 0) {
            String name = term.getName();
            if (name.startsWith("bNode")) {
                String anonID = name.substring("bNode".length());
                return model.createResource(new AnonId(anonID));
            }
            return model.getResource(name);
        }
        return null;
    }

    public static Property makeProperty(ATermAppl term, Model model) {
        String name = term.getName();
        if (!name.startsWith("bNode")) {
            return model.getProperty("", name);
        }
        return null;
    }

    public static RDFNode makeRDFNode(ATermAppl term, Model model) {
        if (ATermUtils.isLiteral(term)) {
            return JenaUtils.makeLiteral(term, model);
        }
        return JenaUtils.makeResource(term, model);
    }

    public static QNameProvider makeQNameProvider(PrefixMapping mapping) {
        QNameProvider qnames = new QNameProvider();
        for (Map.Entry entry : mapping.getNsPrefixMap().entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            qnames.setMapping(prefix, uri);
        }
        return qnames;
    }
}

