/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.utils.AlphaNumericComparator;
import org.mindswap.pellet.utils.Cache;
import org.mindswap.pellet.utils.URIUtils;

public class ModelReader {
    protected static Log log = LogFactory.getLog(ModelReader.class);
    public static boolean DEBUG = false;
    private Map modelCache = new HashMap();
    private Map modelNames = new HashMap();
    private Set ignoreImports = new HashSet();
    private RDFErrorHandler handler = null;
    private Cache cache = new Cache();

    public ModelReader() {
        this.addLoaded(this.ignoreImports, "http://www.w3.org/2002/07/owl#");
        this.addLoaded(this.ignoreImports, "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.addLoaded(this.ignoreImports, "http://www.w3.org/2000/01/rdf-schema#");
    }

    public void ignoreFile(String file) {
        this.addLoaded(this.ignoreImports, file);
    }

    private void addLoaded(Set loadedFiles, String uri) {
        uri = URIUtils.getNameSpace(uri);
        loadedFiles.add(uri);
    }

    private boolean isLoaded(Set loadedFiles, String uri) {
        return loadedFiles.contains(uri = URIUtils.getNameSpace(uri)) || this.ignoreImports.contains(uri);
    }

    private void readFile(List models, Set loadedFiles, String uri, String format, boolean withImports) {
        if (this.isLoaded(loadedFiles, uri)) {
            return;
        }
        Model model = (Model)this.modelCache.get(uri);
        if (model == null) {
            model = ModelFactory.createDefaultModel();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reading " + uri));
                }
                InputStream in = this.createInputStream(uri);
                RDFReader reader = model.getReader(format);
                if (this.handler != null) {
                    reader.setErrorHandler(this.handler);
                }
                reader.setProperty("WARN_REDEFINITION_OF_ID", (Object)"EM_IGNORE");
                reader.setProperty("WARN_BAD_NAME", (Object)"EM_IGNORE");
                reader.read(model, in, uri.toString());
                in.close();
                this.modelNames.put(model, uri);
                this.modelCache.put(uri, model);
            }
            catch (IOException e) {
                if (loadedFiles.isEmpty()) {
                    throw new RuntimeException(e);
                }
                if (this.handler != null) {
                    this.handler.error((Exception)e);
                }
                log.warn((Object)("The import file " + uri + " cannot be parsed"));
            }
        }
        this.addLoaded(loadedFiles, uri);
        models.add(model);
        if (withImports) {
            StmtIterator i = model.listStatements(null, OWL.imports, (RDFNode)((Resource)null));
            while (i.hasNext()) {
                Statement stmt = i.nextStatement();
                String importFile = stmt.getResource().toString();
                this.readFile(models, loadedFiles, importFile, format, withImports);
            }
        }
    }

    public Model[] readSeparate(String url, String format) {
        ArrayList models = new ArrayList();
        HashSet loadedFiles = new HashSet();
        this.readFile(models, loadedFiles, url, format, true);
        return models.toArray(new Model[models.size()]);
    }

    private Model readSingle(String url, String format) {
        ArrayList models = new ArrayList();
        HashSet loadedFiles = new HashSet();
        this.readFile(models, loadedFiles, url, format, false);
        return (Model)models.get(0);
    }

    public String getURI(Model model) {
        return (String)this.modelNames.get(model);
    }

    private Model mergeAll(Model[] models) {
        Model model = ModelFactory.createDefaultModel();
        for (int i = 0; i < models.length; ++i) {
            model.add(models[i], false);
        }
        return model;
    }

    private InputStream createInputStream(String uri) throws FileNotFoundException {
        InputStream in = null;
        if (this.cache.isForced()) {
            File cachedFile = this.cache.getCachedFile(uri);
            if (cachedFile != null) {
                System.err.println("WARNING: Force using cached file " + cachedFile);
                in = new FileInputStream(cachedFile);
            } else {
                try {
                    in = new URI(uri).toURL().openConnection().getInputStream();
                }
                catch (Exception e) {
                    throw new FileNotFoundException("The file " + uri + " cannot be parsed");
                }
            }
        } else {
            try {
                in = new URI(uri).toURL().openConnection().getInputStream();
            }
            catch (Exception e) {
                System.err.println("WARNING: Cannot read file " + uri);
                File cachedFile = this.cache.getCachedFile(uri.toString());
                if (cachedFile != null) {
                    System.err.println("WARNING: Try cached file " + cachedFile);
                    in = new FileInputStream(cachedFile);
                }
                throw new FileNotFoundException("The file " + uri + " cannot be parsed");
            }
        }
        return in;
    }

    public Model read(String uri) {
        return this.read(uri, "RDF/XML");
    }

    public Model read(String uri, String format) {
        return this.read(uri, format, true);
    }

    public Model read(String uri, boolean withImports) {
        return this.read(uri, "RDF/XML", withImports);
    }

    public Model read(String uri, String format, boolean withImports) {
        Model model = null;
        model = withImports ? this.mergeAll(this.readSeparate(uri, format)) : this.readSingle(uri, format);
        return model;
    }

    public static Model read(String loc, final String pattern, int limit) throws RuntimeException {
        URL url;
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        try {
            url = new URL(loc);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getPath());
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return dir != null && name.matches(pattern);
                        }
                    });
                    Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
                    int size = files.length > limit ? limit : files.length;
                    for (int j = 0; j < size; ++j) {
                        String fileURI = files[j].toURI().toString();
                        model.read(fileURI);
                    }
                } else {
                    model.read(loc);
                }
            }
        } else {
            model.read(loc);
        }
        return model;
    }

    public Model read(InputStream in) {
        return this.read(in, "RDF/XML");
    }

    public Model read(InputStream in, String format) {
        return this.read(in, format, "");
    }

    public Model read(InputStream in, String format, String base) {
        return this.read(in, format, base, true);
    }

    public Model read(InputStream in, String format, String base, boolean withImports) {
        Model model = ModelFactory.createDefaultModel();
        RDFReader reader = model.getReader(format);
        reader.setErrorHandler(this.handler);
        reader.read(model, in, base);
        if (withImports) {
            ArrayList models = new ArrayList();
            HashSet loadedFiles = new HashSet();
            StmtIterator i = model.listStatements(null, OWL.imports, (RDFNode)((Resource)null));
            while (i.hasNext()) {
                Statement stmt = i.nextStatement();
                String importFile = stmt.getResource().toString();
                this.readFile(models, loadedFiles, importFile, format, withImports);
            }
            for (int j = 0; j < models.size(); ++j) {
                model.add((Model)models.get(j), false);
            }
        }
        return model;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.handler;
        this.handler = errHandler;
        return old;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

