/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.UnknownDatatype;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.MultiIterator;
import org.mindswap.pellet.jena.vocabulary.OWL_1_1;
import org.mindswap.pellet.jena.vocabulary.SWRL;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Rule;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.URIUtils;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLLoader {
    protected static Log log;
    public static final Map<String, String> BUILT_IN_NS;
    public static final Property[] SKIP_PROPS;
    public static final Resource[] SKIP_TYPES;
    static final String[] TYPES;
    static final Integer SKIP;
    static final int RDF_Property = 1;
    static final int RDFS_Class = 2;
    static final int RDFS_Datatype = 3;
    static final int OWL_Thing = 4;
    static final int OWL_Nothing = 5;
    static final int OWL_Class = 6;
    static final int OWL_ObjectProperty = 7;
    static final int OWL_DatatypeProperty = 8;
    static final int OWL_FunctionalProperty = 9;
    static final int OWL_InverseFunctionalProperty = 10;
    static final int OWL_TransitiveProperty = 11;
    static final int OWL_SymmetricProperty = 12;
    static final int OWL_AnnotationProperty = 13;
    static final int OWL_DataRange = 14;
    static final int OWL11_ReflexiveProperty = 20;
    static final int OWL11_IrreflexiveProperty = 21;
    static final int OWL11_AntisymmetricProperty = 22;
    static final int OWL11_NegativeObjectPropertyAssertion = 23;
    static final int OWL11_NegativeDataPropertyAssertion = 24;
    static final int ECONN_LinkProperty = 50;
    static final int ECONN_ForeignIndividual = 51;
    static final int ECONN_ForeignClass = 52;
    static final int ECONN_ForeignObjectProperty = 53;
    static final int ECONN_ForeignDatatypeProperty = 54;
    static final int ECONN_ForeignLinkProperty = 55;
    static final int SWRL_Imp = 60;
    static final int RDFS_subClassOf = 25;
    static final int RDFS_subPropertyOf = 26;
    static final int RDFS_domain = 27;
    static final int RDFS_range = 28;
    static final int OWL_unionOf = 29;
    static final int OWL_sameAs = 30;
    static final int OWL_oneOf = 31;
    static final int OWL_inverseOf = 32;
    static final int OWL_intersectionOf = 33;
    static final int OWL_equivalentProperty = 34;
    static final int OWL_equivalentClass = 35;
    static final int OWL_distinctMembers = 36;
    static final int OWL_disjointWith = 37;
    static final int OWL_differentFrom = 38;
    static final int OWL_complementOf = 39;
    static final int OWL11_disjointUnionOf = 40;
    static final int OWL11_disjointObjectProperties = 41;
    static final int OWL11_disjointDataProperties = 42;
    static final Object SELF;
    static final Object CARDINALITY;
    static final Object IRREFLEXIVE;
    static final Object ANTI_SYM;
    static final Object DISJOINT;
    static Map<Node, Integer> KEYWORDS;
    static final int CLASS = 0;
    static final int INDIVIDUAL = 1;
    static final int OBJ_PROP = 2;
    static final int DT_PROP = 4;
    static final int ANT_PROP = 8;
    static final int ONT_PROP = 15;
    static final int DATATYPE = 16;
    static final int LINK_PROP = 18;
    public static QNameProvider qnames;
    private KnowledgeBase kb;
    private Graph graph;
    private Map terms;
    private Map lists;
    private Map restrictions;
    private Map simpleProperties;
    private Map resourceLinkTypes;
    private Set<String> unsupportedFeatures;
    private ProgressMonitor monitor = new SilentProgressMonitor();

    public OWLLoader() {
        this.clear();
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor == null ? new SilentProgressMonitor() : monitor;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Set<String> getWarnings() {
        return this.unsupportedFeatures;
    }

    public Set<String> getUnpportedFeatures() {
        return this.unsupportedFeatures;
    }

    private void addSimpleProperty(ATermAppl p, Object why) {
        this.simpleProperties.put(p, why);
        Role role = this.kb.getRBox().getRole(p);
        role.setForceSimple(true);
    }

    private void addUnsupportedFeature(String msg) {
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(msg);
        }
        if (this.unsupportedFeatures.add(msg)) {
            log.warn((Object)("Unsupported axiom: " + msg));
        }
    }

    public void clear() {
        this.terms = new HashMap();
        this.terms.put(OWL.Thing.asNode(), ATermUtils.TOP);
        this.terms.put(OWL.Nothing.asNode(), ATermUtils.BOTTOM);
        this.lists = new HashMap();
        this.lists.put(RDF.nil.asNode(), ATermUtils.EMPTY_LIST);
        this.restrictions = new HashMap();
        this.simpleProperties = new HashMap();
        this.resourceLinkTypes = new HashMap();
        this.unsupportedFeatures = new HashSet<String>();
    }

    private Node getObject(Node subj, Node pred) {
        ExtendedIterator all = this.graph.find(subj, pred, null);
        if (all.hasNext()) {
            Triple triple = (Triple)all.next();
            return triple.getObject();
        }
        return null;
    }

    private boolean hasObject(Node subj, Node pred) {
        return this.graph.find(subj, pred, null).hasNext();
    }

    private boolean hasObject(Node subj, Node pred, Node obj) {
        return this.graph.contains(subj, pred, obj);
    }

    public ATermList createList(Node node) {
        if (this.lists.containsKey(node)) {
            return (ATermList)this.lists.get(node);
        }
        Node first = this.getObject(node, RDF.first.asNode());
        this.monitor.incrementProgress();
        Node rest = this.getObject(node, RDF.rest.asNode());
        this.monitor.incrementProgress();
        if (first == null || rest == null) {
            this.addUnsupportedFeature("Invalid list structure: List " + node + " does not have a " + (first == null ? "rdf:first" : "rdf:rest") + " property. Ignoring rest of the list.");
            return ATermUtils.EMPTY_LIST;
        }
        ATermAppl firstNode = this.node2term(first);
        if (firstNode == null) {
            this.addUnsupportedFeature("Invalid list structure: List " + node + " does not have a valid " + "rdf:first property. Ignoring rest of the list.");
            return ATermUtils.EMPTY_LIST;
        }
        ATermList restList = this.createList(rest);
        ATermList list = ATermUtils.makeList(firstNode, restList);
        this.lists.put(node, list);
        return list;
    }

    public ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.TOP;
        Node p = this.getObject(node, OWL.onProperty.asNode());
        this.monitor.incrementProgress();
        if (p == null) {
            return aTerm;
        }
        ATermAppl pt = this.node2term(p);
        Node o = null;
        if (this.graph.contains(node, RDF.type.asNode(), OWL_1_1.SelfRestriction.asNode())) {
            this.monitor.incrementProgress();
            aTerm = ATermUtils.makeSelf(pt);
            this.defineObjectProperty(pt);
            this.addSimpleProperty(pt, SELF);
        } else {
            o = this.getObject(node, OWL.hasValue.asNode());
            if (o != null) {
                this.monitor.incrementProgress();
                if (PelletOptions.USE_PSEUDO_NOMINALS) {
                    if (o.isLiteral()) {
                        aTerm = ATermUtils.makeMin((ATerm)pt, 1, (ATerm)ATermUtils.TOP_LIT);
                    } else {
                        ATermAppl ind = ATermUtils.makeTermAppl(o.getURI());
                        ATermAppl nom = ATermUtils.makeTermAppl(o.getURI() + "_nom");
                        this.defineClass(nom);
                        this.defineIndividual(ind);
                        this.kb.addType(ind, nom);
                        aTerm = ATermUtils.makeSomeValues(pt, nom);
                    }
                } else {
                    ATermAppl ot = this.node2term(o);
                    if (o.isLiteral()) {
                        this.defineDatatypeProperty(pt);
                    } else {
                        this.defineObjectProperty(pt);
                    }
                    aTerm = ATermUtils.makeHasValue(pt, ot);
                }
            } else {
                o = this.getObject(node, OWL.allValuesFrom.asNode());
                if (o != null) {
                    this.monitor.incrementProgress();
                    ATermAppl ot = this.node2term(o);
                    if (this.kb.isClass(ot)) {
                        this.defineObjectProperty(pt);
                    } else if (this.kb.isDatatype(ot)) {
                        this.defineDatatypeProperty(pt);
                    }
                    aTerm = ATermUtils.makeAllValues(pt, ot);
                } else {
                    o = this.getObject(node, OWL.someValuesFrom.asNode());
                    if (o != null) {
                        this.monitor.incrementProgress();
                        ATermAppl ot = this.node2term(o);
                        if (this.kb.isClass(ot)) {
                            this.defineObjectProperty(pt);
                        } else if (this.kb.isDatatype(ot)) {
                            this.defineDatatypeProperty(pt);
                        }
                        aTerm = ATermUtils.makeSomeValues(pt, ot);
                    } else {
                        o = this.getObject(node, OWL.minCardinality.asNode());
                        if (o != null) {
                            this.monitor.incrementProgress();
                            try {
                                ATermAppl c = null;
                                Node qualification = null;
                                qualification = this.getObject(node, OWL_1_1.onClass.asNode());
                                if (qualification != null) {
                                    this.monitor.incrementProgress();
                                    c = this.node2term(qualification);
                                    this.defineObjectProperty(pt);
                                } else {
                                    qualification = this.getObject(node, OWL_1_1.onDataRange.asNode());
                                    if (qualification != null) {
                                        this.monitor.incrementProgress();
                                        c = this.node2term(qualification);
                                        this.defineDatatypeProperty(pt);
                                    } else {
                                        int propType = this.guessPropertyType(pt, p);
                                        if (propType == 1) {
                                            c = ATermUtils.TOP;
                                        } else if (propType == 2) {
                                            c = ATermUtils.TOP_LIT;
                                        } else {
                                            this.defineObjectProperty(pt);
                                            c = ATermUtils.TOP;
                                        }
                                    }
                                }
                                int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                                aTerm = ATermUtils.makeMin((ATerm)pt, cardinality, (ATerm)c);
                                this.addSimpleProperty(pt, CARDINALITY);
                            }
                            catch (Exception ex) {
                                this.addUnsupportedFeature("Invalid value for the min cardinality restriction: " + o);
                            }
                        } else {
                            o = this.getObject(node, OWL.maxCardinality.asNode());
                            if (o != null) {
                                this.monitor.incrementProgress();
                                try {
                                    ATermAppl c = null;
                                    Node qualification = null;
                                    qualification = this.getObject(node, OWL_1_1.onClass.asNode());
                                    if (qualification != null) {
                                        this.monitor.incrementProgress();
                                        c = this.node2term(qualification);
                                        this.defineObjectProperty(pt);
                                    } else {
                                        qualification = this.getObject(node, OWL_1_1.onDataRange.asNode());
                                        if (qualification != null) {
                                            this.monitor.incrementProgress();
                                            c = this.node2term(qualification);
                                            this.defineDatatypeProperty(pt);
                                        } else {
                                            int propType = this.guessPropertyType(pt, p);
                                            if (propType == 1) {
                                                c = ATermUtils.TOP;
                                            } else if (propType == 2) {
                                                c = ATermUtils.TOP_LIT;
                                            } else {
                                                this.defineObjectProperty(pt);
                                                c = ATermUtils.TOP;
                                            }
                                        }
                                    }
                                    int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                                    aTerm = ATermUtils.makeMax((ATerm)pt, cardinality, (ATerm)c);
                                    this.addSimpleProperty(pt, CARDINALITY);
                                }
                                catch (Exception ex) {
                                    this.addUnsupportedFeature("Invalid value for the max cardinality restriction: " + o);
                                }
                            } else {
                                o = this.getObject(node, OWL.cardinality.asNode());
                                if (o != null) {
                                    this.monitor.incrementProgress();
                                    try {
                                        ATermAppl c = null;
                                        Node qualification = null;
                                        qualification = this.getObject(node, OWL_1_1.onClass.asNode());
                                        if (qualification != null) {
                                            this.monitor.incrementProgress();
                                            c = this.node2term(qualification);
                                            this.defineObjectProperty(pt);
                                        } else {
                                            qualification = this.getObject(node, OWL_1_1.onDataRange.asNode());
                                            if (qualification != null) {
                                                this.monitor.incrementProgress();
                                                c = this.node2term(qualification);
                                                this.defineDatatypeProperty(pt);
                                            } else {
                                                int propType = this.guessPropertyType(pt, p);
                                                if (propType == 1) {
                                                    c = ATermUtils.TOP;
                                                } else if (propType == 2) {
                                                    c = ATermUtils.TOP_LIT;
                                                } else {
                                                    this.defineObjectProperty(pt);
                                                    c = ATermUtils.TOP;
                                                }
                                            }
                                        }
                                        int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                                        aTerm = ATermUtils.makeCard(pt, cardinality, c);
                                        this.addSimpleProperty(pt, CARDINALITY);
                                    }
                                    catch (Exception ex) {
                                        this.addUnsupportedFeature("Invalid value for the cardinality restriction: " + o);
                                    }
                                } else {
                                    this.addUnsupportedFeature("Ignoring invalid cardinality restriction on " + p);
                                }
                            }
                        }
                    }
                }
            }
        }
        return aTerm;
    }

    public ATermAppl node2term(Node node) {
        ATermAppl aTerm = (ATermAppl)this.terms.get(node);
        if (aTerm == null) {
            if (node.isLiteral()) {
                LiteralLabel label = node.getLiteral();
                String value = label.getLexicalForm();
                String datatypeURI = label.getDatatypeURI();
                String lang = label.language();
                aTerm = datatypeURI != null ? ATermUtils.makeTypedLiteral(value, datatypeURI) : ATermUtils.makePlainLiteral(value, lang);
            } else if (this.hasObject(node, OWL.onProperty.asNode())) {
                aTerm = this.createRestriction(node);
                this.restrictions.put(node, aTerm);
            } else if (node.isBlank()) {
                Node o = null;
                o = this.getObject(node, OWL.intersectionOf.asNode());
                if (o != null) {
                    this.monitor.incrementProgress();
                    ATermList list = this.createList(o);
                    aTerm = ATermUtils.makeAnd(list);
                } else {
                    o = this.getObject(node, OWL.unionOf.asNode());
                    if (o != null) {
                        this.monitor.incrementProgress();
                        ATermList list = this.createList(o);
                        aTerm = ATermUtils.makeOr(list);
                    } else {
                        o = this.getObject(node, OWL_1_1.disjointUnionOf.asNode());
                        if (o != null) {
                            this.monitor.incrementProgress();
                            ATermList list = this.createList(o);
                            aTerm = ATermUtils.makeOr(list);
                        } else {
                            o = this.getObject(node, OWL.oneOf.asNode());
                            if (o != null) {
                                this.monitor.incrementProgress();
                                ATermList list = this.createList(o);
                                ATermList result = ATermUtils.EMPTY_LIST;
                                if (list.isEmpty()) {
                                    aTerm = ATermUtils.BOTTOM;
                                } else {
                                    boolean isDataRange = ATermUtils.isLiteral((ATermAppl)list.getFirst());
                                    ATermList l = list;
                                    while (!l.isEmpty()) {
                                        ATermAppl nominal;
                                        ATermAppl c = (ATermAppl)l.getFirst();
                                        if (PelletOptions.USE_PSEUDO_NOMINALS && !isDataRange) {
                                            nominal = ATermUtils.makeTermAppl(c.getName() + "_nominal");
                                            result = result.insert(nominal);
                                            this.defineIndividual(c);
                                            this.defineClass(nominal);
                                            this.kb.addType(c, nominal);
                                        } else {
                                            nominal = ATermUtils.makeValue(c);
                                            result = result.insert(nominal);
                                        }
                                        l = l.getNext();
                                    }
                                    aTerm = ATermUtils.makeOr(result);
                                }
                            } else {
                                o = this.getObject(node, OWL.complementOf.asNode());
                                if (o != null) {
                                    this.monitor.incrementProgress();
                                    ATermAppl complement = this.node2term(o);
                                    aTerm = ATermUtils.makeNot(complement);
                                } else {
                                    String bNode = "bNode" + node.getBlankNodeId();
                                    aTerm = ATermUtils.makeTermAppl(bNode);
                                }
                            }
                        }
                    }
                }
            } else {
                String uri = node.getURI();
                aTerm = PelletOptions.USE_LOCAL_NAME ? (uri.startsWith("http://www.w3.org/2001/XMLSchema#") ? ATermUtils.makeTermAppl(uri) : ATermUtils.makeTermAppl(URIUtils.getLocalName(uri))) : (PelletOptions.USE_QNAME ? (uri.startsWith("http://www.w3.org/2001/XMLSchema#") ? ATermUtils.makeTermAppl(uri) : ATermUtils.makeTermAppl(qnames.shortForm(uri))) : ATermUtils.makeTermAppl(uri));
            }
            this.terms.put(node, aTerm);
        }
        return aTerm;
    }

    private Datatype defineDataRange(Node s) {
        String name = this.node2term(s).getName();
        DatatypeReasoner dtReasoner = this.kb.getDatatypeReasoner();
        Datatype datatype = UnknownDatatype.instance;
        Node definition = null;
        if (dtReasoner.isDefined(name)) {
            datatype = dtReasoner.getDatatype(name);
        } else {
            definition = this.getObject(s, OWL.oneOf.asNode());
            if (definition != null) {
                ATermList list = this.createList(definition);
                datatype = this.kb.getDatatypeReasoner().enumeration(ATermUtils.listToSet(list));
            } else {
                definition = this.getObject(s, OWL_1_1.complementOf.asNode());
                if (definition != null) {
                    datatype = dtReasoner.negate(this.defineDataRange(definition));
                } else {
                    definition = this.getObject(s, OWL_1_1.dataComplementOf.asNode());
                    if (definition != null) {
                        datatype = dtReasoner.negate(this.defineDataRange(definition));
                    } else {
                        definition = this.getObject(s, OWL_1_1.onDataRange.asNode());
                        if (definition != null) {
                            Datatype d = this.defineDataRange(definition);
                            if (d instanceof XSDAtomicType) {
                                Object value;
                                XSDAtomicType xsdType = (XSDAtomicType)d;
                                boolean noFacet = true;
                                Node facetValue = this.getObject(s, OWL_1_1.minInclusive.asNode());
                                if (facetValue != null) {
                                    value = xsdType.getValue(facetValue.getLiteralLexicalForm(), facetValue.getLiteralDatatypeURI());
                                    if (value != null) {
                                        xsdType = xsdType.restrictMinInclusive(value);
                                        noFacet = false;
                                    } else {
                                        this.addUnsupportedFeature("Ignoring invalid facet value " + facetValue + " for " + definition);
                                    }
                                }
                                if ((facetValue = this.getObject(s, OWL_1_1.maxInclusive.asNode())) != null) {
                                    value = xsdType.getValue(facetValue.getLiteralLexicalForm(), facetValue.getLiteralDatatypeURI());
                                    if (value != null) {
                                        xsdType = xsdType.restrictMaxInclusive(value);
                                        noFacet = false;
                                    } else {
                                        this.addUnsupportedFeature("Ignoring invalid facet value " + facetValue + " for " + definition);
                                    }
                                }
                                if ((facetValue = this.getObject(s, OWL_1_1.minExclusive.asNode())) != null) {
                                    value = xsdType.getValue(facetValue.getLiteralLexicalForm(), facetValue.getLiteralDatatypeURI());
                                    if (value != null) {
                                        xsdType = xsdType.restrictMinExclusive(value);
                                        noFacet = false;
                                    } else {
                                        this.addUnsupportedFeature("Ignoring invalid facet value " + facetValue + " for data range " + definition);
                                    }
                                }
                                if ((facetValue = this.getObject(s, OWL_1_1.maxExclusive.asNode())) != null) {
                                    value = xsdType.getValue(facetValue.getLiteralLexicalForm(), facetValue.getLiteralDatatypeURI());
                                    if (value != null) {
                                        xsdType = xsdType.restrictMaxExclusive(value);
                                        noFacet = false;
                                    } else {
                                        this.addUnsupportedFeature("Ignoring invalid facet value " + facetValue + " for " + definition);
                                    }
                                }
                                if ((facetValue = this.getObject(s, OWL_1_1.totalDigits.asNode())) != null) {
                                    try {
                                        int value2 = Integer.parseInt(facetValue.getLiteralLexicalForm());
                                        xsdType = xsdType.restrictTotalDigits(value2);
                                        noFacet = false;
                                    }
                                    catch (NumberFormatException e) {
                                        this.addUnsupportedFeature("Ignoring invalid value " + facetValue + " for facet totalDigits in the definition of " + definition);
                                    }
                                }
                                if ((facetValue = this.getObject(s, OWL_1_1.fractionDigits.asNode())) != null) {
                                    try {
                                        int value3 = Integer.parseInt(facetValue.getLiteralLexicalForm());
                                        xsdType = xsdType.restrictFractionDigits(value3);
                                        noFacet = false;
                                    }
                                    catch (NumberFormatException e) {
                                        this.addUnsupportedFeature("Ignoring invalid value " + facetValue + " for facet totalDigits in the definition of " + definition);
                                    }
                                }
                                if ((facetValue = this.getObject(s, OWL_1_1.pattern.asNode())) != null) {
                                    String value4 = facetValue.getLiteralLexicalForm();
                                    xsdType = xsdType.restrictPattern(value4);
                                    noFacet = false;
                                }
                                if (noFacet) {
                                    this.addUnsupportedFeature("A data range is defined without XSD facet restrictions " + s);
                                }
                                datatype = xsdType;
                            } else {
                                this.addUnsupportedFeature("A restriction is defined on an unknown XSD type " + definition);
                            }
                        } else {
                            this.addUnsupportedFeature(name + " is not a valid data range description");
                        }
                    }
                }
            }
        }
        this.kb.addDatatype(name, datatype);
        return datatype;
    }

    private void defineRule(Node node) {
        List head = this.parseAtomList(this.getObject(node, SWRL.head.asNode()));
        List body = this.parseAtomList(this.getObject(node, SWRL.body.asNode()));
        if (head == null || body == null) {
            this.addUnsupportedFeature("Ignoring SWRL rule: " + node);
            return;
        }
        Iterator i = head.iterator();
        while (i.hasNext()) {
            List singletonHead = Collections.singletonList(i.next());
            Rule rule = new Rule(body, singletonHead);
            this.kb.addRule(rule);
        }
    }

    private Term createRuleTerm(Node node) {
        if (!node.isURI()) {
            return null;
        }
        if (this.hasObject(node, RDF.type.asNode(), SWRL.Variable.asNode())) {
            return new Variable(node.getURI());
        }
        return new Constant(node.getURI());
    }

    private List parseAtomList(Node atomList) {
        ArrayList<org.mindswap.pellet.rete.Triple> atoms = new ArrayList<org.mindswap.pellet.rete.Triple>();
        while (!atomList.equals((Object)RDF.nil.asNode())) {
            String atomType = "unsupported atom";
            Node atom = this.getObject(atomList, RDF.first.asNode());
            Term subj = null;
            Term pred = null;
            Term obj = null;
            if (this.hasObject(atom, RDF.type.asNode(), SWRL.ClassAtom.asNode())) {
                atomType = "ClassAtom";
                subj = this.createRuleTerm(this.getObject(atom, SWRL.argument1.asNode()));
                pred = Constant.TYPE;
                obj = this.createRuleTerm(this.getObject(atom, SWRL.classPredicate.asNode()));
            } else if (this.hasObject(atom, RDF.type.asNode(), SWRL.IndividualPropertyAtom.asNode())) {
                atomType = "IndividualPropertyAtom";
                subj = this.createRuleTerm(this.getObject(atom, SWRL.argument1.asNode()));
                pred = this.createRuleTerm(this.getObject(atom, SWRL.propertyPredicate.asNode()));
                obj = this.createRuleTerm(this.getObject(atom, SWRL.argument2.asNode()));
            } else if (this.hasObject(atom, RDF.type.asNode(), SWRL.DifferentIndividualsAtom.asNode())) {
                atomType = "DifferentIndividualsAtom";
                subj = this.createRuleTerm(this.getObject(atom, SWRL.argument1.asNode()));
                pred = Constant.DIFF_FROM;
                obj = this.createRuleTerm(this.getObject(atom, SWRL.argument2.asNode()));
            } else if (this.hasObject(atom, RDF.type.asNode(), SWRL.SameIndividualsAtom.asNode())) {
                atomType = "SameIndividualsAtom";
                subj = this.createRuleTerm(this.getObject(atom, SWRL.argument1.asNode()));
                pred = Constant.SAME_AS;
                obj = this.createRuleTerm(this.getObject(atom, SWRL.argument2.asNode()));
            } else if (this.hasObject(atom, RDF.type.asNode(), SWRL.DatavaluedPropertyAtom.asNode())) {
                atomType = "DatavaluedPropertyAtom";
            } else if (this.hasObject(atom, RDF.type.asNode(), SWRL.BuiltinAtom.asNode())) {
                atomType = "BuiltinAtom";
            }
            if (subj == null || pred == null || obj == null) {
                this.addUnsupportedFeature("Ignoring SWRL " + atomType + ": " + atom);
                return null;
            }
            atoms.add(new org.mindswap.pellet.rete.Triple(subj, pred, obj));
            atomList = this.getObject(atomList, RDF.rest.asNode());
        }
        return atoms;
    }

    private boolean addNegatedAssertion(Node stmt, boolean object) {
        Node s = this.getObject(stmt, RDF.subject.asNode());
        if (s == null) {
            this.addUnsupportedFeature("Negated property value is missing rdf:subject value");
            return false;
        }
        Node p = this.getObject(stmt, RDF.predicate.asNode());
        if (p == null) {
            this.addUnsupportedFeature("Negated property value is missing rdf:predicate value");
            return false;
        }
        Node o = this.getObject(stmt, RDF.object.asNode());
        if (o == null) {
            this.addUnsupportedFeature("Negated property value is missing rdf:object value");
            return false;
        }
        ATermAppl st = this.node2term(s);
        ATermAppl pt = this.node2term(p);
        ATermAppl ot = this.node2term(o);
        this.defineIndividual(st);
        if (object) {
            this.defineObjectProperty(pt);
        } else {
            this.defineDatatypeProperty(pt);
        }
        if (object) {
            this.defineIndividual(ot);
        }
        if (!this.kb.addNegatedPropertyValue(pt, st, ot)) {
            this.addUnsupportedFeature("Skipping invalid negated property value " + stmt);
            return false;
        }
        return true;
    }

    private boolean defineClass(ATermAppl c) {
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addClass(c);
            return true;
        }
        return ATermUtils.isComplexClass(c);
    }

    private boolean defineDatatype(ATermAppl datatypeURI) {
        this.kb.addDatatype(datatypeURI);
        return true;
    }

    private boolean loadDatatype(ATermAppl datatypeURI) {
        if (PelletOptions.AUTO_XML_SCHEMA_LOADING) {
            this.kb.loadDatatype(datatypeURI);
        } else {
            this.defineDatatype(datatypeURI);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean defineProperties(ATermAppl p1, ATermAppl p2) {
        int type2;
        int type1 = this.kb.getPropertyType(p1);
        if (type1 != (type2 = this.kb.getPropertyType(p2))) {
            if (type1 == 0) {
                if (type2 == 1) {
                    this.defineObjectProperty(p1);
                    return true;
                } else {
                    if (type2 != 2) return true;
                    this.defineDatatypeProperty(p1);
                }
                return true;
            } else {
                if (type2 != 0) return false;
                if (type1 == 1) {
                    this.defineObjectProperty(p2);
                    return true;
                } else {
                    if (type1 != 2) return true;
                    this.defineDatatypeProperty(p2);
                }
            }
            return true;
        } else {
            if (type1 != 0) return true;
            this.defineProperty(p1);
            this.defineProperty(p2);
        }
        return true;
    }

    private boolean defineObjectProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        return this.kb.addObjectProperty(c);
    }

    private boolean defineDatatypeProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        return this.kb.addDatatypeProperty(c);
    }

    private boolean defineAnnotationProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        return this.kb.addAnnotationProperty(c);
    }

    private boolean defineOntologyProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        this.kb.addOntologyProperty(c);
        return true;
    }

    private boolean defineProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        this.kb.addProperty(c);
        return true;
    }

    private boolean defineIndividual(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        this.kb.addIndividual(c);
        return true;
    }

    private int guessPropertyType(ATermAppl p, Node prop) {
        int roleType = this.kb.getPropertyType(p);
        if (roleType != 0) {
            return roleType;
        }
        this.defineProperty(p);
        ExtendedIterator i = this.graph.find(prop, RDF.type.asNode(), null);
        if (i.hasNext()) {
            Triple stmt = (Triple)i.next();
            Node o = stmt.getObject();
            if (o.equals((Object)OWL.ObjectProperty.asNode())) {
                return 1;
            }
            if (o.equals((Object)OWL.DatatypeProperty.asNode())) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    private void processTypes(Graph model) throws UnsupportedFeatureException {
        ExtendedIterator i = model.find(null, RDF.type.asNode(), null);
        block22: while (i.hasNext()) {
            Triple stmt = (Triple)i.next();
            Node o = stmt.getObject();
            Integer keyword = KEYWORDS.get(o);
            if (keyword == SKIP) continue;
            this.monitor.incrementProgress();
            Node s = stmt.getSubject();
            ATermAppl st = this.node2term(s);
            if (keyword == null) {
                String builtin;
                String nameSpace;
                if (PelletOptions.FREEZE_BUILTIN_NAMESPACES && o.isURI() && (nameSpace = o.getNameSpace()) != null && (builtin = BUILT_IN_NS.get(nameSpace)) != null) {
                    this.addUnsupportedFeature("Ignoring triple with unknown term from " + builtin + " namespace: " + stmt);
                    continue;
                }
                ATermAppl ot = this.node2term(o);
                this.defineIndividual(st);
                this.defineClass(ot);
                this.kb.addType(st, ot);
                continue;
            }
            switch (keyword) {
                case 1: {
                    this.defineProperty(st);
                    continue block22;
                }
                case 2: {
                    this.defineClass(st);
                    continue block22;
                }
                case 3: {
                    this.loadDatatype(st);
                    continue block22;
                }
                case 6: {
                    this.defineClass(st);
                    continue block22;
                }
                case 4: {
                    this.defineIndividual(st);
                    continue block22;
                }
                case 5: {
                    this.defineIndividual(st);
                    this.kb.addType(st, ATermUtils.BOTTOM);
                    continue block22;
                }
                case 7: {
                    if (this.defineObjectProperty(st)) continue block22;
                    this.addUnsupportedFeature("Property " + st + " is defined both as an ObjectProperty and a " + Role.TYPES[this.kb.getPropertyType(st)] + "Property");
                    continue block22;
                }
                case 8: {
                    if (this.defineDatatypeProperty(st)) continue block22;
                    this.addUnsupportedFeature("Property " + st + " is defined both as a DatatypeProperty and a " + Role.TYPES[this.kb.getPropertyType(st)] + "Property");
                    continue block22;
                }
                case 9: {
                    this.defineProperty(st);
                    this.kb.addFunctionalProperty(st);
                    this.addSimpleProperty(st, CARDINALITY);
                    continue block22;
                }
                case 10: {
                    if (this.defineProperty(st)) {
                        this.kb.addInverseFunctionalProperty(st);
                        this.addSimpleProperty(st, CARDINALITY);
                        continue block22;
                    }
                    this.addUnsupportedFeature("Ignoring InverseFunctionalProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property)");
                    continue block22;
                }
                case 11: {
                    if (this.defineObjectProperty(st)) {
                        this.kb.addTransitiveProperty(st);
                        continue block22;
                    }
                    this.addUnsupportedFeature("Ignoring TransitiveProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property)");
                    continue block22;
                }
                case 12: {
                    if (this.defineObjectProperty(st)) {
                        this.kb.addSymmetricProperty(st);
                        continue block22;
                    }
                    this.addUnsupportedFeature("Ignoring SymmetricProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property)");
                    continue block22;
                }
                case 13: {
                    if (this.defineAnnotationProperty(st)) continue block22;
                    this.addUnsupportedFeature("Property " + st + " is defined both as an AnnotationProperty and a " + Role.TYPES[this.kb.getPropertyType(st)] + "Property");
                    continue block22;
                }
                case 14: {
                    this.defineDataRange(s);
                    continue block22;
                }
                case 20: {
                    if (this.defineObjectProperty(st)) {
                        this.kb.addReflexiveProperty(st);
                        continue block22;
                    }
                    this.addUnsupportedFeature("Ignoring ReflexiveProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property)");
                    continue block22;
                }
                case 21: {
                    if (this.defineObjectProperty(st)) {
                        this.kb.addIrreflexiveProperty(st);
                        this.addSimpleProperty(st, IRREFLEXIVE);
                        continue block22;
                    }
                    this.addUnsupportedFeature("Ignoring IrreflexiveProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property)");
                    continue block22;
                }
                case 22: {
                    if (this.defineObjectProperty(st)) {
                        this.kb.addAntisymmetricProperty(st);
                        this.addSimpleProperty(st, ANTI_SYM);
                        continue block22;
                    }
                    this.addUnsupportedFeature("Ignoring AntisymmetricProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property)");
                    continue block22;
                }
                case 23: {
                    this.addNegatedAssertion(s, true);
                    continue block22;
                }
                case 24: {
                    this.addNegatedAssertion(s, false);
                    continue block22;
                }
                case 60: {
                    if (!PelletOptions.DL_SAFE_RULES) continue block22;
                    this.defineRule(s);
                    continue block22;
                }
            }
            throw new InternalReasonerException("Unexpected term: " + o);
        }
    }

    private void processTriples(Graph graph) throws UnsupportedFeatureException {
        ExtendedIterator i = graph.find((TripleMatch)Triple.ANY);
        block20: while (i.hasNext()) {
            Triple triple = (Triple)i.next();
            Node p = triple.getPredicate();
            Integer keyword = KEYWORDS.get(p);
            if (keyword == SKIP) continue;
            this.monitor.incrementProgress();
            Node s = triple.getSubject();
            Node o = triple.getObject();
            ATermAppl st = this.node2term(s);
            ATermAppl ot = this.node2term(o);
            if (keyword == null) {
                String builtin;
                String nameSpace;
                ATermAppl pt = this.node2term(p);
                Role role = this.kb.getProperty(pt);
                int type = role == null ? 0 : role.getType();
                if (type == 3) continue;
                if (PelletOptions.FREEZE_BUILTIN_NAMESPACES && (nameSpace = p.getNameSpace()) != null && (builtin = BUILT_IN_NS.get(nameSpace)) != null) {
                    this.addUnsupportedFeature("Ignoring triple with unknown property from " + builtin + " namespace: " + triple);
                    continue;
                }
                if (o.isLiteral()) {
                    if (this.defineDatatypeProperty(pt)) {
                        String datatypeURI = ((ATermAppl)ot.getArgument(2)).getName();
                        if (this.defineIndividual(st)) {
                            this.defineDatatypeProperty(pt);
                            if (!datatypeURI.equals("")) {
                                this.defineDatatype(ATermUtils.makeTermAppl(datatypeURI));
                            }
                            this.kb.addPropertyValue(pt, st, ot);
                            continue;
                        }
                        if (type == 0) {
                            this.defineAnnotationProperty(pt);
                            continue;
                        }
                        this.addUnsupportedFeature("Ignoring ObjectProperty used with a class expression: " + triple);
                        continue;
                    }
                    this.addUnsupportedFeature("Ignoring literal value used with ObjectProperty : " + triple);
                    continue;
                }
                if (!this.defineObjectProperty(pt)) {
                    this.addUnsupportedFeature("Ignoring object value used with DatatypeProperty: " + triple);
                    continue;
                }
                if (!this.defineIndividual(st)) {
                    this.addUnsupportedFeature("Ignoring class expression used in subject position: " + triple);
                    continue;
                }
                if (!this.defineIndividual(ot)) {
                    this.addUnsupportedFeature("Ignoring class expression used in object position: " + triple);
                    continue;
                }
                this.kb.addPropertyValue(pt, st, ot);
                continue;
            }
            switch (keyword) {
                case 25: {
                    if (!this.defineClass(st)) {
                        this.addUnsupportedFeature("Ignoring subClassOf axiom because the subject is not a class " + st + " rdfs:subClassOf " + ot);
                        break;
                    }
                    if (!this.defineClass(ot)) {
                        this.addUnsupportedFeature("Ignoring subClassOf axiom because the object is not a class " + st + " rdfs:subClassOf " + ot);
                        break;
                    }
                    this.kb.addSubClass(st, ot);
                    break;
                }
                case 26: {
                    ATermList list;
                    if (this.hasObject(s, RDF.first.asNode())) {
                        list = this.createList(s);
                        this.kb.addSubProperty(list, ot);
                        break;
                    }
                    if (this.defineProperties(st, ot)) {
                        this.kb.addSubProperty(st, ot);
                        break;
                    }
                    this.addUnsupportedFeature("Ignoring subproperty axiom between " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property) and " + ot + " (" + Role.TYPES[this.kb.getPropertyType(ot)] + "Property)");
                    break;
                }
                case 27: {
                    if (this.kb.isAnnotationProperty(st)) {
                        this.addUnsupportedFeature("Ignoring domain axiom for AnnotationProperty " + st);
                        break;
                    }
                    this.defineProperty(st);
                    this.defineClass(ot);
                    this.kb.addDomain(st, ot);
                    break;
                }
                case 28: {
                    if (this.kb.isAnnotationProperty(st)) {
                        this.addUnsupportedFeature("Ignoring range axiom for AnnotationProperty " + st);
                        break;
                    }
                    if (this.kb.isDatatype(ot)) {
                        this.defineDatatypeProperty(st);
                    } else if (this.kb.isClass(ot)) {
                        this.defineObjectProperty(st);
                    } else {
                        this.defineProperty(st);
                    }
                    if (this.kb.isDatatypeProperty(st)) {
                        this.defineDatatype(ot);
                    } else if (this.kb.isObjectProperty(st)) {
                        this.defineClass(ot);
                    }
                    this.kb.addRange(st, ot);
                    break;
                }
                case 33: {
                    ATermList list;
                    ATermList l = list = this.createList(o);
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        if (!this.resourceLinkTypes.containsKey(c)) {
                            this.defineClass(c);
                        }
                        l = l.getNext();
                    }
                    this.defineClass(st);
                    ATermAppl conjunction = ATermUtils.makeAnd(list);
                    this.kb.addEquivalentClass(st, conjunction);
                    break;
                }
                case 29: {
                    ATermList list = this.createList(o);
                    this.defineClass(st);
                    ATermAppl disjunction = ATermUtils.makeOr(list);
                    this.kb.addEquivalentClass(st, disjunction);
                    break;
                }
                case 40: {
                    ATermList list = this.createList(o);
                    this.kb.addDisjointClasses(list);
                    this.defineClass(st);
                    ATermAppl disjunction = ATermUtils.makeOr(list);
                    this.kb.addEquivalentClass(st, disjunction);
                    break;
                }
                case 39: {
                    if (this.kb.isDatatype(st)) continue block20;
                    if (!this.resourceLinkTypes.containsKey(st)) {
                        this.defineClass(st);
                    }
                    if (!this.resourceLinkTypes.containsKey(st)) {
                        this.defineClass(ot);
                    }
                    this.kb.addComplementClass(st, ot);
                    break;
                }
                case 35: {
                    if (!this.defineClass(st)) {
                        this.addUnsupportedFeature("Ignoring equivalentClass axiom because the subject is not a class " + st + " owl:equivalentClass " + ot);
                        break;
                    }
                    if (!this.defineClass(ot)) {
                        this.addUnsupportedFeature("Ignoring equivalentClass axiom because the object is not a class " + st + " owl:equivalentClass " + ot);
                        break;
                    }
                    this.kb.addEquivalentClass(st, ot);
                    break;
                }
                case 37: {
                    if (!this.defineClass(st)) {
                        this.addUnsupportedFeature("Ignoring disjointWith axiom because the subject is not a class " + st + " owl:disjointWith " + ot);
                        break;
                    }
                    if (!this.defineClass(ot)) {
                        this.addUnsupportedFeature("Ignoring disjointWith axiom because the object is not a class " + st + " owl:disjointWith " + ot);
                        break;
                    }
                    this.kb.addDisjointClass(st, ot);
                    break;
                }
                case 41: {
                    if (this.defineObjectProperty(st) && this.defineObjectProperty(ot)) {
                        this.kb.addDisjointProperty(st, ot);
                        this.addSimpleProperty(st, DISJOINT);
                        this.addSimpleProperty(ot, DISJOINT);
                        break;
                    }
                    this.addUnsupportedFeature("Ignoring subproperty axiom between " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property) and " + ot + " (" + Role.TYPES[this.kb.getPropertyType(ot)] + "Property)");
                    break;
                }
                case 42: {
                    if (this.defineDatatypeProperty(st) && this.defineDatatypeProperty(ot)) {
                        this.kb.addDisjointProperty(st, ot);
                        break;
                    }
                    this.addUnsupportedFeature("Ignoring subproperty axiom between " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property) and " + ot + " (" + Role.TYPES[this.kb.getPropertyType(ot)] + "Property)");
                    break;
                }
                case 34: {
                    if (this.defineProperties(st, ot)) {
                        this.kb.addEquivalentProperty(st, ot);
                        break;
                    }
                    this.addUnsupportedFeature("Ignoring equivalent property axiom between " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property) and " + ot + " (" + Role.TYPES[this.kb.getPropertyType(ot)] + "Property)");
                    break;
                }
                case 32: {
                    if (this.defineObjectProperty(st) && this.defineObjectProperty(ot)) {
                        this.kb.addInverseProperty(st, ot);
                        break;
                    }
                    this.addUnsupportedFeature("Ignoring inverseOf axiom between " + st + " (" + Role.TYPES[this.kb.getPropertyType(st)] + "Property) and " + ot + " (" + Role.TYPES[this.kb.getPropertyType(ot)] + "Property)");
                    break;
                }
                case 30: {
                    if (this.defineIndividual(st) && this.defineIndividual(ot)) {
                        this.kb.addSame(st, ot);
                        break;
                    }
                    this.addUnsupportedFeature("Ignoring sameAs axiom between " + st + " and " + ot);
                    break;
                }
                case 38: {
                    if (this.defineIndividual(st) && this.defineIndividual(ot)) {
                        this.kb.addDifferent(st, ot);
                        break;
                    }
                    this.addUnsupportedFeature("Ignoring differentFrom axiom between " + st + " and " + ot);
                    break;
                }
                case 36: {
                    ATermList list;
                    ArrayList<ATermAppl> result = new ArrayList<ATermAppl>();
                    ATermList l = list = this.createList(o);
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        this.defineIndividual(c);
                        result.add(c);
                        l = l.getNext();
                    }
                    for (int k = 0; k < result.size(); ++k) {
                        for (int j = k + 1; j < result.size(); ++j) {
                            this.kb.addDifferent((ATermAppl)result.get(k), (ATermAppl)result.get(j));
                        }
                    }
                    continue block20;
                }
                case 31: {
                    ATermList resultList = ATermUtils.EMPTY_LIST;
                    if (this.kb.isDatatype(st)) continue block20;
                    this.defineClass(st);
                    ATermAppl disjunction = null;
                    ATermList list = this.createList(o);
                    if (o.equals((Object)RDF.nil)) {
                        disjunction = ATermUtils.BOTTOM;
                    } else {
                        ATermList l = list;
                        while (!l.isEmpty()) {
                            ATermAppl c = (ATermAppl)l.getFirst();
                            if (PelletOptions.USE_PSEUDO_NOMINALS) {
                                ATermAppl nominal = ATermUtils.makeTermAppl(c.getName() + "_nominal");
                                resultList = resultList.insert(nominal);
                                this.defineClass(nominal);
                                this.defineIndividual(c);
                                this.kb.addType(c, nominal);
                            } else {
                                this.defineIndividual(c);
                                resultList = resultList.insert(ATermUtils.makeValue(c));
                            }
                            l = l.getNext();
                        }
                        disjunction = ATermUtils.makeOr(resultList);
                    }
                    this.kb.addEquivalentClass(st, disjunction);
                    break;
                }
                default: {
                    throw new InternalReasonerException("Unrecognized term: " + p);
                }
            }
        }
    }

    private void processUntypedResources() {
        for (Node node : this.restrictions.keySet()) {
            Node o = null;
            o = this.getObject(node, OWL.onProperty.asNode());
            if (o != null) {
                ATermAppl prop = this.node2term(o);
                this.defineProperty(prop);
                if (this.kb.isDatatypeProperty(prop)) {
                    o = this.getObject(node, OWL.someValuesFrom.asNode());
                    if (o != null) {
                        this.defineDatatype(this.node2term(o));
                    } else {
                        o = this.getObject(node, OWL.allValuesFrom.asNode());
                        if (o != null) {
                            this.defineDatatype(this.node2term(o));
                        }
                    }
                }
            }
            if ((o = this.getObject(node, OWL.hasValue.asNode())) == null || o.isLiteral()) continue;
            this.defineIndividual(this.node2term(o));
        }
        for (Role r : new ArrayList<Role>(this.kb.getRBox().getRoles())) {
            Object why = this.simpleProperties.get(r.getName());
            if (why != null) {
                String msg = null;
                if (r.isTransitive()) {
                    msg = "transitivity axiom";
                } else if (r.hasComplexSubRole()) {
                    msg = "complex sub property axiom";
                }
                if (msg != null) {
                    msg = "Ignoring " + msg + " due to an existing " + why + " for property " + r;
                    this.addUnsupportedFeature(msg);
                    r.removeSubRoleChains();
                }
            }
            if (!r.isUntypedRole()) continue;
            boolean rangeToDatatype = false;
            MultiIterator j = new MultiIterator(r.getSubRoles().iterator(), r.getSuperRoles().iterator());
            block6: while (j.hasNext()) {
                Role sub = (Role)j.next();
                switch (sub.getType()) {
                    case 1: {
                        this.defineObjectProperty(r.getName());
                        continue block6;
                    }
                    case 2: {
                        this.defineDatatypeProperty(r.getName());
                        rangeToDatatype = true;
                        continue block6;
                    }
                }
            }
            Set ranges = r.getRanges();
            if (ranges == null) continue;
            if (rangeToDatatype) {
                for (ATermAppl range : ranges) {
                    if (range.getAFun().getArity() != 0 || this.kb.isDatatype(range)) continue;
                    this.defineDatatype(range);
                }
                continue;
            }
            for (ATermAppl range : ranges) {
                if (range.getAFun().getArity() != 0 || this.kb.isClass(range)) continue;
                this.defineClass(range);
            }
        }
    }

    private void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    public void load(Graph graph, KnowledgeBase kb) throws UnsupportedFeatureException {
        Timer timer = kb.timers.startTimer("load");
        this.monitor.setProgressTitle("Loading");
        this.monitor.setProgressLength(graph.size());
        this.monitor.taskStarted();
        this.clear();
        this.setGraph(graph);
        this.setKB(kb);
        this.resourceLinkTypes = new HashMap();
        this.defineAnnotationProperty(this.node2term(RDFS.label.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.comment.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.seeAlso.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.isDefinedBy.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.versionInfo.asNode()));
        this.defineAnnotationProperty(this.node2term(DC.title.asNode()));
        this.defineAnnotationProperty(this.node2term(DC.description.asNode()));
        this.defineOntologyProperty(this.node2term(OWL.backwardCompatibleWith.asNode()));
        this.defineOntologyProperty(this.node2term(OWL.priorVersion.asNode()));
        this.defineOntologyProperty(this.node2term(OWL.incompatibleWith.asNode()));
        this.processTypes(graph);
        this.processTriples(graph);
        this.processUntypedResources();
        this.monitor.taskFinished();
        timer.stop();
    }

    static {
        int i;
        log = LogFactory.getLog(OWLLoader.class);
        BUILT_IN_NS = new HashMap<String, String>();
        BUILT_IN_NS.put("http://www.w3.org/2002/07/owl#", "OWL");
        BUILT_IN_NS.put("http://www.w3.org/2006/12/owl11#", "OWL 1.1");
        BUILT_IN_NS.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
        BUILT_IN_NS.put("http://www.w3.org/2000/01/rdf-schema#", "RDFS");
        BUILT_IN_NS.put("http://www.w3.org/2001/XMLSchema#", "XSD");
        SKIP_PROPS = new Property[]{RDF.type, RDF.first, RDF.rest, RDF.subject, RDF.predicate, RDF.object, OWL.imports, OWL.onProperty, OWL.hasValue, OWL.allValuesFrom, OWL.someValuesFrom, OWL.minCardinality, OWL.maxCardinality, OWL.cardinality, OWL.versionInfo, OWL.backwardCompatibleWith, OWL.incompatibleWith, OWL.priorVersion, OWL_1_1.onClass, OWL_1_1.onDataRange, OWL_1_1.minInclusive, OWL_1_1.minExclusive, OWL_1_1.maxInclusive, OWL_1_1.maxExclusive, OWL_1_1.minLength, OWL_1_1.maxLength, OWL_1_1.length, OWL_1_1.totalDigits, OWL_1_1.fractionDigits, OWL_1_1.dataComplementOf, SWRL.argument1, SWRL.argument2, SWRL.body, SWRL.head, SWRL.builtin, SWRL.classPredicate, SWRL.propertyPredicate};
        SKIP_TYPES = new Resource[]{RDF.List, RDF.Statement, OWL.Restriction, OWL.AllDifferent, OWL.Ontology, OWL_1_1.SelfRestriction, SWRL.ClassAtom, SWRL.IndividualPropertyAtom, SWRL.DatavaluedPropertyAtom, SWRL.Variable, SWRL.Builtin, SWRL.SameIndividualsAtom, SWRL.DifferentIndividualsAtom, SWRL.DataRangeAtom, SWRL.AtomList};
        TYPES = new String[]{"Class", "Individual", "Object Property", "Datatype Property", "Datatype"};
        SKIP = new Integer(0);
        SELF = "self restriction";
        CARDINALITY = "cardinality restriction";
        IRREFLEXIVE = "irreflexivity axiom";
        ANTI_SYM = "antisymmetry axiom";
        DISJOINT = "disjointness axioms";
        KEYWORDS = new HashMap<Node, Integer>();
        for (i = 0; i < SKIP_TYPES.length; ++i) {
            KEYWORDS.put(SKIP_TYPES[i].asNode(), SKIP);
        }
        for (i = 0; i < SKIP_PROPS.length; ++i) {
            KEYWORDS.put(SKIP_PROPS[i].asNode(), SKIP);
        }
        if (PelletOptions.IGNORE_DEPRECATED_TERMS) {
            KEYWORDS.put(OWL.DeprecatedClass.asNode(), SKIP);
            KEYWORDS.put(OWL.DeprecatedProperty.asNode(), SKIP);
        } else {
            KEYWORDS.put(OWL.DeprecatedClass.asNode(), new Integer(6));
            KEYWORDS.put(OWL.DeprecatedProperty.asNode(), new Integer(1));
        }
        KEYWORDS.put(RDF.Property.asNode(), new Integer(1));
        KEYWORDS.put(RDFS.Class.asNode(), new Integer(2));
        KEYWORDS.put(RDFS.Datatype.asNode(), new Integer(3));
        KEYWORDS.put(OWL.Thing.asNode(), new Integer(4));
        KEYWORDS.put(OWL.Nothing.asNode(), new Integer(5));
        KEYWORDS.put(OWL.Class.asNode(), new Integer(6));
        KEYWORDS.put(OWL.ObjectProperty.asNode(), new Integer(7));
        KEYWORDS.put(OWL.DatatypeProperty.asNode(), new Integer(8));
        KEYWORDS.put(OWL.FunctionalProperty.asNode(), new Integer(9));
        KEYWORDS.put(OWL.InverseFunctionalProperty.asNode(), new Integer(10));
        KEYWORDS.put(OWL.TransitiveProperty.asNode(), new Integer(11));
        KEYWORDS.put(OWL.SymmetricProperty.asNode(), new Integer(12));
        KEYWORDS.put(OWL.AnnotationProperty.asNode(), new Integer(13));
        KEYWORDS.put(OWL.DataRange.asNode(), new Integer(14));
        KEYWORDS.put(OWL_1_1.ReflexiveProperty.asNode(), new Integer(20));
        KEYWORDS.put(OWL_1_1.IrreflexiveProperty.asNode(), new Integer(21));
        KEYWORDS.put(OWL_1_1.AntisymmetricProperty.asNode(), new Integer(22));
        KEYWORDS.put(RDFS.subClassOf.asNode(), new Integer(25));
        KEYWORDS.put(RDFS.subPropertyOf.asNode(), new Integer(26));
        KEYWORDS.put(RDFS.domain.asNode(), new Integer(27));
        KEYWORDS.put(RDFS.range.asNode(), new Integer(28));
        KEYWORDS.put(OWL.unionOf.asNode(), new Integer(29));
        KEYWORDS.put(OWL.sameAs.asNode(), new Integer(30));
        KEYWORDS.put(OWL.oneOf.asNode(), new Integer(31));
        KEYWORDS.put(OWL.inverseOf.asNode(), new Integer(32));
        KEYWORDS.put(OWL.intersectionOf.asNode(), new Integer(33));
        KEYWORDS.put(OWL.equivalentProperty.asNode(), new Integer(34));
        KEYWORDS.put(OWL.equivalentClass.asNode(), new Integer(35));
        KEYWORDS.put(OWL.distinctMembers.asNode(), new Integer(36));
        KEYWORDS.put(OWL.disjointWith.asNode(), new Integer(37));
        KEYWORDS.put(OWL.differentFrom.asNode(), new Integer(38));
        KEYWORDS.put(OWL.complementOf.asNode(), new Integer(39));
        KEYWORDS.put(OWL_1_1.disjointUnionOf.asNode(), new Integer(40));
        KEYWORDS.put(OWL_1_1.disjointObjectProperties.asNode(), new Integer(41));
        KEYWORDS.put(OWL_1_1.disjointDataProperties.asNode(), new Integer(42));
        KEYWORDS.put(OWL_1_1.NegativeObjectPropertyAssertion.asNode(), new Integer(23));
        KEYWORDS.put(OWL_1_1.NegativeDataPropertyAssertion.asNode(), new Integer(24));
        KEYWORDS.put(SWRL.Imp.asNode(), new Integer(60));
        KEYWORDS.put(SWRL.Imp.asNode(), new Integer(60));
        qnames = new QNameProvider();
    }
}

