/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.owlapi.ConceptConverter;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;

public class AxiomConverter {
    public static Log log = LogFactory.getLog(ABox.class);
    private ConceptConverter converter;
    private OWLDataFactory factory;

    public AxiomConverter(OWLOntology ont, OWLDataFactory factory) {
        this.factory = factory;
        this.converter = new ConceptConverter(ont, factory);
    }

    public OWLAxiom convert(ATermAppl term) {
        Object axiom = null;
        if (term.getAFun().equals(ATermUtils.SAMEFUN)) {
            OWLDescription c1 = (OWLDescription)this.converter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c2 = (OWLDescription)this.converter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
            descriptions.add(c1);
            descriptions.add(c2);
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLEquivalentClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.SUBFUN)) {
            OWLDescription c1 = (OWLDescription)this.converter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c2 = (OWLDescription)this.converter.convert((ATermAppl)term.getArgument(1));
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLSubClassAxiom(c1, c2);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            ATermAppl concept;
            OWLDescription c;
            HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
            ATermList concepts = (ATermList)term.getArgument(0);
            while (!concepts.isEmpty() && (c = (OWLDescription)this.converter.convert(concept = (ATermAppl)concepts.getFirst())) != null) {
                descriptions.add(c);
                concepts = concepts.getNext();
            }
            if (concepts.isEmpty()) {
                axiom = this.factory.getOWLDisjointClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            OWLDescription c1 = (OWLDescription)this.converter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c2 = (OWLDescription)this.converter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
            descriptions.add(c1);
            descriptions.add(c2);
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLDisjointClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.SUBPROPFUN)) {
            OWLObjectProperty p1 = (OWLObjectProperty)this.converter.convert((ATermAppl)term.getArgument(0));
            OWLObjectProperty p2 = (OWLObjectProperty)this.converter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                axiom = this.factory.getOWLSubObjectPropertyAxiom((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2);
            }
        } else if (term.getAFun().equals(ATermUtils.DOMAINFUN)) {
            OWLProperty p = (OWLProperty)this.converter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c = (OWLDescription)this.converter.convert((ATermAppl)term.getArgument(1));
            if (c != null && p != null) {
                axiom = p instanceof OWLObjectProperty ? this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)p, c) : this.factory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)p, c);
            }
        } else if (term.getAFun().equals(ATermUtils.RANGEFUN)) {
            OWLEntity e = (OWLEntity)this.converter.convert((ATermAppl)term.getArgument(1));
            if (e != null) {
                if (e instanceof OWLDescription) {
                    OWLObjectProperty p = (OWLObjectProperty)this.converter.convert((ATermAppl)term.getArgument(0));
                    if (p != null) {
                        axiom = this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)p, (OWLDescription)e);
                    }
                } else {
                    OWLDataProperty p = (OWLDataProperty)this.converter.convert((ATermAppl)term.getArgument(0));
                    if (p != null) {
                        axiom = this.factory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)p, (OWLDataRange)e);
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.INVPROPFUN)) {
            OWLObjectProperty p1 = (OWLObjectProperty)this.converter.convert((ATermAppl)term.getArgument(0));
            OWLObjectProperty p2 = (OWLObjectProperty)this.converter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                axiom = this.factory.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2);
            }
        } else if (term.getAFun().equals(ATermUtils.TRANSITIVEFUN)) {
            OWLObjectProperty p = (OWLObjectProperty)this.converter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                axiom = this.factory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.FUNCTIONALFUN)) {
            OWLProperty p = (OWLProperty)this.converter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                axiom = p instanceof OWLObjectProperty ? this.factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p) : this.factory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            OWLIndividual i = (OWLIndividual)this.converter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c = (OWLDescription)this.converter.convert((ATermAppl)term.getArgument(1));
            if (i != null && c != null) {
                axiom = this.factory.getOWLClassAssertionAxiom(i, c);
            }
        }
        if (axiom == null) {
            log.warn((Object)("Cannot convert to OWLAPI: " + term));
        }
        return axiom;
    }
}

