/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATermAppl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.EntailmentChecker;
import org.mindswap.pellet.owlapi.PelletLoader;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    public static Log log = LogFactory.getLog(Reasoner.class);
    private static final long serialVersionUID = 8438190652175258123L;
    protected KnowledgeBase kb;
    private PelletLoader loader;
    private OWLOntologyManager manager;
    private EntityMapper<OWLIndividual> IND_MAPPER = new EntityMapper<OWLIndividual>(){

        @Override
        public OWLIndividual map(ATermAppl term) {
            return Reasoner.this.manager.getOWLDataFactory().getOWLIndividual(Reasoner.uri(term));
        }
    };
    private EntityMapper<OWLConstant> LIT_MAPPER = new EntityMapper<OWLConstant>(){

        @Override
        public OWLConstant map(ATermAppl term) {
            String value = ((ATermAppl)term.getArgument(0)).getName();
            String lang = ((ATermAppl)term.getArgument(1)).getName();
            ATermAppl datatypeURI = (ATermAppl)term.getArgument(2);
            if (!datatypeURI.equals(ATermUtils.EMPTY)) {
                OWLDataType datatype = (OWLDataType)Reasoner.this.DT_MAPPER.map(datatypeURI);
                return Reasoner.this.manager.getOWLDataFactory().getOWLTypedConstant(value, datatype);
            }
            if (lang.equals("")) {
                return Reasoner.this.manager.getOWLDataFactory().getOWLUntypedConstant(value);
            }
            return Reasoner.this.manager.getOWLDataFactory().getOWLUntypedConstant(value, lang);
        }
    };
    private EntityMapper<OWLObjectProperty> OP_MAPPER = new EntityMapper<OWLObjectProperty>(){

        @Override
        public OWLObjectProperty map(ATermAppl term) {
            return Reasoner.this.manager.getOWLDataFactory().getOWLObjectProperty(Reasoner.uri(term));
        }
    };
    private EntityMapper<OWLDataProperty> DP_MAPPER = new EntityMapper<OWLDataProperty>(){

        @Override
        public OWLDataProperty map(ATermAppl term) {
            return Reasoner.this.manager.getOWLDataFactory().getOWLDataProperty(Reasoner.uri(term));
        }
    };
    private EntityMapper<OWLDataType> DT_MAPPER = new EntityMapper<OWLDataType>(){

        @Override
        public OWLDataType map(ATermAppl term) {
            return Reasoner.this.manager.getOWLDataFactory().getOWLDataType(Reasoner.uri(term));
        }
    };
    private EntityMapper<OWLClass> CLASS_MAPPER = new EntityMapper<OWLClass>(){

        @Override
        public OWLClass map(ATermAppl term) {
            if (term.equals(ATermUtils.TOP)) {
                return Reasoner.this.manager.getOWLDataFactory().getOWLThing();
            }
            if (term.equals(ATermUtils.BOTTOM)) {
                return Reasoner.this.manager.getOWLDataFactory().getOWLNothing();
            }
            return Reasoner.this.manager.getOWLDataFactory().getOWLClass(Reasoner.uri(term));
        }
    };

    private static URI uri(ATermAppl term) {
        if (term.getArity() != 0) {
            throw new OWLRuntimeException("Trying to convert an anonymous term " + term);
        }
        try {
            return new URI(term.getName());
        }
        catch (URISyntaxException x) {
            throw new OWLRuntimeException("Cannot create URI from term " + x);
        }
    }

    public Reasoner() {
        this(null);
    }

    public Reasoner(OWLOntologyManager manager) {
        this.kb = new KnowledgeBase();
        this.loader = new PelletLoader(this.kb);
        this.manager = manager;
        this.loader.setManager(manager);
    }

    public Set allInstancesOf(OWLClass c) {
        return this.getIndividuals((OWLDescription)c, false);
    }

    public Set allTypesOf(OWLIndividual ind) {
        return this.getTypes(ind, false);
    }

    public Set ancestorClassesOf(OWLClass c) {
        return this.getAncestorClasses((OWLDescription)c);
    }

    public Set ancestorClassesOf(OWLDescription c) {
        return this.getAncestorClasses(c);
    }

    public Set ancestorPropertiesOf(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getAncestorProperties((OWLObjectProperty)p);
        }
        if (p instanceof OWLDataProperty) {
            return this.getAncestorProperties((OWLDataProperty)p);
        }
        throw new AssertionError((Object)(p + " is not an Object or Data property"));
    }

    public void classify() {
        this.kb.classify();
    }

    public void clearOntologies() {
        this.loader.clear();
    }

    public Set complementClassesOf(OWLDescription c) {
        return this.getComplementClasses(c);
    }

    public Set descendantClassesOf(OWLClass c) {
        return this.getDescendantClasses((OWLDescription)c);
    }

    public Set descendantClassesOf(OWLDescription c) {
        return this.getDescendantClasses(c);
    }

    public Set descendantPropertiesOf(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getDescendantProperties((OWLObjectProperty)p);
        }
        if (p instanceof OWLDataProperty) {
            return this.getDescendantProperties((OWLDataProperty)p);
        }
        throw new AssertionError((Object)(p + " is not an Object or Data property"));
    }

    public Set disjointClassesOf(OWLDescription c) {
        return this.getDisjointClasses(c);
    }

    public void dispose() {
        this.kb = null;
    }

    public Set domainsOf(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getDomains((OWLObjectProperty)p);
        }
        if (p instanceof OWLDataProperty) {
            return this.getDomains((OWLDataProperty)p);
        }
        throw new AssertionError((Object)(p + " is not an Object or Data property"));
    }

    public Set equivalentClassesOf(OWLClass c) {
        return this.getEquivalentClasses((OWLDescription)c);
    }

    public Set equivalentClassesOf(OWLDescription c) {
        return this.toOWLEntitySet(this.kb.getEquivalentClasses(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set equivalentPropertiesOf(OWLProperty p) {
        return this.getEquivalentProperties(p);
    }

    public Set<Set<OWLClass>> getAncestorClasses(OWLDescription c) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<Set<OWLDataProperty>> getAncestorProperties(OWLDataProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)p)), this.DP_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getAncestorProperties(OWLObjectProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)p)), this.OP_MAPPER);
    }

    public OWLClass getClass(URI uri) {
        return this.manager.getOWLDataFactory().getOWLClass(uri);
    }

    public Set<OWLClass> getClasses() {
        return this.toOWLEntitySet(this.kb.getClasses(), this.CLASS_MAPPER);
    }

    public Set<OWLClass> getComplementClasses(OWLDescription c) {
        return this.toOWLEntitySet(this.kb.getComplements(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<OWLDataProperty> getDataProperties() {
        return this.toOWLEntitySet(this.kb.getDataProperties(), this.DP_MAPPER);
    }

    public OWLDataProperty getDataProperty(URI uri) {
        return this.manager.getOWLDataFactory().getOWLDataProperty(uri);
    }

    public Map getDataPropertyRelationships(OWLIndividual individual) {
        HashMap<OWLDataProperty, Set<OWLConstant>> values = new HashMap<OWLDataProperty, Set<OWLConstant>>();
        Set<OWLDataProperty> dataProps = this.getDataProperties();
        for (OWLDataProperty prop : dataProps) {
            Set<OWLConstant> set = this.getRelatedValues(individual, (OWLDataPropertyExpression)prop);
            if (set.isEmpty()) continue;
            values.put(prop, set);
        }
        return values;
    }

    public Map getDataPropertyValues(OWLIndividual ind) {
        return this.getDataPropertyRelationships(ind);
    }

    public Set<Set<OWLClass>> getDescendantClasses(OWLDescription c) {
        return this.toOWLEntitySetOfSet(this.kb.getSubClasses(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<Set<OWLDataProperty>> getDescendantProperties(OWLDataProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)p), true), this.DP_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getDescendantProperties(OWLObjectProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)p), true), this.OP_MAPPER);
    }

    public Set getDifferentFromIndividuals(OWLIndividual ind) {
        return this.toOWLEntitySet(this.kb.getDifferents(this.loader.term((OWLObject)ind)), this.IND_MAPPER);
    }

    public Set<Set<OWLClass>> getDisjointClasses(OWLDescription c) {
        return this.toOWLEntitySetOfSet(this.kb.getDisjoints(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set getDomains(OWLDataProperty p) {
        return this.toOWLEntitySet(this.kb.getDomains(this.loader.term((OWLObject)p)), this.CLASS_MAPPER);
    }

    public Set getDomains(OWLObjectProperty p) {
        return this.toOWLEntitySet(this.kb.getDomains(this.loader.term((OWLObject)p)), this.CLASS_MAPPER);
    }

    public Set<OWLClass> getEquivalentClasses(OWLDescription c) {
        return this.toOWLEntitySet(this.kb.getEquivalentClasses(this.loader.term((OWLObject)c)), this.CLASS_MAPPER);
    }

    public Set<OWLDataProperty> getEquivalentProperties(OWLDataProperty p) {
        return this.toOWLEntitySet(this.kb.getEquivalentProperties(this.loader.term((OWLObject)p)), this.DP_MAPPER);
    }

    public Set<OWLObjectProperty> getEquivalentProperties(OWLObjectProperty p) {
        return this.toOWLEntitySet(this.kb.getEquivalentProperties(this.loader.term((OWLObject)p)), this.OP_MAPPER);
    }

    public Set getEquivalentProperties(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getEquivalentProperties((OWLObjectProperty)p);
        }
        if (p instanceof OWLDataProperty) {
            return this.getEquivalentProperties((OWLDataProperty)p);
        }
        throw new AssertionError((Object)(p + " is not an Object or Data property"));
    }

    public Set<OWLClass> getInconsistentClasses() {
        return this.toOWLEntitySet(this.kb.getEquivalentClasses(ATermUtils.BOTTOM), this.CLASS_MAPPER);
    }

    public OWLIndividual getIndividual(URI uri) {
        return this.manager.getOWLDataFactory().getOWLIndividual(uri);
    }

    public Set<OWLIndividual> getIndividuals() {
        return this.toOWLEntitySet(this.kb.getIndividuals(), this.IND_MAPPER);
    }

    public Set<OWLIndividual> getIndividuals(OWLDescription clsC, boolean direct) {
        return this.toOWLEntitySet(this.kb.getInstances(this.loader.term((OWLObject)clsC), direct), this.IND_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getInverseProperties(OWLObjectProperty prop) {
        return Collections.singleton(this.toOWLEntitySet(this.kb.getInverses(this.loader.term((OWLObject)prop)), this.OP_MAPPER));
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Set<OWLOntology> getLoadedOntologies() {
        return this.loader.getOntologies();
    }

    public PelletLoader getLoader() {
        return this.loader;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public Set<OWLObjectProperty> getObjectProperties() {
        return this.toOWLEntitySet(this.kb.getObjectProperties(), this.OP_MAPPER);
    }

    public OWLObjectProperty getObjectProperty(URI uri) {
        return this.manager.getOWLDataFactory().getOWLObjectProperty(uri);
    }

    public Map<OWLObjectProperty, Set<OWLIndividual>> getObjectPropertyRelationships(OWLIndividual individual) {
        HashMap<OWLObjectProperty, Set<OWLIndividual>> values = new HashMap<OWLObjectProperty, Set<OWLIndividual>>();
        Set<OWLObjectProperty> objProps = this.getObjectProperties();
        for (OWLObjectProperty prop : objProps) {
            Set<OWLIndividual> set = this.getRelatedIndividuals(individual, (OWLObjectPropertyExpression)prop);
            if (set.isEmpty()) continue;
            values.put(prop, set);
        }
        return values;
    }

    public Map getObjectPropertyValues(OWLIndividual ind) {
        return this.getObjectPropertyRelationships(ind);
    }

    public Set getOntologies() {
        return this.getLoadedOntologies();
    }

    public OWLOntology getOntology() {
        return null;
    }

    public Set<OWLProperty> getProperties() {
        HashSet<OWLProperty> properties = new HashSet<OWLProperty>();
        properties.addAll(this.getObjectProperties());
        properties.addAll(this.getDataProperties());
        return properties;
    }

    public OWLConstant getPropertyValue(OWLIndividual ind, OWLDataProperty prop) {
        return this.getRelatedValue(ind, (OWLDataPropertyExpression)prop);
    }

    public OWLIndividual getPropertyValue(OWLIndividual ind, OWLObjectProperty prop) {
        return this.getRelatedIndividual(ind, (OWLObjectPropertyExpression)prop);
    }

    public Map<OWLIndividual, Set<OWLConstant>> getPropertyValues(OWLDataProperty prop) {
        HashMap<OWLIndividual, Set<OWLConstant>> map = new HashMap<OWLIndividual, Set<OWLConstant>>();
        ATermAppl p = this.loader.term((OWLObject)prop);
        List<ATermAppl> candidates = this.kb.retrieveIndividualsWithProperty(p);
        for (ATermAppl candidate : candidates) {
            List<ATermAppl> list = this.kb.getDataPropertyValues(p, candidate);
            if (list.isEmpty()) continue;
            OWLIndividual subj = this.IND_MAPPER.map(candidate);
            Set<OWLConstant> objects = this.toOWLEntitySet(list, this.LIT_MAPPER);
            map.put(subj, objects);
        }
        return map;
    }

    public Set getPropertyValues(OWLIndividual ind, OWLDataProperty prop) {
        return this.getRelatedValues(ind, (OWLDataPropertyExpression)prop);
    }

    public Set getPropertyValues(OWLIndividual ind, OWLObjectProperty prop) {
        return this.getRelatedIndividuals(ind, (OWLObjectPropertyExpression)prop);
    }

    public Set getPropertyValues(OWLIndividual ind, OWLProperty prop) {
        if (prop instanceof OWLObjectProperty) {
            return this.getRelatedIndividuals(ind, (OWLObjectPropertyExpression)((OWLObjectProperty)prop));
        }
        if (prop instanceof OWLDataProperty) {
            return this.getRelatedValues(ind, (OWLDataPropertyExpression)((OWLDataProperty)prop));
        }
        throw new AssertionError((Object)("Property " + prop + " is neither data nor object property!"));
    }

    public Map<OWLIndividual, Set<OWLIndividual>> getPropertyValues(OWLObjectProperty prop) {
        HashMap<OWLIndividual, Set<OWLIndividual>> result = new HashMap<OWLIndividual, Set<OWLIndividual>>();
        ATermAppl p = this.loader.term((OWLObject)prop);
        Map<ATermAppl, List<ATermAppl>> values = this.kb.getPropertyValues(p);
        for (ATermAppl subjTerm : values.keySet()) {
            List<ATermAppl> objTerms = values.get(subjTerm);
            OWLIndividual subj = this.IND_MAPPER.map(subjTerm);
            Set<OWLIndividual> objects = this.toOWLEntitySet(objTerms, this.IND_MAPPER);
            result.put(subj, objects);
        }
        return result;
    }

    public Map getPropertyValues(OWLProperty prop) {
        if (prop instanceof OWLObjectProperty) {
            return this.getPropertyValues((OWLObjectProperty)prop);
        }
        if (prop instanceof OWLDataProperty) {
            return this.getPropertyValues((OWLDataProperty)prop);
        }
        throw new AssertionError((Object)("Property " + prop + " is neither data nor object property!"));
    }

    public Set getRanges(OWLDataProperty p) {
        return this.toOWLEntitySet(this.kb.getRanges(this.loader.term((OWLObject)p)), this.DT_MAPPER);
    }

    public Set getRanges(OWLObjectProperty p) {
        return this.toOWLEntitySet(this.kb.getRanges(this.loader.term((OWLObject)p)), this.CLASS_MAPPER);
    }

    public OWLIndividual getRelatedIndividual(OWLIndividual subject, OWLObjectPropertyExpression property) {
        Set<OWLIndividual> values = this.getRelatedIndividuals(subject, property);
        return values.isEmpty() ? null : values.iterator().next();
    }

    public Set<OWLIndividual> getRelatedIndividuals(OWLIndividual subject, OWLObjectPropertyExpression property) {
        return this.toOWLEntitySet(this.kb.getObjectPropertyValues(this.loader.term((OWLObject)property), this.loader.term((OWLObject)subject)), this.IND_MAPPER);
    }

    public OWLConstant getRelatedValue(OWLIndividual subject, OWLDataPropertyExpression property) {
        Set<OWLConstant> values = this.getRelatedValues(subject, property);
        return values.isEmpty() ? null : values.iterator().next();
    }

    public Set<OWLConstant> getRelatedValues(OWLIndividual subject, OWLDataPropertyExpression property) {
        return this.toOWLEntitySet(this.kb.getDataPropertyValues(this.loader.term((OWLObject)property), this.loader.term((OWLObject)subject)), this.LIT_MAPPER);
    }

    public Set getSameAsIndividuals(OWLIndividual ind) {
        return this.toOWLEntitySet(this.kb.getSames(this.loader.term((OWLObject)ind)), this.IND_MAPPER);
    }

    public Set<Set<OWLClass>> getSubClasses(OWLDescription c) {
        return this.toOWLEntitySetOfSet(this.kb.getSubClasses(this.loader.term((OWLObject)c), true), this.CLASS_MAPPER);
    }

    public Set<Set<OWLDataProperty>> getSubProperties(OWLDataProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)p), true), this.DP_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getSubProperties(OWLObjectProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)p), true), this.OP_MAPPER);
    }

    public Set<Set<OWLClass>> getSuperClasses(OWLDescription c) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(this.loader.term((OWLObject)c), true), this.CLASS_MAPPER);
    }

    public Set<Set<OWLDataProperty>> getSuperProperties(OWLDataProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)p), true), this.DP_MAPPER);
    }

    public Set<Set<OWLObjectProperty>> getSuperProperties(OWLObjectProperty p) {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)p), true), this.OP_MAPPER);
    }

    public OWLClass getType(OWLIndividual ind) {
        Set<Set<OWLClass>> types = this.getTypes(ind);
        types = types.isEmpty() ? types : types.iterator().next();
        return types.isEmpty() ? null : (OWLClass)types.iterator().next();
    }

    public Set<Set<OWLClass>> getTypes(OWLIndividual individual) {
        return this.toOWLEntitySetOfSet(this.kb.getTypes(this.loader.term((OWLObject)individual), true), this.CLASS_MAPPER);
    }

    public Set<Set<OWLClass>> getTypes(OWLIndividual ind, boolean direct) {
        return this.toOWLEntitySetOfSet(this.kb.getTypes(this.loader.term((OWLObject)ind), direct), this.CLASS_MAPPER);
    }

    public boolean hasDataPropertyRelationship(OWLIndividual subject, OWLDataPropertyExpression property, OWLConstant object) {
        return this.kb.hasPropertyValue(this.loader.term((OWLObject)subject), this.loader.term((OWLObject)property), this.loader.term((OWLObject)object));
    }

    public boolean hasDomain(OWLDataProperty p, OWLDescription c) {
        return this.kb.hasDomain(this.loader.term((OWLObject)p), this.loader.term((OWLObject)c));
    }

    public boolean hasDomain(OWLObjectProperty p, OWLDescription c) {
        return this.kb.hasDomain(this.loader.term((OWLObject)p), this.loader.term((OWLObject)c));
    }

    public boolean hasObjectPropertyRelationship(OWLIndividual subject, OWLObjectPropertyExpression property, OWLIndividual object) {
        return this.kb.hasPropertyValue(this.loader.term((OWLObject)subject), this.loader.term((OWLObject)property), this.loader.term((OWLObject)object));
    }

    public boolean hasPropertyValue(OWLIndividual subj, OWLDataProperty prop, OWLConstant obj) {
        return this.hasDataPropertyRelationship(subj, (OWLDataPropertyExpression)prop, obj);
    }

    public boolean hasPropertyValue(OWLIndividual subj, OWLObjectProperty prop, OWLIndividual obj) {
        return this.hasObjectPropertyRelationship(subj, (OWLObjectPropertyExpression)prop, obj);
    }

    public boolean hasRange(OWLDataProperty p, OWLDataRange d) {
        return this.kb.hasRange(this.loader.term((OWLObject)p), this.loader.term((OWLObject)d));
    }

    public boolean hasRange(OWLObjectProperty p, OWLDescription c) {
        return this.kb.hasRange(this.loader.term((OWLObject)p), this.loader.term((OWLObject)c));
    }

    public boolean hasType(OWLIndividual individual, OWLDescription type) {
        return this.kb.isType(this.loader.term((OWLObject)individual), this.loader.term((OWLObject)type));
    }

    public boolean hasType(OWLIndividual individual, OWLDescription type, boolean direct) throws OWLReasonerException {
        if (direct) {
            return this.getTypes(individual, direct).contains(type);
        }
        return this.hasType(individual, type);
    }

    public Set instancesOf(OWLClass c) {
        return this.getIndividuals((OWLDescription)c, false);
    }

    public Set instancesOf(OWLDescription d) {
        return this.getIndividuals(d, false);
    }

    public Set inversePropertiesOf(OWLObjectProperty prop) {
        return this.getInverseProperties(prop);
    }

    public boolean isAntiSymmetric(OWLObjectProperty p) {
        return this.kb.isAntisymmetricProperty(this.loader.term((OWLObject)p));
    }

    public boolean isClassified() {
        return this.kb.isClassified();
    }

    public boolean isComplementOf(OWLDescription c1, OWLDescription c2) {
        return this.kb.isComplement(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isConsistent() {
        return this.kb.isConsistent();
    }

    public boolean isConsistent(OWLDescription d) {
        return this.isSatisfiable(d);
    }

    public boolean isConsistent(OWLOntology ontology) {
        this.setOntology(ontology);
        return this.isConsistent();
    }

    public boolean isDefined(OWLClass cls) {
        ATermAppl term = this.loader.term((OWLObject)cls);
        return this.kb.isClass(term);
    }

    public boolean isDefined(OWLDataProperty prop) {
        ATermAppl term = this.loader.term((OWLObject)prop);
        return this.kb.isDatatypeProperty(term);
    }

    public boolean isDefined(OWLIndividual ind) {
        ATermAppl term = this.loader.term((OWLObject)ind);
        return this.kb.isObjectProperty(term);
    }

    public boolean isDefined(OWLObjectProperty prop) {
        ATermAppl term = this.loader.term((OWLObject)prop);
        return this.kb.isObjectProperty(term);
    }

    public boolean isDifferentFrom(OWLIndividual ind1, OWLIndividual ind2) {
        return this.kb.isDifferentFrom(this.loader.term((OWLObject)ind1), this.loader.term((OWLObject)ind2));
    }

    public boolean isDisjointWith(OWLDataProperty p1, OWLDataProperty p2) {
        return this.kb.isDisjoint(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isDisjointWith(OWLDescription c1, OWLDescription c2) {
        return this.kb.isDisjointClass(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isDisjointWith(OWLObjectProperty p1, OWLObjectProperty p2) {
        return this.kb.isDisjointProperty(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isEntailed(OWLOntology ont) {
        return this.isEntailed(ont.getAxioms());
    }

    public boolean isEntailed(Set axioms) {
        if (axioms.isEmpty()) {
            log.warn((Object)"Empty ontologies are entailed by any premise document!");
        } else {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            for (OWLAxiom axiom : axioms) {
                if (entailmentChecker.isEntailed(axiom)) continue;
                log.warn((Object)("Axiom not entailed: (" + axiom + ")"));
                return false;
            }
        }
        return true;
    }

    public boolean isEntailed(OWLAxiom axiom) {
        EntailmentChecker entailmentChecker = new EntailmentChecker(this);
        return entailmentChecker.isEntailed(axiom);
    }

    public boolean isEquivalentClass(OWLDescription c1, OWLDescription c2) {
        return this.kb.isEquivalentClass(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isEquivalentProperty(OWLDataProperty p1, OWLDataProperty p2) {
        return this.kb.isEquivalentProperty(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isEquivalentProperty(OWLObjectProperty p1, OWLObjectProperty p2) {
        return this.kb.isEquivalentProperty(this.loader.term((OWLObject)p1), this.loader.term((OWLObject)p2));
    }

    public boolean isFunctional(OWLDataProperty p) {
        return this.kb.isFunctionalProperty(this.loader.term((OWLObject)p));
    }

    public boolean isFunctional(OWLObjectProperty p) {
        return this.kb.isFunctionalProperty(this.loader.term((OWLObject)p));
    }

    public boolean isInstanceOf(OWLIndividual ind, OWLClass c) {
        return this.hasType(ind, (OWLDescription)c);
    }

    public boolean isInstanceOf(OWLIndividual ind, OWLDescription d) {
        return this.hasType(ind, d);
    }

    public boolean isInverseFunctional(OWLObjectProperty p) {
        return this.kb.isInverseFunctionalProperty(this.loader.term((OWLObject)p));
    }

    public boolean isIrreflexive(OWLObjectProperty p) {
        return this.kb.isIrreflexiveProperty(this.loader.term((OWLObject)p));
    }

    public boolean isRealised() throws OWLReasonerException {
        return this.kb.isRealized();
    }

    public boolean isReflexive(OWLObjectProperty p) {
        return this.kb.isReflexiveProperty(this.loader.term((OWLObject)p));
    }

    public boolean isSameAs(OWLIndividual ind1, OWLIndividual ind2) {
        return this.kb.isSameAs(this.loader.term((OWLObject)ind1), this.loader.term((OWLObject)ind2));
    }

    public boolean isSatisfiable(OWLDescription d) {
        if (!this.kb.isConsistent()) {
            return false;
        }
        return this.kb.isSatisfiable(this.loader.term((OWLObject)d));
    }

    public boolean isSubClassOf(OWLDescription c1, OWLDescription c2) {
        return this.kb.isSubClassOf(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isSubPropertyOf(OWLDataProperty c1, OWLDataProperty c2) {
        return this.kb.isSubPropertyOf(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isSubPropertyOf(OWLObjectProperty c1, OWLObjectProperty c2) {
        return this.kb.isSubPropertyOf(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isSubTypeOf(OWLDataType d1, OWLDataType d2) {
        return this.kb.isSubClassOf(this.loader.term((OWLObject)d1), this.loader.term((OWLObject)d2));
    }

    public boolean isSymmetric(OWLObjectProperty p) {
        return this.kb.isSymmetricProperty(this.loader.term((OWLObject)p));
    }

    public boolean isTransitive(OWLObjectProperty p) {
        return this.kb.isTransitiveProperty(this.loader.term((OWLObject)p));
    }

    public void loadOntologies(Set<OWLOntology> ontologies) {
        if (this.manager == null) {
            log.warn((Object)"Cannot load an ontology without an ontology manager. Use setManager(OWLOntologyManager) first.");
            return;
        }
        this.loader.load(ontologies);
    }

    public void loadOntologies(OWLOntology ontology) {
        this.loadOntology(ontology);
    }

    public void loadOntology(OWLOntology ontology) {
        this.loadOntologies(Collections.singleton(ontology));
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        boolean changesApplied = this.loader.applyChanges(changes);
        if (!changesApplied) {
            this.refresh();
        }
    }

    public Set rangesOf(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getRanges((OWLObjectProperty)p);
        }
        if (p instanceof OWLDataProperty) {
            return this.getRanges((OWLDataProperty)p);
        }
        throw new AssertionError((Object)(p + " is not an Object or Data property"));
    }

    public void realise() throws OWLReasonerException {
        this.kb.realize();
    }

    public void refresh() {
        this.loader.reload();
    }

    public void refreshOntology() {
        this.refresh();
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
        this.loader.setManager(manager);
    }

    public void setOntology(OWLOntology ontology) {
        this.clearOntologies();
        this.loadOntologies(Collections.singleton(ontology));
    }

    public Set subClassesOf(OWLClass c) {
        return this.getSubClasses((OWLDescription)c);
    }

    public Set subClassesOf(OWLDescription c) {
        return this.getSubClasses(c);
    }

    public Set subPropertiesOf(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getSubProperties((OWLObjectProperty)p);
        }
        if (p instanceof OWLDataProperty) {
            return this.getSubProperties((OWLDataProperty)p);
        }
        throw new AssertionError((Object)(p + " is not an Object or Data property"));
    }

    public Set superClassesOf(OWLClass c) {
        return this.getSuperClasses((OWLDescription)c);
    }

    public Set superClassesOf(OWLDescription c) {
        return this.getSuperClasses(c);
    }

    public Set superPropertiesOf(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getSuperProperties((OWLObjectProperty)p);
        }
        if (p instanceof OWLDataProperty) {
            return this.getSuperProperties((OWLDataProperty)p);
        }
        throw new AssertionError((Object)(p + " is not an Object or Data property"));
    }

    private <T extends OWLObject> Set<Set<T>> toOWLEntitySetOfSet(Set<Set<ATermAppl>> setOfTerms, EntityMapper<T> mapper) {
        HashSet<Set<T>> results = new HashSet<Set<T>>();
        for (Set<ATermAppl> terms : setOfTerms) {
            Set<T> entitySet = this.toOWLEntitySet(terms, mapper);
            if (entitySet.isEmpty()) continue;
            results.add(entitySet);
        }
        return results;
    }

    private <T extends OWLObject> Set<T> toOWLEntitySet(Collection<ATermAppl> terms, EntityMapper<T> mapper) {
        HashSet<T> results = new HashSet<T>();
        for (ATermAppl term : terms) {
            results.add(mapper.map(term));
        }
        return results;
    }

    public OWLClass typeOf(OWLIndividual ind) {
        return this.getType(ind);
    }

    public Set typesOf(OWLIndividual ind) {
        return this.getTypes(ind);
    }

    public void unloadOntologies(Set<OWLOntology> ontologies) {
        this.loader.unload(ontologies);
        this.refresh();
    }

    public void unloadOntology(OWLOntology ontology) {
        this.unloadOntologies(Collections.singleton(ontology));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EntityMapper<T extends OWLObject> {
        public T map(ATermAppl var1);
    }
}

