/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryParser;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.utils.AlphaNumericComparator;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class PelletQueryTest {
    public static boolean SIZE_ESTIMATE_ALL = true;
    private boolean formatHTML = false;
    private boolean detailedTime;
    private boolean printOnlyNumbers = false;
    private boolean classify;
    private boolean realize;
    private boolean printQuery;
    private int limit = 100;
    private int queryIndex = -1;
    private Timers timers = new Timers();
    private QueryParser parser = QueryEngine.createParser();

    public boolean isPrintQuery() {
        return this.printQuery;
    }

    public void setPrintQuery(boolean printQuery) {
        this.printQuery = printQuery;
    }

    public boolean isClassify() {
        return this.classify;
    }

    public void setClassify(boolean classify) {
        this.classify = classify;
    }

    public boolean isRealize() {
        return this.realize;
    }

    public void setRealize(boolean realize) {
        this.realize = realize;
    }

    public boolean isQuiet() {
        return this.printOnlyNumbers;
    }

    public void setQuiet(boolean quiet) {
        this.printOnlyNumbers = quiet;
    }

    public boolean isFormatHTML() {
        return this.formatHTML;
    }

    public void setFormatHTML(boolean formatHTML) {
        this.formatHTML = formatHTML;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isDetailedTime() {
        return this.detailedTime;
    }

    public void setDetailedTime(boolean detailedTime) {
        this.detailedTime = detailedTime;
    }

    public int getQueryIndex() {
        return this.queryIndex;
    }

    public void setQueryIndex(int queryIndex) {
        this.queryIndex = queryIndex - 1;
    }

    public void run(String queryLoc, String data) throws Exception {
        Timer t = null;
        KnowledgeBase kb = null;
        kb = this.loadData(data);
        Query[] queries = this.readQueries(kb, queryLoc);
        long queryPrepareTime = 0L;
        if (SIZE_ESTIMATE_ALL) {
            t = this.timers.startTimer("queryPrepare");
            kb.getSizeEstimate().computeAll();
            t.stop();
            queryPrepareTime = t.getLast();
        }
        long parseTime = this.timers.getTimerTotal("parse");
        long consTime = this.timers.getTimerTotal("consistency");
        long classifyTime = this.timers.getTimerTotal("classify");
        long totalSetupTime = consTime + classifyTime + queryPrepareTime;
        System.out.println("Parsing/Loading  : " + parseTime);
        System.out.println("Consistency      : " + consTime);
        System.out.println("Classify         : " + classifyTime);
        System.out.println("Query Prepare    : " + queryPrepareTime);
        System.out.println("Total Setup      : " + totalSetupTime);
        TableData table = new TableData(Arrays.asList("No", "Answers", "Time"));
        table.setAlignment(new boolean[]{false, true, true});
        table.add(Arrays.asList("Consistency", "", "" + consTime));
        table.add(Arrays.asList("Classify", "", "" + classifyTime));
        table.add(Arrays.asList("Query Prepare", "", "" + queryPrepareTime));
        table.add(Arrays.asList("Total Setup", "", "" + totalSetupTime));
        for (int j = 0; j < queries.length; ++j) {
            if (this.queryIndex != -1 && j != this.queryIndex) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add("Q" + (j + 1));
            if (queries.length > 1) {
                System.out.println("Query (" + (j + 1) + ")");
            }
            Query query = queries[j];
            if (this.printQuery) {
                System.out.println(query);
            }
            t = this.timers.startTimer("query");
            if (!SIZE_ESTIMATE_ALL) {
                QueryEngine.prepare(query);
            }
            QueryResults results = QueryEngine.exec(query);
            t.stop();
            long queryTime = t.getLast();
            if (!this.printOnlyNumbers) {
                System.out.println(results);
            }
            int count = results.size();
            System.out.println("Number of answers: " + count);
            row.add(String.valueOf(count));
            row.add(String.valueOf(queryTime));
            table.add(row);
            System.out.println();
        }
        System.out.println(table);
        if (this.detailedTime) {
            System.out.println();
            System.out.println("Detailed timing about reasoner internals:");
            kb.timers.print();
        }
    }

    public KnowledgeBase loadData(String sourceURL) throws Exception {
        KnowledgeBase kb = this.readData(sourceURL);
        Timer t = this.timers.startTimer("consistency");
        kb.isConsistent();
        t.stop();
        if (this.classify) {
            t = this.timers.startTimer("classify");
            kb.classify();
            t.stop();
        }
        if (this.realize) {
            t = this.timers.startTimer("realize");
            kb.realize();
            t.stop();
        }
        return kb;
    }

    public KnowledgeBase readData(String sourceURL) throws Exception {
        Timer t = this.timers.startTimer("parse");
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.setDiscardJenaGraph(true);
        ModelReader reader = new ModelReader();
        long triples = 0L;
        URL url = new URL(sourceURL);
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getPath());
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return dir != null && name.endsWith(".owl");
                        }
                    });
                    Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
                    int size = files.length > this.limit ? this.limit : files.length;
                    System.out.print("Reading " + size + " data files");
                    for (int j = 0; j < size; ++j) {
                        String fileURI = files[j].toURI().toString();
                        System.out.print(".");
                        Model model = reader.read(fileURI);
                        triples += model.size();
                        reasoner.load(model);
                    }
                    System.out.println("done");
                } else {
                    Model model = reader.read(sourceURL);
                    triples += model.size();
                    reasoner.load(model);
                }
            }
        } else {
            Model model = reader.read(sourceURL);
            triples += model.size();
            reasoner.load(model);
        }
        System.out.println(triples + " triples");
        t.stop();
        return reasoner.getKB();
    }

    private String ensureFilePath(String str) {
        try {
            URL url = new URL(str);
            return url.getPath();
        }
        catch (MalformedURLException e) {
            return str;
        }
    }

    public Query[] readQueries(KnowledgeBase kb, String loc) throws Exception {
        ArrayList<Object> queries = new ArrayList<Object>();
        File file = new File(this.ensureFilePath(loc));
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return dir != null && name.endsWith(".sparql");
                    }
                });
                Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
                int size = files.length;
                System.out.print("Reading " + size + " queries");
                for (int j = 0; j < size; ++j) {
                    System.out.print(".");
                    String queryStr = FileUtils.readFile(files[j]);
                    Query query = this.parser.parse(queryStr, kb);
                    queries.add(query);
                }
                System.out.println("done.");
            } else {
                String query = FileUtils.readFile(file);
                queries.add(query);
            }
        }
        return queries.toArray(new Query[queries.size()]);
    }

    public static void usage() {
        System.out.println("PelletQuery");
        System.out.println("");
        System.out.println("Reads one (or more) SPARQL queries from an input file (or directory)");
        System.out.println("and runs each one. Data is loaded once and then all queries are");
        System.out.println("executed consecutively.");
        System.out.println("");
        System.out.println("usage: java PelletQuery OPTIONS -d <data> -q <query>");
        System.out.println("  -d <data>     URI for an ontology or a directory that contains multiple");
        System.out.println("                ontologies");
        System.out.println("  -l <limit>    If a directory is given for data do not load more than");
        System.out.println("                <limit> ontologies");
        System.out.println("  -q <query>    Either a file containing a SPARQL query or a directory");
        System.out.println("                that contains multiple such files)");
        System.out.println("  -p            Print the query before printing answers");
        System.out.println("  -n            Print only the number of answers not the actual answers");
        System.out.println("  -t            Print detailed time information");
        System.out.println("  -c[r]         Classify the KB before answering queries. 'r' option");
        System.out.println("                can be used to realize all the instances");
        System.out.println("  {-h,-help}    Print this information");
    }

    public static void main(String[] args) throws Exception {
        PelletQueryTest pelletQuery = new PelletQueryTest();
        String query = null;
        String data = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("-help")) {
                PelletQueryTest.usage();
                System.exit(0);
                continue;
            }
            if (arg.equals("-p")) {
                pelletQuery.setPrintQuery(true);
                continue;
            }
            if (arg.equals("-t")) {
                pelletQuery.setDetailedTime(true);
                continue;
            }
            if (arg.equals("-n")) {
                pelletQuery.setQuiet(true);
                continue;
            }
            if (arg.equals("-l")) {
                pelletQuery.setLimit(Integer.parseInt(args[++i]));
                continue;
            }
            if (arg.equals("-d")) {
                data = args[++i];
                continue;
            }
            if (arg.equals("-c")) {
                pelletQuery.setClassify(true);
                continue;
            }
            if (arg.equals("-cr")) {
                pelletQuery.setClassify(true);
                pelletQuery.setRealize(true);
                continue;
            }
            if (arg.startsWith("-q")) {
                query = args[++i];
                continue;
            }
            System.err.println("Unknown option; " + arg);
            PelletQueryTest.usage();
            System.exit(1);
        }
        if (query == null) {
            System.err.println("No query is given");
            PelletQueryTest.usage();
            System.exit(1);
        }
        if (data == null) {
            System.err.println("No data is given");
            PelletQueryTest.usage();
            System.exit(1);
        }
        pelletQuery.run(query, data);
    }
}

