/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.OWLLoader;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryParser;
import org.mindswap.pellet.query.impl.QueryImpl;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.URIUtils;

public class ARQParser
implements QueryParser {
    public static Log log = LogFactory.getLog(QueryEngine.class);
    private Syntax syntax = QueryEngine.DEFAULT_SYNTAX;
    private Set triples;
    private Map terms;
    private KnowledgeBase kb;

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public Query parse(InputStream in, KnowledgeBase kb) throws IOException {
        return this.parse(new InputStreamReader(in), kb);
    }

    public Query parse(Reader in, KnowledgeBase kb) throws IOException {
        StringBuffer queryString = new StringBuffer();
        BufferedReader r = new BufferedReader(in);
        String line = r.readLine();
        while (line != null) {
            queryString.append(line).append("\n");
            line = r.readLine();
        }
        return this.parse(queryString.toString(), kb);
    }

    public Query parse(String queryStr, KnowledgeBase kb) {
        com.hp.hpl.jena.query.Query sparql = QueryFactory.create((String)queryStr, (Syntax)this.syntax);
        return this.parse(sparql, kb);
    }

    private void collectResultVars(com.hp.hpl.jena.query.Query sparql, Query query) {
        sparql.setResultVars();
        for (String var : sparql.getResultVars()) {
            query.addResultVar(ATermUtils.makeVar(var));
        }
    }

    public Query parse(com.hp.hpl.jena.query.Query sparql, KnowledgeBase kb) {
        Node obj;
        Node pred;
        Node subj;
        this.kb = kb;
        if (sparql.isDescribeType()) {
            throw new UnsupportedQueryException("DESCRIBE queries cannot be answered with PelletQueryEngine");
        }
        Element pattern = sparql.getQueryPattern();
        if (!(pattern instanceof ElementGroup)) {
            throw new UnsupportedQueryException("ElementGroup was expected");
        }
        this.terms = new HashMap();
        ElementGroup elementGroup = (ElementGroup)pattern;
        List elements = elementGroup.getElements();
        Element first = (Element)elements.get(0);
        if (elements.size() != 1 || !(first instanceof ElementTriplesBlock)) {
            throw new UnsupportedQueryException("Complex query patterns are not supported");
        }
        this.triples = new HashSet(((ElementTriplesBlock)first).getTriples().getList());
        ArrayList iterableList = new ArrayList(this.triples);
        QueryImpl query = new QueryImpl(kb);
        this.collectResultVars(sparql, query);
        for (Triple t : iterableList) {
            if (!this.triples.contains(t)) continue;
            subj = t.getSubject();
            pred = t.getPredicate();
            obj = t.getObject();
            ATermAppl s1 = this.node2term(subj);
            ATermAppl p1 = this.node2term(pred);
            ATermAppl o1 = this.node2term(obj);
            this.terms.put(subj, s1);
            this.terms.put(pred, p1);
            this.terms.put(obj, o1);
        }
        for (Triple t : this.triples) {
            subj = t.getSubject();
            pred = t.getPredicate();
            obj = t.getObject();
            ATermAppl s = (ATermAppl)this.terms.get(subj);
            ATermAppl p = (ATermAppl)this.terms.get(pred);
            ATermAppl o = (ATermAppl)this.terms.get(obj);
            if (subj.isVariable() && !subj.getName().startsWith("%")) {
                query.addDistVar(s);
            }
            if (obj.isVariable() && !obj.getName().startsWith("%")) {
                query.addDistVar(o);
            }
            if (obj.toString().startsWith(RDF.getURI()) || obj.toString().startsWith(OWL.getURI()) || obj.toString().startsWith(RDFS.getURI())) {
                throw new UnsupportedQueryException("Terms that belong to [RDF, RDFS, OWL] namespaces cannot be used as objects in ABoxQuery: " + obj);
            }
            if (pred.equals((Object)RDF.Nodes.type)) {
                if (ATermUtils.isVar(o)) {
                    throw new UnsupportedQueryException("Variables cannot be used as objects of rdf:type triples in ABoxQuery");
                }
                if (!kb.isClass(o)) {
                    query.setHasUndefinedPredicate(true);
                    log.warn((Object)("Class " + o + " used in the query is not defined in the KB."));
                }
                query.addTypePattern(s, o);
                continue;
            }
            if (pred.isVariable()) {
                throw new UnsupportedQueryException("Variables cannot be used in predicate position in AboxQuery");
            }
            if (pred.toString().startsWith(RDF.getURI()) || pred.toString().startsWith(OWL.getURI()) || pred.toString().startsWith(RDFS.getURI())) {
                throw new UnsupportedQueryException("Predicates that belong to [RDF, RDFS, OWL] namespaces cannot be used in ABoxQuery: " + pred);
            }
            if (!kb.isProperty(p)) {
                query.setHasUndefinedPredicate(true);
                log.warn((Object)("Property " + pred + " used in the query is not defined in the KB."));
            }
            if (kb.isDatatypeProperty(p) && query.getDistVars().contains(o) && subj.isVariable() && !query.getDistVars().contains(s)) {
                log.warn((Object)("Warning: Forcing variable " + subj + " to be distinguished (Subject of datatype triple)"));
                query.addDistVar(s);
            }
            query.addEdgePattern(s, p, o);
        }
        return query;
    }

    private Node getObject(Node subj, Node pred) {
        Iterator i = this.triples.iterator();
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            i.remove();
            return t.getObject();
        }
        return null;
    }

    private boolean hasObject(Node subj, Node pred) {
        for (Triple t : this.triples) {
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            return true;
        }
        return false;
    }

    private boolean hasObject(Node subj, Node pred, Node obj) {
        Iterator i = this.triples.iterator();
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            i.remove();
            if (obj.equals((Object)t.getObject())) {
                return true;
            }
            throw new UnsupportedQueryException("Expecting rdf:type " + obj + " but found rdf:type " + t.getObject());
        }
        return false;
    }

    private ATermList createList(Node node) {
        if (node.equals((Object)RDF.nil.asNode())) {
            return ATermUtils.EMPTY_LIST;
        }
        if (this.terms.containsKey(node)) {
            return (ATermList)this.terms.get(node);
        }
        this.hasObject(node, RDF.type.asNode(), RDF.List.asNode());
        Node first = this.getObject(node, RDF.first.asNode());
        Node rest = this.getObject(node, RDF.rest.asNode());
        if (first == null || rest == null) {
            throw new UnsupportedQueryException("Invalid list structure: List " + node + " does not have a " + (first == null ? "rdf:first" : "rdf:rest") + " property.");
        }
        ATermList list = ATermUtils.makeList(this.node2term(first), this.createList(rest));
        this.terms.put(node, list);
        return list;
    }

    private ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.TOP;
        this.hasObject(node, RDF.type.asNode(), OWL.Restriction.asNode());
        Node p = this.getObject(node, OWL.onProperty.asNode());
        if (p == null) {
            return aTerm;
        }
        ATermAppl pt = this.node2term(p);
        if (!this.kb.isProperty(pt)) {
            throw new UnsupportedQueryException("Property " + pt + " is not present in KB.");
        }
        Node o = null;
        o = this.getObject(node, OWL.hasValue.asNode());
        if (o != null) {
            if (PelletOptions.USE_PSEUDO_NOMINALS) {
                if (o.isLiteral()) {
                    aTerm = ATermUtils.makeMin((ATerm)pt, 1, (ATerm)ATermUtils.TOP_LIT);
                } else {
                    ATermAppl ind = ATermUtils.makeTermAppl(o.getURI());
                    if (!this.kb.isIndividual(ind)) {
                        throw new UnsupportedQueryException("Individual " + ind + " is not present in KB.");
                    }
                    ATermAppl nom = ATermUtils.makeTermAppl(o.getURI() + "_nom");
                    aTerm = ATermUtils.makeSomeValues(pt, nom);
                }
            } else {
                ATermAppl ot = this.node2term(o);
                aTerm = ATermUtils.makeHasValue(pt, ot);
            }
        } else {
            o = this.getObject(node, OWL.allValuesFrom.asNode());
            if (o != null) {
                ATermAppl ot = this.node2term(o);
                aTerm = ATermUtils.makeAllValues(pt, ot);
            } else {
                o = this.getObject(node, OWL.someValuesFrom.asNode());
                if (o != null) {
                    ATermAppl ot = this.node2term(o);
                    aTerm = ATermUtils.makeSomeValues(pt, ot);
                } else {
                    o = this.getObject(node, OWL.minCardinality.asNode());
                    if (o != null) {
                        try {
                            ATermAppl top = null;
                            top = this.kb.isDatatypeProperty(pt) ? ATermUtils.TOP_LIT : ATermUtils.TOP;
                            int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                            aTerm = ATermUtils.makeMin((ATerm)pt, cardinality, (ATerm)top);
                        }
                        catch (Exception ex) {}
                    } else {
                        o = this.getObject(node, OWL.maxCardinality.asNode());
                        if (o != null) {
                            try {
                                ATermAppl top = null;
                                top = this.kb.isDatatypeProperty(pt) ? ATermUtils.TOP_LIT : ATermUtils.TOP;
                                int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                                aTerm = ATermUtils.makeMax((ATerm)pt, cardinality, (ATerm)top);
                            }
                            catch (Exception ex) {}
                        } else {
                            o = this.getObject(node, OWL.cardinality.asNode());
                            if (o != null) {
                                try {
                                    ATermAppl top = null;
                                    top = this.kb.isDatatypeProperty(pt) ? ATermUtils.TOP_LIT : ATermUtils.TOP;
                                    int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                                    aTerm = ATermUtils.makeCard(pt, cardinality, top);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
        return aTerm;
    }

    private ATermAppl node2term(Node node) {
        ATermAppl aTerm = (ATermAppl)this.terms.get(node);
        if (aTerm == null) {
            if (node.equals((Object)OWL.Thing.asNode())) {
                return ATermUtils.TOP;
            }
            if (node.equals((Object)OWL.Nothing.asNode())) {
                return ATermUtils.BOTTOM;
            }
            if (node.equals((Object)RDF.type.asNode())) {
                return null;
            }
            if (node.isLiteral()) {
                return JenaUtils.makeLiteral(node.getLiteral());
            }
            if (this.hasObject(node, OWL.onProperty.asNode())) {
                aTerm = this.createRestriction(node);
                this.terms.put(node, aTerm);
            } else if (node.isBlank() || node.isVariable()) {
                Node o = null;
                o = this.getObject(node, OWL.intersectionOf.asNode());
                if (o != null) {
                    ATermList list = this.createList(o);
                    this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                    aTerm = ATermUtils.makeAnd(list);
                } else {
                    o = this.getObject(node, OWL.unionOf.asNode());
                    if (o != null) {
                        ATermList list = this.createList(o);
                        this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                        aTerm = ATermUtils.makeOr(list);
                    } else {
                        o = this.getObject(node, OWL.oneOf.asNode());
                        if (o != null) {
                            ATermList list = this.createList(o);
                            this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                            ATermList result = ATermUtils.EMPTY_LIST;
                            ATermList l = list;
                            while (!l.isEmpty()) {
                                ATermAppl nominal;
                                ATermAppl c = (ATermAppl)l.getFirst();
                                if (PelletOptions.USE_PSEUDO_NOMINALS) {
                                    nominal = ATermUtils.makeTermAppl(c.getName() + "_nominal");
                                    result = result.insert(nominal);
                                } else {
                                    nominal = ATermUtils.makeValue(c);
                                    result = result.insert(nominal);
                                }
                                l = l.getNext();
                            }
                            aTerm = ATermUtils.makeOr(result);
                        } else {
                            o = this.getObject(node, OWL.complementOf.asNode());
                            if (o != null) {
                                ATermAppl complement = this.node2term(o);
                                this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                                aTerm = ATermUtils.makeNot(complement);
                            } else {
                                if (node.isVariable()) {
                                    return ATermUtils.makeVar(node.getName());
                                }
                                String bNode = "bNode" + node.getBlankNodeId();
                                aTerm = ATermUtils.makeTermAppl(bNode);
                            }
                        }
                    }
                }
            } else {
                String uri = node.getURI();
                aTerm = PelletOptions.USE_LOCAL_NAME ? (uri.startsWith("http://www.w3.org/2001/XMLSchema#") ? ATermUtils.makeTermAppl(uri) : ATermUtils.makeTermAppl(URIUtils.getLocalName(uri))) : (PelletOptions.USE_QNAME ? (uri.startsWith("http://www.w3.org/2001/XMLSchema#") ? ATermUtils.makeTermAppl(uri) : ATermUtils.makeTermAppl(OWLLoader.qnames.shortForm(uri))) : ATermUtils.makeTermAppl(uri));
            }
            this.terms.put(node, aTerm);
        }
        return aTerm;
    }
}

