/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.ListSizeComparator;
import org.mindswap.pellet.query.impl.LiteralIterator;
import org.mindswap.pellet.query.impl.QueryResultBindingImpl;
import org.mindswap.pellet.query.impl.QueryResultsImpl;

public class OptimizedQueryExec
implements QueryExec {
    public static Log log = LogFactory.getLog(QueryEngine.class);

    public boolean supports(Query q) {
        return q.getDistObjVars().size() > 2;
    }

    public QueryResults exec(Query q) {
        boolean hasLiterals;
        QueryResultsImpl results = new QueryResultsImpl(q);
        KnowledgeBase kb = q.getKB();
        Set distObjVars = q.getDistObjVars();
        int size = distObjVars.size();
        HashMap<ATermAppl, Set<ATermAppl>> varBindings = new HashMap<ATermAppl, Set<ATermAppl>>(size);
        ATermAppl[] vars = new ATermAppl[size];
        int index = 0;
        for (ATermAppl currVar : distObjVars) {
            ATermAppl rolledUpClass = q.rollUpTo(currVar);
            if (log.isTraceEnabled()) {
                log.trace((Object)(currVar + " -> " + rolledUpClass));
            }
            vars[index++] = currVar;
            varBindings.put(currVar, kb.getInstances(rolledUpClass));
        }
        log.trace(varBindings);
        Arrays.sort(vars, new ListSizeComparator(varBindings));
        Collection[] varB = new Collection[size];
        for (int i = 0; i < size; ++i) {
            varB[i] = (Collection)varBindings.get(vars[i]);
        }
        ArrayList[] goodList = new ArrayList[size];
        for (int i = 0; i < goodList.length; ++i) {
            goodList[i] = new ArrayList();
        }
        for (ATermAppl curr : varB[0]) {
            Iterator j = varB[1].iterator();
            while (j.hasNext()) {
                QueryResultBindingImpl b = new QueryResultBindingImpl();
                b.setValue(vars[0], curr);
                b.setValue(vars[1], (ATermAppl)j.next());
                boolean queryTrue = QueryEngine.execBoolean(q.apply(b));
                if (queryTrue) {
                    goodList[1].add(b);
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Accepted Pair: " + b));
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Rejected Pair: " + b));
            }
        }
        for (int i = 2; i < size; ++i) {
            for (QueryResultBinding goodMap : goodList[i - 1]) {
                for (ATermAppl curr : varB[i]) {
                    QueryResultBinding b = (QueryResultBinding)goodMap.clone();
                    b.setValue(vars[i], curr);
                    boolean queryTrue = QueryEngine.execBoolean(q.apply(b));
                    if (queryTrue) {
                        goodList[i].add(b);
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("Accepted binding: " + b));
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Rejected binding: " + b));
                }
            }
        }
        boolean bl = hasLiterals = !q.getDistLitVars().isEmpty();
        if (hasLiterals) {
            for (QueryResultBinding b : goodList[goodList.length - 1]) {
                LiteralIterator l = new LiteralIterator(q, b);
                while (l.hasNext()) {
                    QueryResultBinding mappy = (QueryResultBinding)l.next();
                    results.add(mappy);
                }
            }
        } else {
            for (QueryResultBinding b : goodList[goodList.length - 1]) {
                results.add(b);
            }
        }
        return results;
    }
}

