/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.output.ATermAbstractSyntaxRenderer;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.QueryUtils;

public class QueryResultsImpl
implements QueryResults {
    private Query query;
    private List results;

    public QueryResultsImpl(Query query) {
        this.query = query;
        this.results = new ArrayList();
    }

    public void add(QueryResultBinding binding) {
        this.results.add(binding);
    }

    public boolean contains(QueryResultBinding binding) {
        return this.results.contains(binding);
    }

    public QueryResultBinding get(int index) {
        return (QueryResultBinding)this.results.get(index);
    }

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public Query getQuery() {
        return this.query;
    }

    public List getResultVars() {
        return this.query.getResultVars();
    }

    public TableData toTable() {
        return this.toTable(false);
    }

    public TableData toTable(boolean formatHTML) {
        List resultVars = this.query.getResultVars();
        ArrayList<String> colNames = new ArrayList<String>(resultVars.size());
        for (int i = 0; i < resultVars.size(); ++i) {
            ATermAppl var = (ATermAppl)resultVars.get(i);
            colNames.add(QueryUtils.getVarName(var));
        }
        StringWriter sw = new StringWriter();
        OutputFormatter formatter = new OutputFormatter(sw, formatHTML);
        ATermAbstractSyntaxRenderer renderer = new ATermAbstractSyntaxRenderer();
        renderer.setWriter(formatter);
        TableData table = new TableData(colNames);
        for (int i = 0; i < this.size(); ++i) {
            QueryResultBinding binding = this.get(i);
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < resultVars.size(); ++j) {
                sw.getBuffer().setLength(0);
                ATermAppl var = (ATermAppl)resultVars.get(j);
                ATermAppl val = binding.getValue(var);
                if (val != null) {
                    renderer.visit(val);
                    list.add(sw.toString());
                    continue;
                }
                list.add("<<unbound>>");
            }
            table.add(list);
        }
        return table;
    }

    public String toString() {
        return this.toTable().toString();
    }
}

