/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Node;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.Triple;
import org.mindswap.pellet.rete.Utils;
import org.mindswap.pellet.rete.Variable;

public class AlphaNode
extends Node {
    protected Triple pattern;
    protected List betaNodes;
    protected List dependents;
    protected List dependsOn;

    public AlphaNode(Triple t) {
        this.pattern = t;
        this.ind = new HashMap();
        this.betaNodes = new ArrayList();
        this.vars = this.pattern.getVars();
        Collections.sort(this.vars);
        this.svars = new ArrayList();
        this.dependents = new ArrayList();
        this.dependsOn = new ArrayList();
    }

    public void clear() {
        this.ind.clear();
    }

    public Map getBindings(List row) {
        HashMap bindings = new HashMap();
        List key = Utils.append(this.svars, this.vars);
        key = Utils.removeDups(key);
        for (int i = 0; i < key.size(); ++i) {
            bindings.put(key.get(i), row.get(i));
        }
        return bindings;
    }

    public boolean index(Map ind, Map bindings, List key, Fact factAdded) {
        if (key.size() > 0) {
            Term t = (Term)bindings.get(key.remove(0));
            if (!ind.containsKey(t)) {
                if (key.size() > 0) {
                    ind.put(t, new HashMap());
                    return this.index((Map)ind.get(t), bindings, key, factAdded);
                }
                ind.put(t, new HashMap());
                return true;
            }
            if (key.size() > 0) {
                return this.index((Map)ind.get(t), bindings, key, factAdded);
            }
            return false;
        }
        return false;
    }

    public Map match(Fact fact) {
        HashMap<Term, Term> bindings = new HashMap<Term, Term>();
        List pList = this.pattern.getList();
        List fList = fact.getList();
        Term p = null;
        Term f = null;
        for (int i = 0; i < 3; ++i) {
            p = (Term)pList.get(i);
            f = (Term)fList.get(i);
            if (!(p instanceof Variable)) {
                if (p.equals(f)) continue;
                return null;
            }
            if (!bindings.containsKey(p)) {
                bindings.put(p, f);
                continue;
            }
            if (((Term)bindings.get(p)).equals(f)) continue;
            return null;
        }
        return bindings;
    }

    public boolean add(Fact fact) {
        Map bindings = this.match(fact);
        if (bindings != null) {
            List key = Utils.append(this.svars, this.vars);
            key = Utils.removeDups(key);
            return this.index(this.ind, bindings, key, fact);
        }
        return false;
    }

    public String toString() {
        return "AlphaNode(" + this.pattern.toString() + ")";
    }
}

