/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.rete.AlphaNode;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Node;
import org.mindswap.pellet.rete.RuleNode;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.Triple;
import org.mindswap.pellet.rete.Utils;
import org.mindswap.pellet.rete.Variable;

public class BetaNode
extends Node {
    public Node lnode;
    public Node rnode;
    public List parents;
    public List children;
    public RuleNode rule = null;
    public List pattern;

    public BetaNode(Node lnode, Node rnode) {
        this.lnode = lnode;
        this.rnode = rnode;
        this.svars = new ArrayList();
        if (rnode instanceof AlphaNode) {
            for (int i = 0; i < lnode.vars.size(); ++i) {
                if (!rnode.vars.contains(lnode.vars.get(i))) continue;
                this.svars.add(lnode.vars.get(i));
            }
        }
        Collections.sort(this.svars);
        this.svars = Utils.removeDups(this.svars);
        this.vars = Utils.append(this.svars, lnode.vars);
        this.vars = Utils.append(this.vars, rnode.vars);
        this.vars = Utils.removeDups(this.vars);
        this.parents = new ArrayList();
        this.children = new ArrayList();
        this.ind = new HashMap();
    }

    public HashMap getBindings(List row) {
        HashMap bindings = new HashMap();
        List key = this.getKey();
        for (int i = 0; i < key.size(); ++i) {
            bindings.put(key.get(i), row.get(i));
        }
        return bindings;
    }

    public List getKey() {
        List key = new ArrayList();
        key.addAll(this.lnode.svars);
        key.addAll(this.lnode.vars);
        key.addAll(this.rnode.vars);
        key = Utils.removeDups(key);
        return key;
    }

    public boolean add(List row) {
        ArrayList key = new ArrayList();
        List k = this.getKey();
        for (int i = 0; i < this.getKey().size(); ++i) {
            key.add(k.get(i));
        }
        HashMap bindings = this.getBindings(row);
        if (bindings != null) {
            return this.index(this.ind, row, bindings, key);
        }
        return false;
    }

    private boolean index(Map ind, List row, Map bindings, List key) {
        if (key.size() > 0) {
            Term t = (Term)bindings.get(key.remove(0));
            if (!ind.containsKey(t)) {
                if (key.size() > 0) {
                    ind.put(t, new HashMap());
                    return this.index((Map)ind.get(t), row, bindings, key);
                }
                ind.put(t, new ArrayList());
                return true;
            }
            if (key.size() > 0) {
                return this.index((Map)ind.get(t), row, bindings, key);
            }
            return false;
        }
        return false;
    }

    public List join() {
        if (this.lnode.equals(this.rnode)) {
            this.vars = this.lnode.vars;
            if (!this.lnode.ind.isEmpty()) {
                return Utils.keysToList(this.lnode.ind);
            }
            return null;
        }
        List key = this.svars;
        List<List> joinResults = new ArrayList();
        if (key.isEmpty()) {
            List leftMemory = Utils.keysToList(this.lnode.ind);
            List rightMemory = Utils.keysToList(this.rnode.ind);
            for (int i = 0; i < leftMemory.size(); ++i) {
                for (int k = 0; k < rightMemory.size(); ++k) {
                    List row = Utils.append((List)leftMemory.get(i), (List)rightMemory.get(k));
                    joinResults.add(row);
                    this.add(row);
                }
            }
        } else {
            joinResults = this.joinHelper(this.lnode.ind, this.rnode.ind, key, new ArrayList(), new ArrayList());
        }
        return joinResults;
    }

    public List joinHelper(Map leftMemory, Map rightMemory, List sharedVars, List matchedValues, List results) {
        block6: {
            block7: {
                block5: {
                    if (sharedVars.size() <= 0) break block5;
                    Object[] leftMemoryKeys = leftMemory.keySet().toArray();
                    for (int i = 0; i < leftMemoryKeys.length; ++i) {
                        if (!rightMemory.containsKey(leftMemoryKeys[i])) continue;
                        List tmp = Utils.append(matchedValues, leftMemoryKeys[i]);
                        this.joinHelper((HashMap)leftMemory.get(leftMemoryKeys[i]), (HashMap)rightMemory.get(leftMemoryKeys[i]), sharedVars.subList(1, sharedVars.size()), tmp, results);
                    }
                    break block6;
                }
                if (matchedValues.size() <= 0) break block6;
                if (leftMemory.isEmpty()) break block7;
                List lm = Utils.keysToList(leftMemory);
                for (int i = 0; i < lm.size(); ++i) {
                    if (!rightMemory.isEmpty()) {
                        List rm = Utils.keysToList(rightMemory);
                        for (int k = 0; k < rm.size(); ++k) {
                            List row = Utils.append(matchedValues, (List)lm.get(i));
                            row = Utils.append(row, (List)rm.get(k));
                            results.add(row);
                            this.add(row);
                        }
                        continue;
                    }
                    List row = Utils.append(matchedValues, (List)lm.get(i));
                    results.add(row);
                    this.add(row);
                }
                break block6;
            }
            if (rightMemory.isEmpty()) break block6;
            List rm = Utils.keysToList(rightMemory);
            for (int k = 0; k < rm.size(); ++k) {
                List row = Utils.append(matchedValues, (List)rm.get(k));
                results.add(row);
                this.add(row);
            }
        }
        return results;
    }

    public Set matchingFacts(Triple rhs, List facts) {
        HashSet<Fact> results = new HashSet<Fact>();
        for (ArrayList f : facts) {
            Fact newFact = new Fact();
            newFact.subj = rhs.getSubj() instanceof Variable ? this.getVar((Variable)rhs.getSubj(), f) : rhs.getSubj();
            if (rhs.getPred() instanceof Variable) {
                System.err.println("Variables not allowed in predicates!");
            } else {
                newFact.pred = rhs.getPred();
            }
            newFact.obj = rhs.getObj() instanceof Variable ? this.getVar((Variable)rhs.getObj(), f) : rhs.getObj();
            results.add(newFact);
        }
        return results;
    }

    private Term getVar(Variable var, List fact) {
        if (this.vars.contains(var)) {
            int index = this.vars.indexOf(var);
            return (Term)fact.get(index);
        }
        System.err.println("Unbound rule variable:" + var + this.vars);
        return null;
    }

    public String toString() {
        return "BetaNode vars: " + this.vars.toString() + " size: " + Utils.keysToList(this.ind).size();
    }
}

