/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.rete.AlphaIndex;
import org.mindswap.pellet.rete.AlphaNode;
import org.mindswap.pellet.rete.AlphaStore;
import org.mindswap.pellet.rete.BetaNode;
import org.mindswap.pellet.rete.BetaStore;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Rule;
import org.mindswap.pellet.rete.RuleNode;
import org.mindswap.pellet.rete.Triple;
import org.mindswap.pellet.rete.Utils;
import org.mindswap.pellet.utils.ATermUtils;

public class Compiler {
    AlphaStore alphaNodeStore;
    BetaStore betaNodeStore;
    AlphaIndex alphaIndex;

    public Compiler() {
        this.alphaNodeStore = new AlphaStore();
        this.betaNodeStore = new BetaStore();
        this.alphaIndex = new AlphaIndex();
    }

    public Compiler(Set facts) {
    }

    public Compiler compile(Collection rules) {
        for (Rule rule : rules) {
            AlphaNode b;
            AlphaNode a;
            BetaNode beta1;
            AlphaStore alphaNodesOfRule = new AlphaStore();
            for (Triple anodePattern : rule.body) {
                AlphaNode anode = this.makeAlphaNode(anodePattern);
                alphaNodesOfRule.addNode(anode);
            }
            alphaNodesOfRule.sort();
            this.alphaNodeStore.sort();
            int l = alphaNodesOfRule.nodes.size();
            if (l == 0) {
                System.err.println("Malformed Input");
                continue;
            }
            if (l == 1) {
                beta1 = this.makeBetaNode((org.mindswap.pellet.rete.Node)alphaNodesOfRule.nodes.get(0), (org.mindswap.pellet.rete.Node)alphaNodesOfRule.nodes.get(0), false);
                a = (AlphaNode)alphaNodesOfRule.nodes.get(0);
                a.betaNodes = new ArrayList();
                a.betaNodes.add(beta1);
                beta1.rule = new RuleNode(rule);
                beta1.rule.betaNode = beta1;
                continue;
            }
            if (l == 2) {
                beta1 = this.makeBetaNode((org.mindswap.pellet.rete.Node)alphaNodesOfRule.nodes.get(0), (org.mindswap.pellet.rete.Node)alphaNodesOfRule.nodes.get(1), false);
                a = (AlphaNode)alphaNodesOfRule.nodes.get(0);
                a.betaNodes = new ArrayList();
                a.betaNodes.add(beta1);
                b = (AlphaNode)alphaNodesOfRule.nodes.get(1);
                b.betaNodes = new ArrayList();
                b.betaNodes.add(beta1);
                beta1.rule = new RuleNode(rule);
                beta1.rule.betaNode = beta1;
                this.betaNodeStore.addNode(beta1);
                continue;
            }
            beta1 = this.makeBetaNode((org.mindswap.pellet.rete.Node)alphaNodesOfRule.nodes.get(0), (org.mindswap.pellet.rete.Node)alphaNodesOfRule.nodes.get(1), true);
            a = (AlphaNode)alphaNodesOfRule.nodes.get(0);
            a.betaNodes = new ArrayList();
            a.betaNodes.add(beta1);
            b = (AlphaNode)alphaNodesOfRule.nodes.get(1);
            b.betaNodes = new ArrayList();
            b.betaNodes.add(beta1);
            this.betaNodeStore.addNode(beta1);
            this.makeBetaNetwork(rule, beta1, alphaNodesOfRule.nodes.subList(2, alphaNodesOfRule.nodes.size()));
        }
        return this;
    }

    public void makeBetaNetwork(Rule rule, BetaNode betaNode, List alphaNodeList) {
        if (alphaNodeList.size() == 0) {
            betaNode.rule = new RuleNode(rule);
            betaNode.rule.betaNode = betaNode;
        } else {
            AlphaNode alpha = (AlphaNode)alphaNodeList.get(0);
            BetaNode betaChild = this.makeBetaNode(betaNode, alpha, true);
            betaChild.parents = new ArrayList();
            betaChild.parents.add(betaNode);
            betaNode.children = new ArrayList();
            betaNode.children.add(betaChild);
            ArrayList sharedJoinVars = (ArrayList)Utils.getSharedVars(betaNode, alpha);
            Collections.sort(sharedJoinVars);
            betaNode.svars = sharedJoinVars;
            List tmp = Utils.append((List)sharedJoinVars, betaNode.vars);
            betaNode.vars = Utils.removeDups(tmp);
            alpha.betaNodes = new ArrayList();
            alpha.betaNodes.add(betaChild);
            this.betaNodeStore.addNode(betaNode);
            this.betaNodeStore.addNode(betaChild);
            this.makeBetaNetwork(rule, betaChild, alphaNodeList.subList(1, alphaNodeList.size()));
        }
    }

    public AlphaNode makeAlphaNode(Triple pattern) {
        AlphaNode a = new AlphaNode(pattern);
        this.alphaIndex.add(a);
        this.alphaNodeStore.addNode(a);
        return a;
    }

    public BetaNode makeBetaNode(org.mindswap.pellet.rete.Node node1, org.mindswap.pellet.rete.Node node2, boolean futureJoins) {
        List sharedVars = Utils.getSharedVars(node1, node2);
        Collections.sort(sharedVars);
        if (node1 instanceof AlphaNode) {
            node1.svars = sharedVars;
        }
        node2.svars = sharedVars;
        BetaNode b = new BetaNode(node1, node2);
        b.svars = sharedVars;
        return b;
    }

    public Set compileFacts(ABox abox) {
        HashSet<Fact> result = new HashSet<Fact>();
        IndividualIterator i = abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            if (!ind.isNamedIndividual()) continue;
            List atomic = ind.getTypes(0);
            for (ATermAppl c : atomic) {
                if (!ind.getDepends(c).isIndependent() || !ATermUtils.isPrimitive(c)) continue;
                result.add(this.createFact(ind, c));
            }
            EdgeList edges = ind.getOutEdges();
            Iterator it = edges.iterator();
            while (it.hasNext()) {
                Node to;
                Edge edge = (Edge)it.next();
                Individual from = edge.getFrom();
                if (edge.getTo() instanceof Individual) {
                    to = (Individual)edge.getTo();
                    if (!from.isNamedIndividual() || !to.isNamedIndividual()) continue;
                    result.add(this.createFact(from, (Individual)to, edge));
                    continue;
                }
                if (!(edge.getTo() instanceof Literal)) continue;
                to = (Literal)edge.getTo();
                if (!from.isNamedIndividual() || !to.isNamedIndividual()) continue;
                result.add(this.createDataValueFact(from, (Literal)to, edge));
            }
        }
        return result;
    }

    private Fact createFact(Individual from, Individual to, Edge edge) {
        Constant subj = null;
        Constant pred = null;
        Constant obj = null;
        subj = new Constant(from.getNameStr());
        pred = new Constant(edge.getRole().getName().toString());
        obj = new Constant(to.getNameStr());
        return new Fact(subj, pred, obj);
    }

    private Fact createDataValueFact(Individual from, Literal to, Edge edge) {
        Constant subj = null;
        Constant pred = null;
        Constant obj = null;
        subj = new Constant(from.getNameStr());
        pred = new Constant(edge.getRole().getName().toString());
        obj = new Constant(to.toString());
        return new Fact(subj, pred, obj);
    }

    private Fact createFact(Individual ind, ATermAppl c) {
        Constant subj = null;
        Constant obj = null;
        subj = new Constant(ind.getNameStr());
        Constant predType = Constant.TYPE;
        obj = new Constant(c.getName());
        return new Fact(subj, predType, obj);
    }
}

