/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.rete.AlphaNode;
import org.mindswap.pellet.rete.BetaNode;
import org.mindswap.pellet.rete.Compiler;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Triple;
import org.mindswap.pellet.utils.SetUtils;

public class Interpreter {
    public Compiler compiler;
    public Compiler rete;
    Set totalFacts;
    Set joinedBetaNodes;
    public Set inferredFacts;
    public Set fta;
    Set initialFacts;

    public Interpreter() {
        this.rete = this.compiler = new Compiler();
        this.totalFacts = new HashSet();
        this.joinedBetaNodes = new HashSet();
        this.inferredFacts = new HashSet();
        this.fta = new HashSet();
        this.initialFacts = new HashSet();
    }

    public Set getTotalFacts() {
        return this.totalFacts;
    }

    public boolean addFacts(Set facts, boolean initialSet) {
        boolean status = false;
        if (initialSet) {
            this.initialFacts = facts;
        }
        for (Fact f : facts) {
            this.totalFacts.add(f);
            List alphaMatches = this.rete.alphaIndex.match(f);
            for (int i = 0; i < alphaMatches.size(); ++i) {
                AlphaNode a = (AlphaNode)alphaMatches.get(i);
                if (!a.add(f)) continue;
                status = true;
            }
        }
        return status;
    }

    public void processBetaNode(BetaNode betaNode) {
        block4: {
            List inferences = betaNode.join();
            if (inferences == null || inferences.size() <= 0) break block4;
            this.joinedBetaNodes.add(betaNode);
            if (betaNode.rule != null) {
                for (int i = 0; i < betaNode.rule.rhs.size(); ++i) {
                    Set results = betaNode.matchingFacts((Triple)betaNode.rule.rhs.get(i), inferences);
                    this.fta.addAll(results);
                }
            } else {
                for (int i = 0; i < betaNode.children.size(); ++i) {
                    this.processBetaNode((BetaNode)betaNode.children.get(i));
                }
            }
        }
    }

    public void run() {
        for (AlphaNode alphaNode : this.rete.alphaNodeStore.nodes) {
            for (BetaNode betaNode : alphaNode.betaNodes) {
                if (this.joinedBetaNodes.contains(betaNode)) continue;
                this.fta = new HashSet();
                this.processBetaNode(betaNode);
            }
            if (this.fta.isEmpty()) continue;
            this.fta.removeAll(this.initialFacts);
            Set newInferredFacts = SetUtils.difference(this.fta, this.inferredFacts);
            if (newInferredFacts.size() <= 0) continue;
            this.inferredFacts.addAll(newInferredFacts);
            if (!this.addFacts(newInferredFacts, false)) continue;
            this.joinedBetaNodes.clear();
            this.run();
        }
    }
}

