/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.utils.URIUtils;

public class Triple {
    protected Term subj;
    protected Term pred;
    protected Term obj;

    public Triple() {
    }

    public Triple(Term s, Term p, Term o) {
        if (s == null || p == null || o == null) {
            throw new NullPointerException();
        }
        this.subj = s;
        this.pred = p;
        this.obj = o;
    }

    public List getList() {
        ArrayList<Term> pattern = new ArrayList<Term>();
        pattern.add(this.subj);
        pattern.add(this.pred);
        pattern.add(this.obj);
        return pattern;
    }

    public Term getObj() {
        return this.obj;
    }

    public void setObj(Term obj) {
        this.obj = obj;
    }

    public Term getPred() {
        return this.pred;
    }

    public void setPred(Term pred) {
        this.pred = pred;
    }

    public Term getSubj() {
        return this.subj;
    }

    public void setSubj(Term subj) {
        this.subj = subj;
    }

    public List getVars() {
        ArrayList<Term> v = new ArrayList<Term>();
        if (this.subj instanceof Variable) {
            v.add(this.subj);
        }
        if (this.pred instanceof Variable) {
            v.add(this.pred);
        }
        if (this.obj instanceof Variable) {
            v.add(this.obj);
        }
        return v;
    }

    public String toString() {
        if (this.pred.equals(Constant.TYPE)) {
            return Triple.format(this.obj) + "(" + Triple.format(this.subj) + ")";
        }
        if (this.pred.equals(Constant.SAME_AS)) {
            return Triple.format(this.subj) + " = " + Triple.format(this.obj);
        }
        if (this.pred.equals(Constant.SAME_AS)) {
            return Triple.format(this.subj) + " != " + Triple.format(this.obj);
        }
        return Triple.format(this.pred) + "(" + Triple.format(this.subj) + "," + Triple.format(this.obj) + ")";
    }

    public static String format(Term term) {
        StringBuffer sb = new StringBuffer();
        if (term == null) {
            sb.append("<null>");
        } else {
            if (term instanceof Variable) {
                sb.append("?");
            }
            sb.append(URIUtils.getLocalName(term.toString()));
        }
        return sb.toString();
    }
}

