/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.ATermUtils;

public class ExplanationTable {
    private Map hierarchy;
    private Map conjUCMap;

    public ExplanationTable() {
        this.hierarchy = new HashMap();
        this.conjUCMap = new HashMap();
    }

    public ExplanationTable(ExplanationTable table) {
        this.hierarchy = new HashMap(table.hierarchy);
        this.conjUCMap = new HashMap(table.conjUCMap);
    }

    public void add(ATermAppl axiom) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(axiom) : DependencySet.INDEPENDENT;
        this.add(axiom, ds);
    }

    public void add(ATermAppl axiom, DependencySet ds) {
        if (axiom.getName().equals("same")) {
            ATermAppl a = (ATermAppl)axiom.getArgument(0);
            ATermAppl b = (ATermAppl)axiom.getArgument(1);
            this.hierarchy.put(ATermUtils.makeSame(ATermUtils.normalize(a), ATermUtils.normalize(b)), ds);
            this.addSub(ATermUtils.makeSub(a, b), ds);
            this.addSub(ATermUtils.makeSub(b, a), ds);
        } else if (axiom.getName().equals("sub")) {
            this.addSub(axiom, ds);
        } else {
            throw new RuntimeException("'add' takes only class axioms (sub and same)");
        }
    }

    private void addSub(ATermAppl axiom, DependencySet ds) {
        DependencySet originalDS;
        ATermAppl a1 = (ATermAppl)axiom.getArgument(0);
        ATermAppl a2 = (ATermAppl)axiom.getArgument(1);
        a1 = ATermUtils.normalize(a1);
        a2 = ATermUtils.normalize(a2);
        axiom = ATermUtils.makeSub(a1, a2);
        if (ATermUtils.isAnd(a2)) {
            ATermList cs = (ATermList)a2.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                ATermAppl newAxiom = ATermUtils.makeSub(a1, conj);
                this.add(newAxiom, ds);
                cs = cs.getNext();
            }
        }
        if ((originalDS = (DependencySet)this.hierarchy.get(axiom)) != null) {
            ds = ds.union(originalDS, true);
        }
        this.hierarchy.put(axiom, ds);
    }

    public DependencySet get(ATermAppl atermAxiom) {
        ATermAppl a1 = (ATermAppl)atermAxiom.getArgument(0);
        ATermAppl a2 = (ATermAppl)atermAxiom.getArgument(1);
        if (atermAxiom.getName().equals("same")) {
            atermAxiom = ATermUtils.makeSame(ATermUtils.normalize(a1), ATermUtils.normalize(a2));
        } else if (atermAxiom.getName().equals("sub")) {
            atermAxiom = ATermUtils.makeSub(ATermUtils.normalize(a1), ATermUtils.normalize(a2));
        }
        DependencySet ds = (DependencySet)this.hierarchy.get(atermAxiom);
        if (ds == null) {
            a1 = ATermUtils.normalize(ATermUtils.negate(a1));
            a2 = ATermUtils.normalize(ATermUtils.negate(a2));
            ATermAppl notAxiom = null;
            notAxiom = atermAxiom.getName().equals("same") ? ATermUtils.makeSame(a1, a2) : ATermUtils.makeSub(a1, a2);
            ds = (DependencySet)this.hierarchy.get(notAxiom);
        }
        return ds;
    }

    public void addConjunctUCAxioms(ATerm conj, Set axioms) {
        this.conjUCMap.put(conj, axioms);
    }

    public Set getConjunctUCAxioms(ATerm conj) {
        if (this.conjUCMap.containsKey(conj)) {
            return (Set)this.conjUCMap.get(conj);
        }
        return new HashSet();
    }
}

