/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATermAppl;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class ATermTests
extends PelletTestCase {
    public static ATermAppl a = ATermTests.term("a");
    public static ATermAppl b = ATermTests.term("b");
    public static ATermAppl c = ATermTests.term("c");
    public static ATermAppl p = ATermTests.term("p");
    public static ATermAppl q = ATermTests.term("q");
    public static ATermAppl r = ATermTests.term("r");

    public void testNNF() {
        this.testNNF(ATermTests.not(ATermTests.some(p, c)), ATermTests.all(p, ATermTests.not(c)));
        this.testNNF(ATermTests.not(ATermTests.all(p, c)), ATermTests.some(p, ATermTests.not(c)));
        this.testNNF(ATermTests.not(ATermTests.min(p, 1, c)), ATermTests.max(p, 0, c));
        this.testNNF(ATermTests.not(ATermTests.max(p, 0, c)), ATermTests.min(p, 1, c));
        this.testNNF(ATermTests.not(ATermTests.max(p, 1, ATermTests.not(ATermTests.some(p, c)))), ATermTests.min(p, 2, ATermTests.all(p, ATermTests.not(c))));
    }

    private void testNNF(ATermAppl c, ATermAppl expected) {
        ATermTests.assertEquals((Object)expected, (Object)ATermUtils.nnf(c));
    }

    public void testNormalize() {
        this.testNormalize(ATermTests.some(p, ATermTests.not(c)), ATermTests.not(ATermTests.all(p, c)));
        this.testNormalize(ATermTests.all(p, ATermTests.not(c)), ATermTests.all(p, ATermTests.not(c)));
        this.testNormalize(ATermTests.all(p, ATermTests.some(q, c)), ATermTests.all(p, ATermTests.not(ATermTests.all(q, ATermTests.not(c)))));
        this.testNormalize(ATermTests.min(p, 1, ATermTests.not(ATermTests.not(c))), ATermTests.min(p, 1, c));
        this.testNormalize(ATermTests.min(p, 1, ATermTests.some(p, c)), ATermTests.min(p, 1, ATermTests.not(ATermTests.all(p, ATermTests.not(c)))));
        this.testNormalize(ATermTests.min(p, 0, c), ATermUtils.TOP);
        this.testNormalize(ATermTests.min(p, 1, ATermUtils.BOTTOM), ATermUtils.BOTTOM);
        this.testNormalize(ATermTests.max(p, 0, c), ATermTests.not(ATermTests.min(p, 1, c)));
        this.testNormalize(ATermTests.max(p, 1, c), ATermTests.not(ATermTests.min(p, 2, c)));
        this.testNormalize(ATermTests.max(p, 1, ATermTests.not(ATermTests.some(p, ATermTests.not(ATermTests.not(c))))), ATermTests.not(ATermTests.min(p, 2, ATermTests.all(p, ATermTests.not(c)))));
        this.testNormalize(ATermTests.max(p, 1, ATermUtils.BOTTOM), ATermUtils.TOP);
        this.testNormalize(ATermTests.some(p, ATermTests.not(ATermTests.value(a))), ATermTests.not(ATermTests.all(p, ATermTests.value(a))));
    }

    private void testNormalize(ATermAppl c, ATermAppl expected) {
        ATermTests.assertEquals((Object)expected, (Object)ATermUtils.normalize(c));
    }

    public void testFindPrimitives() {
        this.testFindPrimitives(ATermTests.some(p, ATermTests.not(c)), new ATermAppl[]{c});
        this.testFindPrimitives(ATermTests.and(c, b, ATermTests.all(p, a)), new ATermAppl[]{a, b, c});
        this.testFindPrimitives(ATermTests.max(p, 1, ATermTests.not(ATermTests.some(p, ATermTests.or(a, b)))), new ATermAppl[]{a, b});
        this.testFindPrimitives(ATermTests.min(p, 2, ATermTests.or(a, ATermTests.and(b, ATermTests.not(c)))), new ATermAppl[]{a, b, c});
        this.testFindPrimitives(ATermTests.and(ATermTests.some(p, ATermUtils.TOP), ATermTests.all(p, a), ATermTests.and(ATermTests.some(p, ATermTests.value(r)), ATermTests.or(ATermTests.self(p), ATermTests.max(p, 1, b)))), new ATermAppl[]{ATermUtils.TOP, a, b});
    }

    private void testFindPrimitives(ATermAppl c, ATermAppl[] expected) {
        this.assertIteratorValues(ATermUtils.findPrimitives(c).iterator(), expected);
    }
}

