/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import java.net.URI;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.WebOntTester;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public class OWLAPIWebOntTester
implements WebOntTester {
    OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    Reasoner reasoner;

    public void classify() {
        this.reasoner.getKB().realize();
    }

    public boolean isConsistent() {
        return this.reasoner.isConsistent();
    }

    public boolean isEntailed(String entailmentFileURI) {
        try {
            OWLOntology ont = this.manager.loadOntology(URI.create(entailmentFileURI));
            return this.reasoner.isEntailed(ont);
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInputOntology(String inputFileURI) {
        try {
            OWLOntology ont = this.manager.loadOntology(URI.create(inputFileURI));
            this.reasoner = new Reasoner(this.manager);
            this.reasoner.setOntology(ont);
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTimeout(long timeout) {
        this.reasoner.getKB().setTimeout(timeout);
    }
}

