/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletTestCase
extends TestCase {
    static ATermAppl TOP = ATermUtils.TOP;
    static ATermAppl BOTTOM = ATermUtils.BOTTOM;

    public static <T> Set<T> set(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static ATermAppl term(String s) {
        return ATermUtils.makeTermAppl(s);
    }

    public static ATermList list(ATermAppl ... args) {
        return ATermUtils.makeList(args);
    }

    public static ATermAppl not(ATermAppl c) {
        return ATermUtils.makeNot(c);
    }

    public static ATermAppl all(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeAllValues(r, c);
    }

    public static ATermAppl some(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeSomeValues(r, c);
    }

    public static ATermAppl min(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeMin((ATerm)r, n, (ATerm)c);
    }

    public static ATermAppl max(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeMax((ATerm)r, n, (ATerm)c);
    }

    public static ATermAppl card(ATermAppl r, int n, ATermAppl c) {
        return PelletTestCase.and(PelletTestCase.min(r, n, c), PelletTestCase.max(r, n, c));
    }

    public static ATermAppl inv(ATermAppl r) {
        return ATermUtils.makeInv(r);
    }

    public static ATermAppl literal(String value) {
        return ATermUtils.makePlainLiteral(value);
    }

    public static ATermAppl plainLiteral(String value, String lang) {
        return ATermUtils.makePlainLiteral(value, lang);
    }

    public static ATermAppl typedLiteral(String value, String dt) {
        return ATermUtils.makeTypedLiteral(value, dt);
    }

    public static ATermAppl value(ATermAppl r) {
        return ATermUtils.makeValue(r);
    }

    public static ATermAppl and(ATermAppl c1, ATermAppl c2, ATermAppl c3) {
        return PelletTestCase.and(new ATermAppl[]{c1, c2, c3});
    }

    public static ATermAppl and(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeAnd(c1, c2);
    }

    public static ATermAppl and(ATermAppl[] c) {
        return ATermUtils.makeAnd(ATermUtils.makeList(c));
    }

    public static ATermAppl or(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr(c1, c2);
    }

    public static ATermAppl or(ATermAppl[] c) {
        return ATermUtils.makeOr(ATermUtils.makeList(c));
    }

    public static ATermAppl self(ATermAppl p) {
        return ATermUtils.makeSelf(p);
    }

    protected boolean isAnonValue(Object n) {
        return n instanceof Resource && ((Resource)n).isAnon() || n instanceof Statement && ((Statement)n).getSubject().isAnon() || n instanceof Statement && this.isAnonValue(((Statement)n).getObject());
    }

    public void assertIteratorContains(Iterator it, Object val) {
        boolean found = false;
        while (it.hasNext() && !found) {
            Object obj = it.next();
            found = obj.equals(val);
        }
        TestCase.assertTrue((String)(this.getName() + " failed to find expected iterator value: " + val), (boolean)found);
    }

    public void assertIteratorValues(Iterator it, Iterator test) {
        ArrayList list = new ArrayList();
        while (test.hasNext()) {
            list.add(test.next());
        }
        this.assertIteratorValues(it, list.toArray());
    }

    public void assertIteratorValues(Iterator it, Object[] vals) {
        boolean[] found = new boolean[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            found[i] = false;
        }
        while (it.hasNext()) {
            Object n = it.next();
            boolean gotit = false;
            for (int i = 0; i < vals.length; ++i) {
                if (!n.equals(vals[i])) continue;
                gotit = true;
                found[i] = true;
            }
            PelletTestCase.assertTrue((String)(this.getName() + " found unexpected iterator value: " + n), (boolean)gotit);
        }
        ArrayList<Object> unfound = new ArrayList<Object>();
        for (int i = 0; i < vals.length; ++i) {
            if (found[i]) continue;
            unfound.add(vals[i]);
        }
        PelletTestCase.assertTrue((String)(this.getName() + " failed to find expected iterator values: " + unfound), (boolean)unfound.isEmpty());
    }

    public void testResultSet(ResultSet results, List ans) {
        ArrayList answers = new ArrayList(ans);
        while (results.hasNext()) {
            QuerySolution sol = results.nextSolution();
            PelletTestCase.assertNotNull((String)"QuerySolution", (Object)sol);
            HashMap<String, RDFNode> answer = new HashMap<String, RDFNode>();
            for (String var : results.getResultVars()) {
                RDFNode val = sol.get(var);
                PelletTestCase.assertNotNull((String)("Variable: " + var), (Object)val);
                answer.put(var, val);
            }
            PelletTestCase.assertTrue((String)("Unexpected binding found: " + answer), (boolean)answers.remove(answer));
        }
        PelletTestCase.assertTrue((String)("Binding not found: " + answers), (boolean)answers.isEmpty());
    }

    public Map createBinding(Object[] keys, Object[] values) {
        PelletTestCase.assertTrue((keys.length == values.length ? 1 : 0) != 0);
        HashMap<Object, Object> answer = new HashMap<Object, Object>();
        for (int i = 0; i < keys.length; ++i) {
            answer.put(keys[i], values[i]);
        }
        return answer;
    }

    public List createBindings(Object[] keys, Object[][] values) {
        ArrayList answers = new ArrayList();
        for (int i = 0; i < values.length; ++i) {
            HashMap<Object, Object> answer = new HashMap<Object, Object>();
            for (int j = 0; j < keys.length; ++j) {
                answer.put(keys[j], values[i][j]);
            }
            answers.add(answer);
        }
        return answers;
    }

    public Map createMap(Object[][] values) {
        HashMap map = new HashMap();
        for (int i = 0; i < values.length; ++i) {
            HashSet<Object> set = new HashSet<Object>();
            for (int j = 1; j < values[i].length; ++j) {
                set.add(values[i][j]);
            }
            map.put(values[i][0], set);
        }
        return map;
    }

    public void printAll(Iterator i) {
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public void printAll(Iterator i, String head) {
        System.out.print(head + ": ");
        if (i.hasNext()) {
            System.out.println();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        } else {
            System.out.println("<EMPTY>");
        }
    }

    public void assertSatisfiable(KnowledgeBase kb, ATermAppl c) {
        this.assertSatisfiable(kb, c, true);
    }

    public void assertUnsatisfiable(KnowledgeBase kb, ATermAppl c) {
        this.assertSatisfiable(kb, c, false);
    }

    public void assertSatisfiable(KnowledgeBase kb, ATermAppl c, boolean isSatisfiable) {
        PelletTestCase.assertEquals((String)("Satisfiability for " + c + " failed"), (boolean)isSatisfiable, (boolean)kb.isSatisfiable(c));
    }

    public void assertSubClass(KnowledgeBase kb, String c1, String c2) {
        this.assertSubClass(kb, PelletTestCase.term(c1), PelletTestCase.term(c2));
    }

    public void assertSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2) {
        this.assertSubClass(kb, c1, c2, true);
    }

    public void assertNotSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2) {
        this.assertSubClass(kb, c1, c2, false);
    }

    public void assertSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2, boolean isSubClass) {
        boolean[] result = new boolean[2];
        result[0] = kb.isSubClassOf(c1, c2);
        PelletTestCase.assertEquals((String)"Satisfiability failed", (boolean)result[0], (boolean)isSubClass);
        kb.isSatisfiable(c1);
        kb.isSatisfiable(PelletTestCase.not(c1));
        kb.isSatisfiable(c2);
        kb.isSatisfiable(PelletTestCase.not(c2));
        long satCount = kb.getABox().satisfiabilityCount;
        result[1] = kb.isSubClassOf(c1, c2);
        boolean cached = satCount == kb.getABox().satisfiabilityCount;
        PelletTestCase.assertEquals((String)"Merging failed", (boolean)result[1], (boolean)isSubClass);
    }

    public boolean[] testType(KnowledgeBase kb, String c1, String c2) {
        return this.testType(kb, PelletTestCase.term(c1), PelletTestCase.term(c2));
    }

    public boolean[] testType(KnowledgeBase kb, ATermAppl ind, ATermAppl c) {
        boolean[] result = new boolean[2];
        result[0] = kb.isType(ind, c);
        kb.isSatisfiable(c);
        kb.isSatisfiable(PelletTestCase.not(c));
        long satCount = kb.getABox().satisfiabilityCount;
        result[1] = kb.isType(ind, c);
        boolean cached = satCount == kb.getABox().satisfiabilityCount;
        return result;
    }
}

