/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.test.MiscTests;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class TracingTests
extends PelletTestCase {
    private KnowledgeBase kb;
    private boolean old_USE_TRACING;
    private ATermAppl bob = ATermUtils.makeTermAppl("Bob");
    private ATermAppl robert = ATermUtils.makeTermAppl("Robert");
    private ATermAppl mary = ATermUtils.makeTermAppl("Mary");
    private ATermAppl victor = ATermUtils.makeTermAppl("Victor");
    private ATermAppl email = ATermUtils.makeTermAppl("MaryAndBob@example.com");
    private ATermAppl mbox = ATermUtils.makeTermAppl("mbox");
    private ATermAppl relative = ATermUtils.makeTermAppl("relative");
    private ATermAppl sibling = ATermUtils.makeTermAppl("sibling");
    private ATermAppl person = ATermUtils.makeTermAppl("person");
    private ATermAppl human = ATermUtils.makeTermAppl("human");
    private ATermAppl ssn = ATermUtils.makeTermAppl("ssn");

    public void setUp() {
        this.old_USE_TRACING = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        this.kb = new KnowledgeBase();
        this.kb.setDoExplanation(true);
    }

    protected void tearDown() throws Exception {
        PelletOptions.USE_TRACING = this.old_USE_TRACING;
    }

    public void testAntiSymmetric() {
        this.kb.addObjectProperty(this.mbox);
        this.kb.addAntisymmetricProperty(this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.email);
        this.kb.addPropertyValue(this.mbox, this.robert, this.email);
        this.kb.addPropertyValue(this.mbox, this.email, this.robert);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeAntisymmetric(this.mbox), ATermUtils.makePropAtom(this.mbox, this.robert, this.email), ATermUtils.makePropAtom(this.mbox, this.email, this.robert)});
    }

    public void testCourse() {
        String ns = "http://test/course.owl#";
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.load(MiscTests.base + "testCourse.owl");
        KnowledgeBase kb = reasoner.getKB();
        kb.isConsistent();
        TracingTests.assertFalse((boolean)kb.isConsistent());
        ATermAppl M1 = TracingTests.term(ns + "M1");
        ATermAppl W1 = TracingTests.term(ns + "W1");
        ATermAppl C1 = TracingTests.term(ns + "C1");
        ATermAppl P1 = TracingTests.term(ns + "P1");
        ATermAppl C2 = TracingTests.term(ns + "C2");
        ATermAppl Man = TracingTests.term(ns + "Man");
        ATermAppl Woman = TracingTests.term(ns + "Woman");
        ATermAppl isTaughtBy = TracingTests.term(ns + "isTaughtBy");
        Set<ATermAppl> explanation = kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeTypeAtom(M1, Man), ATermUtils.makePropAtom(isTaughtBy, C1, M1), ATermUtils.makePropAtom(isTaughtBy, C1, P1), ATermUtils.makeTypeAtom(W1, Woman), ATermUtils.makePropAtom(isTaughtBy, C2, W1), ATermUtils.makePropAtom(isTaughtBy, C2, P1), ATermUtils.makeFunctional(isTaughtBy), ATermUtils.makeDisjoint(Man, Woman)});
    }

    public void testDatatypeStatement() {
        this.kb.addDatatypeProperty(this.ssn);
        this.kb.addIndividual(this.robert);
        ATermAppl ssn1 = ATermUtils.makeTypedLiteral("bob", XSD.nonNegativeInteger.toString());
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
        TracingTests.assertTrue((boolean)explanation.contains(ATermUtils.makePropAtom(this.ssn, this.robert, ssn1)));
    }

    public void testDomain() {
        ATermAppl notPerson = ATermUtils.makeNot(this.person);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addDomain(this.sibling, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.robert, notPerson);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain(this.sibling, this.person), ATermUtils.makeTypeAtom(this.robert, notPerson), ATermUtils.makePropAtom(this.sibling, this.robert, this.victor)});
    }

    public void testDomainRangeInverse() {
        ATermAppl notPerson = ATermUtils.makeNot(this.person);
        ATermAppl dog = ATermUtils.makeTermAppl("dog");
        this.kb.addClass(dog);
        this.kb.addClass(this.person);
        this.kb.addEquivalentClass(dog, notPerson);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addDomain(this.sibling, this.person);
        this.kb.addRange(this.sibling, notPerson);
        this.kb.addInverseProperty(this.sibling, this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain(this.sibling, this.person), ATermUtils.makeRange(this.sibling, notPerson), ATermUtils.makeInvProp(this.sibling, this.sibling), ATermUtils.makePropAtom(this.sibling, this.robert, this.victor)});
    }

    public void testDomainRangeSymmetric() {
        ATermAppl notPerson = ATermUtils.makeNot(this.person);
        ATermAppl dog = ATermUtils.makeTermAppl("dog");
        this.kb.addClass(dog);
        this.kb.addClass(this.person);
        this.kb.addEquivalentClass(dog, notPerson);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addDomain(this.sibling, this.person);
        this.kb.addRange(this.sibling, notPerson);
        this.kb.addSymmetricProperty(this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain(this.sibling, this.person), ATermUtils.makeRange(this.sibling, notPerson), ATermUtils.makeSymmetric(this.sibling), ATermUtils.makePropAtom(this.sibling, this.robert, this.victor)});
    }

    public void testEquivalentClass() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.human);
        this.kb.addSubClass(this.human, this.person);
        this.kb.addSubClass(this.person, this.human);
        TracingTests.assertTrue((boolean)this.kb.isEquivalentClass(this.human, this.person));
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub(this.human, this.person), ATermUtils.makeSub(this.person, this.human)});
    }

    public void testFunctionalDataProp() {
        this.kb.addDatatypeProperty(this.ssn);
        this.kb.addFunctionalProperty(this.ssn);
        this.kb.addIndividual(this.robert);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral("012345678");
        ATermAppl ssn2 = ATermUtils.makePlainLiteral("123456789");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        this.kb.addPropertyValue(this.ssn, this.robert, ssn2);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom(this.ssn, this.robert, ssn1), ATermUtils.makePropAtom(this.ssn, this.robert, ssn2), ATermUtils.makeFunctional(this.ssn)});
        TracingTests.assertTrue((explanation.size() == 3 ? 1 : 0) != 0);
    }

    public void testInverseFunctionalDataProp() {
        ATermList different = ATermUtils.makeList(this.robert).insert(this.mary);
        System.out.println("Different: " + different);
        this.kb.addObjectProperty(this.mbox);
        this.kb.addInverseFunctionalProperty(this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.email);
        this.kb.addAllDifferent(different);
        this.kb.addPropertyValue(this.mbox, this.robert, this.email);
        this.kb.addPropertyValue(this.mbox, this.mary, this.email);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom(this.mbox, this.robert, this.email), ATermUtils.makePropAtom(this.mbox, this.mary, this.email), ATermUtils.makeInverseFunctional(this.mbox), ATermUtils.makeAllDifferent(different)});
    }

    public void testIrreflexive() {
        this.kb.addObjectProperty(this.mbox);
        this.kb.addIrreflexiveProperty(this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addPropertyValue(this.mbox, this.robert, this.robert);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeIrreflexive(this.mbox), ATermUtils.makePropAtom(this.mbox, this.robert, this.robert)});
    }

    public void testMaxOneDataProp() {
        this.kb.addClass(this.person);
        this.kb.addDatatypeProperty(this.ssn);
        ATermAppl max1ssn = ATermUtils.makeMax((ATerm)this.ssn, 1, (ATerm)ATermUtils.TOP_LIT);
        this.kb.addSubClass(this.person, max1ssn);
        this.kb.addSubClass(this.person, ATermUtils.makeMin((ATerm)this.ssn, 1, (ATerm)ATermUtils.TOP_LIT));
        this.kb.addIndividual(this.robert);
        this.kb.addType(this.robert, this.person);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral("012345678");
        ATermAppl ssn2 = ATermUtils.makePlainLiteral("123456789");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        this.kb.addPropertyValue(this.ssn, this.robert, ssn2);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom(this.ssn, this.robert, ssn1), ATermUtils.makePropAtom(this.ssn, this.robert, ssn2), ATermUtils.makeSub(this.person, max1ssn), ATermUtils.makeTypeAtom(this.robert, this.person)});
    }

    public void testRange() {
        ATermAppl notPerson = ATermUtils.makeNot(this.person);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addRange(this.sibling, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.victor, notPerson);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeRange(this.sibling, this.person), ATermUtils.makeTypeAtom(this.victor, notPerson), ATermUtils.makePropAtom(this.sibling, this.robert, this.victor)});
    }

    public void testReflexive() {
        ATermAppl notPerson = ATermUtils.makeNot(this.person);
        ATermAppl bobsType = ATermUtils.makeAllValues(this.relative, notPerson);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty(this.relative);
        this.kb.addReflexiveProperty(this.relative);
        this.kb.addIndividual(this.robert);
        this.kb.addType(this.robert, this.person);
        this.kb.addType(this.robert, bobsType);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.victor, notPerson);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeReflexive(this.relative), ATermUtils.makeTypeAtom(this.robert, this.person), ATermUtils.makeTypeAtom(this.robert, bobsType)});
    }

    public void testSameAllDifferent() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.bob);
        this.kb.addIndividual(this.mary);
        ATermList list = ATermUtils.makeList(this.robert);
        list = ATermUtils.makeList(this.bob, list);
        list = ATermUtils.makeList(this.mary, list);
        this.kb.addAllDifferent(list);
        this.kb.addSame(this.robert, this.bob);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        TracingTests.assertTrue((boolean)explanation.contains(ATermUtils.makeSame(this.robert, this.bob)));
        TracingTests.assertTrue((boolean)explanation.contains(ATermUtils.makeAllDifferent(list)));
        TracingTests.assertTrue((explanation.size() == 2 ? 1 : 0) != 0);
    }

    public void testSameDifferent() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.bob);
        this.kb.addSame(this.robert, this.bob);
        this.kb.addDifferent(this.robert, this.bob);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        TracingTests.assertTrue((boolean)explanation.contains(ATermUtils.makeSame(this.robert, this.bob)));
        TracingTests.assertTrue((boolean)explanation.contains(ATermUtils.makeDifferent(this.robert, this.bob)));
        TracingTests.assertTrue((explanation.size() == 2 ? 1 : 0) != 0);
    }

    public void testSubProp1() {
        ATermAppl noRelatives = ATermUtils.makeMax((ATerm)this.relative, 0, (ATerm)ATermUtils.TOP);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.bob);
        this.kb.addObjectProperty(this.relative);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addSubProperty(this.sibling, this.relative);
        this.kb.addType(this.bob, noRelatives);
        this.kb.addPropertyValue(this.sibling, this.bob, this.mary);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSubProp(this.sibling, this.relative), ATermUtils.makePropAtom(this.sibling, this.bob, this.mary), ATermUtils.makeTypeAtom(this.bob, noRelatives)});
    }

    public void testSubProp2() {
        ATermAppl nonHumanRelatives = ATermUtils.makeAllValues(this.relative, ATermUtils.makeNot(this.person));
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.bob);
        this.kb.addObjectProperty(this.relative);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addSubProperty(this.sibling, this.relative);
        this.kb.addType(this.bob, nonHumanRelatives);
        this.kb.addType(this.mary, this.person);
        this.kb.addPropertyValue(this.sibling, this.bob, this.mary);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSubProp(this.sibling, this.relative), ATermUtils.makePropAtom(this.sibling, this.bob, this.mary), ATermUtils.makeTypeAtom(this.bob, nonHumanRelatives), ATermUtils.makeTypeAtom(this.mary, this.person)});
    }

    public void testTransitive() {
        this.kb.addObjectProperty(this.sibling);
        this.kb.addTransitiveProperty(this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        ATermAppl notVictorsSibling = ATermUtils.makeNot(ATermUtils.makeHasValue(this.sibling, this.victor));
        this.kb.addType(this.robert, notVictorsSibling);
        this.kb.addPropertyValue(this.sibling, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.mary, this.victor);
        TracingTests.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
        this.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeTypeAtom(this.robert, notVictorsSibling), ATermUtils.makeTransitive(this.sibling), ATermUtils.makePropAtom(this.sibling, this.robert, this.mary), ATermUtils.makePropAtom(this.sibling, this.mary, this.victor)});
    }

    public void testDisjunction() {
        this.kb = new KnowledgeBase();
        ATermAppl name = ATermUtils.makeTermAppl("name");
        ATermAppl hasName = ATermUtils.makeTermAppl("hasName");
        ATermAppl nameOf = ATermUtils.makeTermAppl("nameOf");
        ATermAppl dog = ATermUtils.makeTermAppl("dog");
        ATermAppl ownsAnimal = ATermUtils.makeTermAppl("ownsAnimal");
        ATermAppl notPerson = ATermUtils.negate(this.person);
        ATermAppl animal = ATermUtils.makeTermAppl("animal");
        this.kb.addClass(notPerson);
        this.kb.addClass(this.person);
        this.kb.addClass(dog);
        this.kb.addClass(name);
        this.kb.addObjectProperty(ownsAnimal);
        this.kb.addObjectProperty(hasName);
        this.kb.addObjectProperty(nameOf);
        this.kb.addInverseProperty(hasName, nameOf);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addPropertyValue(ownsAnimal, this.robert, this.victor);
        this.kb.addPropertyValue(ownsAnimal, this.mary, this.victor);
        ATermAppl existsHasName = ATermUtils.makeSomeValues(hasName, name);
        this.kb.addClass(existsHasName);
        this.kb.addSubClass(dog, existsHasName);
        ATermAppl onlyOwnsDogs = ATermUtils.makeAllValues(ownsAnimal, dog);
        ATermAppl allNameOfDog = ATermUtils.makeAllValues(nameOf, dog);
        this.kb.addClass(allNameOfDog);
        this.kb.addSubClass(name, allNameOfDog);
        ATermAppl notPersonOronlyOwnsDog = ATermUtils.makeOr(notPerson, onlyOwnsDogs);
        this.kb.addSubClass(animal, notPersonOronlyOwnsDog);
        this.kb.addType(this.robert, notPersonOronlyOwnsDog);
        this.kb.addType(this.robert, this.person);
        this.kb.addType(this.mary, notPersonOronlyOwnsDog);
        this.kb.addType(this.mary, this.person);
        this.kb.isConsistent();
        TracingTests.assertTrue((this.kb.getABox().getPseudoModel().getIndividual(this.victor).getDepends(dog).getExplanationSet().size() == 2 ? 1 : 0) != 0);
    }
}

