/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.inctest;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.Iterator;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.test.PelletTestCase;

public class IncJenaConsistencyTests
extends PelletTestCase {
    private boolean preUCQ;
    private boolean preUIC;
    private boolean preUSR;

    public void setUp() {
        this.preUCQ = PelletOptions.USE_COMPLETION_QUEUE;
        this.preUIC = PelletOptions.USE_INCREMENTAL_CONSISTENCY;
        this.preUSR = PelletOptions.USE_SMART_RESTORE;
        PelletOptions.USE_COMPLETION_QUEUE = true;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
        PelletOptions.USE_SMART_RESTORE = false;
    }

    protected void tearDown() throws Exception {
        PelletOptions.USE_COMPLETION_QUEUE = this.preUCQ;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = this.preUIC;
        PelletOptions.USE_SMART_RESTORE = this.preUSR;
    }

    public void testTBoxChange() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        p.addRDFType(OWL.InverseFunctionalProperty);
        p.addRange(XSD.xboolean);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)p, 1));
        Individual i1 = model.createIndividual(ns + "i1", (Resource)C);
        Individual i2 = model.createIndividual(ns + "i2", (Resource)C);
        Individual i3 = model.createIndividual(ns + "i3", (Resource)C);
        model.prepare();
        OntClass D = model.createClass(ns + "D");
        OntClass E = model.createClass(ns + "E");
        D.addDisjointWith((Resource)E);
        Individual i4 = model.createIndividual(ns + "i4", (Resource)D);
        PelletInfGraph graph = (PelletInfGraph)model.getGraph();
        model.prepare();
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent") == null ? 1 : 0) != 0);
        this.assertIteratorValues((Iterator)model.listIndividuals(), new Resource[]{i1, i2, i3, i4});
        i4.addRDFType((Resource)C);
        model.prepare();
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 1L ? 1 : 0) != 0);
    }

    public void testTypeAssertions() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        p.addRDFType(OWL.InverseFunctionalProperty);
        p.addRange(XSD.xboolean);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)p, 1));
        OntClass D = model.createClass(ns + "D");
        OntClass E = model.createClass(ns + "E");
        D.addDisjointWith((Resource)E);
        RDFList conj = model.createList(new RDFNode[]{D, C});
        IntersectionClass CONJ = model.createIntersectionClass(null, conj);
        Individual i1 = model.createIndividual(ns + "i1", (Resource)C);
        i1.addRDFType((Resource)D);
        Individual i2 = model.createIndividual(ns + "i2", (Resource)C);
        i2.addRDFType((Resource)D);
        Individual i3 = model.createIndividual(ns + "i3", (Resource)C);
        i3.addRDFType((Resource)E);
        model.prepare();
        Individual i4 = model.createIndividual(ns + "i4", (Resource)D);
        PelletInfGraph graph = (PelletInfGraph)model.getGraph();
        model.prepare();
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() > 0L ? 1 : 0) != 0);
        this.assertIteratorValues((Iterator)model.listIndividuals(), new Resource[]{i1, i2, i3, i4});
        i4.addRDFType((Resource)model.createCardinalityRestriction(null, (Property)p, 1));
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        model.prepare();
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
        i4.addRDFType((Resource)E);
        IncJenaConsistencyTests.assertFalse((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() > 0L ? 1 : 0) != 0);
        i4.removeRDFType((Resource)E);
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        model.prepare();
        IncJenaConsistencyTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
        ObjectProperty op = model.createObjectProperty(ns + "op");
        i2.addProperty((Property)op, (RDFNode)i4);
        model.prepare();
        IncJenaConsistencyTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
        i2.addRDFType((Resource)CONJ);
        model.prepare();
        IncJenaConsistencyTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
    }

    public void testPropertyAssertions() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        ObjectProperty op = model.createObjectProperty(ns + "op");
        OntClass C = model.createClass(ns + "C");
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Individual b = model.createIndividual(ns + "b", (Resource)C);
        Literal one = model.createTypedLiteral("1", TypeMapper.getInstance().getTypeByName(XSD.positiveInteger.getURI()));
        a.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        PelletInfGraph graph = (PelletInfGraph)model.getGraph();
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent") == null ? 1 : 0) != 0);
        this.assertIteratorValues((Iterator)a.listPropertyValues((Property)dp), new Literal[]{one});
        a.addProperty((Property)op, (RDFNode)b);
        model.prepare();
        this.assertIteratorValues((Iterator)a.listPropertyValues((Property)op), new Resource[]{b});
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() > 0L ? 1 : 0) != 0);
        Literal two = model.createTypedLiteral("2", TypeMapper.getInstance().getTypeByName(XSD.positiveInteger.getURI()));
        b.addProperty((Property)dp, (RDFNode)two);
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        graph.getKB().isConsistent();
        this.assertIteratorValues((Iterator)b.listPropertyValues((Property)dp), new Literal[]{two});
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() > 0L ? 1 : 0) != 0);
    }

    public void testBnodeUpdates() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        ObjectProperty op = model.createObjectProperty(ns + "op");
        OntClass C = model.createClass(ns + "C");
        Individual anon1 = model.createIndividual((Resource)C);
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Literal one = model.createTypedLiteral("1", TypeMapper.getInstance().getTypeByName(XSD.positiveInteger.getURI()));
        a.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        PelletInfGraph graph = (PelletInfGraph)model.getGraph();
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent") == null ? 1 : 0) != 0);
        this.assertIteratorValues((Iterator)a.listPropertyValues((Property)dp), new Literal[]{one});
        a.addProperty((Property)op, (RDFNode)anon1);
        model.prepare();
        this.assertIteratorValues((Iterator)a.listPropertyValues((Property)op), new Resource[]{anon1});
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() > 0L ? 1 : 0) != 0);
        Individual anon2 = model.createIndividual((Resource)C);
        anon2.addProperty((Property)op, (RDFNode)a);
        model.prepare();
        this.assertIteratorValues((Iterator)anon2.listPropertyValues((Property)op), new Resource[]{a});
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 2L ? 1 : 0) != 0);
    }

    public void testAnonClasses() {
        OntModel ontmodel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        String nc = "urn:test:";
        OntClass class1 = ontmodel.createClass(nc + "C1");
        OntClass class2 = ontmodel.createClass(nc + "C2");
        Individual[] inds = new Individual[6];
        for (int j = 0; j < 6; ++j) {
            inds[j] = ontmodel.createIndividual(nc + "Ind" + j, OWL.Thing);
        }
        inds[0].addRDFType((Resource)class1);
        inds[1].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class1);
        inds[3].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class2);
        inds[3].addRDFType((Resource)class2);
        inds[4].addRDFType((Resource)class2);
        inds[5].addRDFType((Resource)class2);
        ontmodel.prepare();
        this.assertIteratorValues((Iterator)class1.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3]});
        this.assertIteratorValues((Iterator)class2.listInstances(), new Resource[]{inds[2], inds[3], inds[4], inds[5]});
        PelletInfGraph graph = (PelletInfGraph)ontmodel.getGraph();
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent") == null ? 1 : 0) != 0);
        inds[4].addRDFType((Resource)class1);
        inds[5].addRDFType((Resource)class1);
        ontmodel.prepare();
        this.assertIteratorValues((Iterator)class1.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5]});
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 1L ? 1 : 0) != 0);
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        RDFList list = ontmodel.createList(new RDFNode[]{class1, class2});
        IntersectionClass class3 = ontmodel.createIntersectionClass(null, list);
        UnionClass class4 = ontmodel.createUnionClass(null, list);
        ontmodel.prepare();
        this.assertIteratorValues((Iterator)class3.listInstances(), new Resource[]{inds[2], inds[3], inds[4], inds[5]});
        this.assertIteratorValues((Iterator)class4.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5]});
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        Individual newind = ontmodel.createIndividual(nc + "Ind7", (Resource)class4);
        ontmodel.prepare();
        IncJenaConsistencyTests.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
        this.assertIteratorValues((Iterator)class4.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5], newind});
    }
}

